package net.xisberto.timerpx.database

import androidx.lifecycle.LiveData

class TimerRepository(private val database: Database) {
    val allTimers: LiveData<List<TimerDef>> = database.timerDao().getAll()

    fun insert(timerDef: TimerDef) = database.timerDao().insert(timerDef)

    fun delete(timerDef: TimerDef) = database.timerDao().delete(timerDef)
}