package net.xisberto.timerpx

import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.WindowCompat
import androidx.fragment.app.commit
import androidx.fragment.app.replace
import com.google.android.material.shape.MaterialShapeDrawable
import net.xisberto.timerpx.databinding.ActivityMainBinding
import net.xisberto.timerpx.settings.SettingsActivity
import net.xisberto.timerpx.timer_list.TimerDefFragment
import net.xisberto.timerpx.util.hasAlarmApps

class MainActivity : AppCompatActivity(R.layout.activity_main) {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        WindowCompat.setDecorFitsSystemWindows(window, true)
        super.onCreate(savedInstanceState)

        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.appBarLayout.statusBarForeground =
            MaterialShapeDrawable.createWithElevationOverlay(this)

        binding.toolbar.setOnMenuItemClickListener { menuItem ->
            Log.d("MainApp", "menu item clicked")
            when (menuItem.itemId) {
                R.id.menu_about -> {
                    startActivity(Intent(this, SettingsActivity::class.java))
                    true
                }
                else -> false
            }
        }

        if (savedInstanceState == null) {
            if (hasAlarmApps(this)) {
                supportFragmentManager.commit {
                    setReorderingAllowed(true)
                    replace<TimerDefFragment>(R.id.main_content)
                }
            } else {
                supportFragmentManager.commit {
                    setReorderingAllowed(true)
                    replace<NoAlarmAppFragment>(R.id.main_content)
                }
            }
        }
    }
}