# About Thunderbird for Android

Thunderbird for Android (TfA) is a powerful, privacy‑focused email app for managing multiple accounts with ease —
including a Unified Inbox for maximum productivity. It’s open source, built with the community, and never treats your
private data as a product.

This page is for both **users** and **contributors**:
- If you want to use Thunderbird for Android, see [Download](#download).
- If you want to contribute, jump to [Contributing](#contributing).

## 📥 Download

You can get Thunderbird for Android from multiple sources:
- [Google Play](https://play.google.com/store/apps/details?id=net.thunderbird.android)
- [F-Droid](https://f-droid.org/packages/net.thunderbird.android)
- [Beta (early access) on Google Play](https://play.google.com/store/apps/details?id=net.thunderbird.android.beta)
- [Beta on F-Droid](https://f-droid.org/packages/net.thunderbird.android.beta)
- [GitHub Releases](https://github.com/thunderbird/thunderbird-android/releases)

Check the [Release Notes](https://github.com/thunderbird/thunderbird-android/releases) to see what’s new in each version.

## ✨ Highlights

- Unified Inbox and multiple account support
- Open source, privacy‑respecting by design
- Modern, fast UI with helpful features like powerful search and rich composer
- Actively developed with regular updates

## 📨 K‑9 Mail heritage

Thunderbird for Android is based on **K‑9 Mail**, a long‑standing open source email app. The projects share much of
the same code and therefore may look and feel similar.

Some features are selectively enabled in Thunderbird when they are a better fit for Thunderbird users (e.g., import from K‑9).

If you prefer to keep using K‑9 Mail, you can find it here:
- [Google Play](https://play.google.com/store/apps/details?id=com.fsck.k9)
- [F‑Droid](https://f-droid.org/packages/com.fsck.k9/)

## ❓ Need help or have feedback?

- [Knowledge base](https://support.mozilla.org/products/thunderbird-android)
- [FAQ](https://support.mozilla.org/kb/thunderbird-android-8-faq)
- [Support forum](https://support.mozilla.org/en-US/questions/new/thunderbird-android)
- [Bug tracker](https://github.com/thunderbird/thunderbird-android/issues)
- [Ideas & voting](https://connect.mozilla.org/t5/ideas/idb-p/ideas/label-name/thunderbird%20android)

Community chat (Matrix):
- [General](https://matrix.to/#/#tb-android:mozilla.org)
- [Development](https://matrix.to/#/#tb-android-dev:mozilla.org)
- [Thunderbird community space](https://matrix.to/#/#thunderbird-community:mozilla.org)

## 🤝 Contributing

We welcome contributions of all kinds:
- Development: [Contributing Guide](CONTRIBUTING.md) if you want to help with code
- Translations: [Weblate Project](https://hosted.weblate.org/projects/tb-android/) if you want to help localize the app
- [Other ways to help](https://blog.thunderbird.net/2024/09/contribute-to-thunderbird-for-android/)
- [Participation guidelines](https://www.mozilla.org/about/governance/policies/participation/)
