package net.thunderbird.core.preference.display.visualSettings.message.list

const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CORRESPONDENT_NAMES = true
const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CONTACT_NAME = false
const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CONTACT_PICTURE = true
const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_CHANGE_CONTACT_NAME_COLOR = true
const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_COLORIZE_MISSING_CONTACT_PICTURE = true
const val MESSAGE_LIST_SETTINGS_DEFAULT_IS_USE_BACKGROUND_AS_INDICATOR = false
const val MESSAGE_LIST_SETTINGS_DEFAULT_PREVIEW_LINES = 2
val MESSAGE_LIST_SETTINGS_DEFAULT_UI_DENSITY = UiDensity.Default
const val DISPLAY_SETTINGS_DEFAULT_CONTACT_NAME_COLOR = 0xFF1093F5.toInt()

data class DisplayMessageListSettings(
    val isShowCorrespondentNames: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CORRESPONDENT_NAMES,
    val isShowContactName: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CONTACT_NAME,
    val isShowContactPicture: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_SHOW_CONTACT_PICTURE,
    val isChangeContactNameColor: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_CHANGE_CONTACT_NAME_COLOR,
    val isColorizeMissingContactPictures: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_COLORIZE_MISSING_CONTACT_PICTURE,
    val isUseBackgroundAsUnreadIndicator: Boolean = MESSAGE_LIST_SETTINGS_DEFAULT_IS_USE_BACKGROUND_AS_INDICATOR,
    val previewLines: Int = MESSAGE_LIST_SETTINGS_DEFAULT_PREVIEW_LINES,
    val uiDensity: UiDensity = MESSAGE_LIST_SETTINGS_DEFAULT_UI_DENSITY,
    val contactNameColor: Int = DISPLAY_SETTINGS_DEFAULT_CONTACT_NAME_COLOR,
)
