/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DERInteger;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERUTF8String;
import org.spongycastle.asn1.cmp.PKIFreeText;
import org.spongycastle.asn1.cmp.PKIStatusInfo;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.tsp.TimeStampResp;
import org.spongycastle.tsp.TSPException;
import org.spongycastle.tsp.TSPValidationException;
import org.spongycastle.tsp.TimeStampRequest;
import org.spongycastle.tsp.TimeStampResponse;
import org.spongycastle.tsp.TimeStampTokenGenerator;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms) {
        this(tokenGenerator, acceptedAlgorithms, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies) {
        this(tokenGenerator, acceptedAlgorithms, acceptedPolicies, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies, Set acceptedExtensions) {
        this.tokenGenerator = tokenGenerator;
        this.acceptedAlgorithms = this.convert(acceptedAlgorithms);
        this.acceptedPolicies = this.convert(acceptedPolicies);
        this.acceptedExtensions = this.convert(acceptedExtensions);
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String statusString) {
        this.statusStrings.add((ASN1Encodable)new DERUTF8String(statusString));
    }

    private void setFailInfoField(int field) {
        this.failInfo |= field;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new DERInteger(this.status));
        if (this.statusStrings.size() > 0) {
            v.add((ASN1Encodable)PKIFreeText.getInstance((Object)new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            FailInfo failInfoBitString = new FailInfo(this.failInfo);
            v.add((ASN1Encodable)failInfoBitString);
        }
        return PKIStatusInfo.getInstance((Object)new DERSequence(v));
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        TimeStampResp resp;
        try {
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions, provider);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            ContentInfo tstTokenContentInfo = null;
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime, provider).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
                tstTokenContentInfo = ContentInfo.getInstance((Object)aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e) {
            this.status = 2;
            this.setFailInfoField(e.getFailureCode());
            this.addStatusString(e.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        TimeStampResp resp;
        try {
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            ContentInfo tstTokenContentInfo = null;
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
                tstTokenContentInfo = ContentInfo.getInstance((Object)aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e) {
            this.status = 2;
            this.setFailInfoField(e.getFailureCode());
            this.addStatusString(e.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateFailResponse(int status, int failInfoField, String statusString) throws TSPException {
        this.status = status;
        this.setFailInfoField(failInfoField);
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
        TimeStampResp resp = new TimeStampResp(pkiStatusInfo, null);
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    private Set convert(Set orig) {
        if (orig == null) {
            return orig;
        }
        HashSet<Object> con = new HashSet<Object>(orig.size());
        for (Object o : orig) {
            if (o instanceof String) {
                con.add(new ASN1ObjectIdentifier((String)o));
                continue;
            }
            con.add(o);
        }
        return con;
    }

    class FailInfo
    extends DERBitString {
        FailInfo(int failInfoValue) {
            super(FailInfo.getBytes((int)failInfoValue), FailInfo.getPadBits((int)failInfoValue));
        }
    }
}

