/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;
import org.spongycastle.asn1.cms.KEKIdentifier;
import org.spongycastle.asn1.cms.KEKRecipientInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.AuthAttributesProvider;
import org.spongycastle.cms.CMSEnvelopedHelper;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSSecureReadable;
import org.spongycastle.cms.CMSTypedStream;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.KEKRecipient;
import org.spongycastle.cms.KEKRecipientId;
import org.spongycastle.cms.Recipient;
import org.spongycastle.cms.RecipientInformation;
import org.spongycastle.cms.RecipientOperator;
import org.spongycastle.cms.jcajce.JceKEKAuthenticatedRecipient;
import org.spongycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import org.spongycastle.cms.jcajce.JceKEKRecipient;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKEKRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

