/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Generator;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetStringParser;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1SequenceParser;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1SetParser;
import org.spongycastle.asn1.ASN1StreamParser;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.BERSequenceGenerator;
import org.spongycastle.asn1.BERSetParser;
import org.spongycastle.asn1.BERTaggedObject;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.cms.ContentInfoParser;
import org.spongycastle.asn1.cms.SignedDataParser;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.AttributeCertificate;
import org.spongycastle.asn1.x509.Certificate;
import org.spongycastle.asn1.x509.CertificateList;
import org.spongycastle.cert.X509AttributeCertificateHolder;
import org.spongycastle.cert.X509CRLHolder;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cms.CMSContentInfoParser;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSSignedHelper;
import org.spongycastle.cms.CMSTypedStream;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.operator.DigestCalculator;
import org.spongycastle.operator.DigestCalculatorProvider;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.bc.BcDigestCalculatorProvider;
import org.spongycastle.util.CollectionStore;
import org.spongycastle.util.Store;
import org.spongycastle.util.io.Streams;
import org.spongycastle.x509.NoSuchStoreException;
import org.spongycastle.x509.X509Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map digests;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] sigBlock) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), (InputStream)new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, (InputStream)new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), signedContent, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, signedContent, new ByteArrayInputStream(sigBlock));
    }

    private static DigestCalculatorProvider createDefaultDigestProvider() throws CMSException {
        return new BcDigestCalculatorProvider();
    }

    public CMSSignedDataParser(InputStream sigData) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), null, sigData);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream sigData) throws CMSException {
        this(digestCalculatorProvider, null, sigData);
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), signedContent, sigData);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        super(sigData);
        try {
            ASN1Encodable o;
            this._signedContent = signedContent;
            this._signedData = SignedDataParser.getInstance((Object)this._contentInfo.getContent(16));
            this.digests = new HashMap();
            ASN1SetParser digAlgs = this._signedData.getDigestAlgorithms();
            while ((o = digAlgs.readObject()) != null) {
                AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance((Object)o);
                try {
                    DigestCalculator calculator = digestCalculatorProvider.get(algId);
                    if (calculator == null) continue;
                    this.digests.put(algId.getAlgorithm(), calculator);
                }
                catch (OperatorCreationException e) {}
            }
            ContentInfoParser cont = this._signedData.getEncapContentInfo();
            ASN1OctetStringParser octs = (ASN1OctetStringParser)cont.getContent(4);
            if (octs != null) {
                CMSTypedStream ctStr = new CMSTypedStream(cont.getContentType().getId(), octs.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = ctStr;
                } else {
                    ctStr.drain();
                }
            }
            this._signedContentType = signedContent == null ? cont.getContentType() : this._signedContent.getContentType();
        }
        catch (IOException e) {
            throw new CMSException("io exception: " + e.getMessage(), e);
        }
        if (this.digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            HashMap hashes = new HashMap();
            for (Object digestKey : this.digests.keySet()) {
                hashes.put(digestKey, ((DigestCalculator)this.digests.get(digestKey)).getDigest());
            }
            try {
                ASN1Encodable o;
                ASN1SetParser s = this._signedData.getSignerInfos();
                while ((o = s.readObject()) != null) {
                    SignerInfo info = SignerInfo.getInstance((Object)o.toASN1Primitive());
                    byte[] hash = (byte[])hashes.get(info.getDigestAlgorithm().getAlgorithm());
                    signerInfos.add(new SignerInformation(info, this._signedContentType, null, hash));
                }
            }
            catch (IOException e) {
                throw new CMSException("io exception: " + e.getMessage(), e);
            }
            this._signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getAttributeCertificates(type, CMSUtils.getProvider(provider));
    }

    public X509Store getAttributeCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(type, provider, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCertificates(type, CMSUtils.getProvider(provider));
    }

    public X509Store getCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(type, provider, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCRLs(type, CMSUtils.getProvider(provider));
    }

    public X509Store getCRLs(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(type, provider, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.getCertificatesAndCRLs(type, CMSUtils.getProvider(provider));
    }

    public CertStore getCertificatesAndCRLs(String type, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.populateCertCrlSets();
        return HELPER.createCertStore(type, provider, this._certSet, this._crlSet);
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                certList.add(new X509CertificateHolder(Certificate.getInstance((Object)obj)));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set crlSet = this._crlSet;
        if (crlSet != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>(crlSet.size());
            Enumeration en = crlSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                crlList.add(new X509CRLHolder(CertificateList.getInstance((Object)obj)));
            }
            return new CollectionStore(crlList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getAttributeCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509AttributeCertificateHolder> certList = new ArrayList<X509AttributeCertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1TaggedObject tagged;
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)obj).getTagNo() != 2) continue;
                certList.add(new X509AttributeCertificateHolder(AttributeCertificate.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)false))));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
        }
        catch (IOException e) {
            throw new CMSException("problem parsing cert/crl sets", e);
        }
    }

    public String getSignedContentTypeOID() {
        return this._signedContentType.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream digStream = CMSUtils.attachDigestsToInputStream(this.digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), digStream);
    }

    public static OutputStream replaceSigners(InputStream original, SignerInformationStore signerInformationStore, OutputStream out) throws CMSException, IOException {
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance((Object)contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject((ASN1Encodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject((ASN1Encodable)signedData.getVersion());
        signedData.getDigestAlgorithms().toASN1Primitive();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            digestAlgs.add((ASN1Encodable)CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject((ASN1Encodable)encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.writeSetToGeneratorTagged((ASN1Generator)sigGen, signedData.getCertificates(), 0);
        CMSSignedDataParser.writeSetToGeneratorTagged((ASN1Generator)sigGen, signedData.getCrls(), 1);
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            signerInfos.add((ASN1Encodable)signer.toASN1Structure());
        }
        sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, CertStore certsAndCrls, OutputStream out) throws CMSException, IOException {
        ASN1Set crls;
        ASN1Set certs;
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance((Object)contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject((ASN1Encodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject((ASN1Encodable)signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject((ASN1Encodable)encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        try {
            certs = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting certs from certStore", e);
        }
        if (certs.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, (ASN1Encodable)certs).getEncoded());
        }
        try {
            crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting crls from certStore", e);
        }
        if (crls.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, (ASN1Encodable)crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().toASN1Primitive().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, Store certs, Store crls, Store attrCerts, OutputStream out) throws CMSException, IOException {
        ASN1Set asn1Crls;
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance((Object)contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject((ASN1Encodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject((ASN1Encodable)signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject((ASN1Encodable)encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        if (certs != null || attrCerts != null) {
            ASN1Set asn1Certs;
            ArrayList certificates = new ArrayList();
            if (certs != null) {
                certificates.addAll(CMSUtils.getCertificatesFromStore(certs));
            }
            if (attrCerts != null) {
                certificates.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((asn1Certs = CMSUtils.createBerSetFromList(certificates)).size() > 0) {
                sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, (ASN1Encodable)asn1Certs).getEncoded());
            }
        }
        if (crls != null && (asn1Crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(crls))).size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, (ASN1Encodable)asn1Crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().toASN1Primitive().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    private static void writeSetToGeneratorTagged(ASN1Generator asn1Gen, ASN1SetParser asn1SetParser, int tagNo) throws IOException {
        ASN1Set asn1Set = CMSSignedDataParser.getASN1Set(asn1SetParser);
        if (asn1Set != null) {
            if (asn1SetParser instanceof BERSetParser) {
                asn1Gen.getRawOutputStream().write(new BERTaggedObject(false, tagNo, (ASN1Encodable)asn1Set).getEncoded());
            } else {
                asn1Gen.getRawOutputStream().write(new DERTaggedObject(false, tagNo, (ASN1Encodable)asn1Set).getEncoded());
            }
        }
    }

    private static ASN1Set getASN1Set(ASN1SetParser asn1SetParser) {
        return asn1SetParser == null ? null : ASN1Set.getInstance((Object)asn1SetParser.toASN1Primitive());
    }

    private static void pipeEncapsulatedOctetString(ContentInfoParser encapContentInfo, OutputStream rawOutputStream) throws IOException {
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            CMSSignedDataParser.pipeOctetString(octs, rawOutputStream);
        }
    }

    private static void pipeOctetString(ASN1OctetStringParser octs, OutputStream output) throws IOException {
        OutputStream outOctets = CMSUtils.createBEROctetOutputStream(output, 0, true, 0);
        Streams.pipeAll((InputStream)octs.getOctetStream(), (OutputStream)outOctets);
        outOctets.close();
    }
}

