/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.BERConstructedOctetString;
import org.spongycastle.asn1.DERObjectIdentifier;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.cms.CompressedData;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSCompressedData;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.operator.OutputCompressor;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public CMSCompressedData generate(CMSProcessable content, String compressionOID) throws CMSException {
        BERConstructedOctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DeflaterOutputStream zOut = new DeflaterOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(compressionOID));
            comOcts = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new CMSException("exception encoding data.", e);
        }
        ContentInfo comContent = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, (ASN1Encodable)new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }

    public CMSCompressedData generate(CMSTypedData content, OutputCompressor compressor) throws CMSException {
        BERConstructedOctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream zOut = compressor.getOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = compressor.getAlgorithmIdentifier();
            comOcts = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new CMSException("exception encoding data.", e);
        }
        ContentInfo comContent = new ContentInfo(content.getContentType(), (ASN1Encodable)comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, (ASN1Encodable)new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }
}

