/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Environment;
import android.text.format.Time;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ReportField;
import org.acra.collector.Compatibility;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.DeviceFeaturesCollector;
import org.acra.collector.DropBoxCollector;
import org.acra.collector.DumpSysCollector;
import org.acra.collector.LogCatCollector;
import org.acra.collector.LogFileCollector;
import org.acra.collector.MediaCodecListCollector;
import org.acra.collector.ReflectionCollector;
import org.acra.collector.SettingsCollector;
import org.acra.collector.SharedPreferencesCollector;
import org.acra.collector.ThreadCollector;
import org.acra.util.Installation;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ReportUtils;

public final class CrashReportDataFactory {
    private final Context context;
    private final SharedPreferences prefs;
    private final List<ReportField> crashReportFields;
    private final Map<String, String> customParameters = new HashMap<String, String>();
    private final Time appStartDate;
    private final String initialConfiguration;

    public CrashReportDataFactory(Context context, SharedPreferences prefs, Time appStartDate, String initialConfiguration) {
        ReportField[] fieldsList;
        this.context = context;
        this.prefs = prefs;
        this.appStartDate = appStartDate;
        this.initialConfiguration = initialConfiguration;
        ACRAConfiguration config = ACRA.getConfig();
        ReportField[] customReportFields = config.customReportContent();
        if (customReportFields.length != 0) {
            Log.d((String)ACRA.LOG_TAG, (String)"Using custom Report Fields");
            fieldsList = customReportFields;
        } else if (config.mailTo() == null || "".equals(config.mailTo())) {
            Log.d((String)ACRA.LOG_TAG, (String)"Using default Report Fields");
            fieldsList = ACRA.DEFAULT_REPORT_FIELDS;
        } else {
            Log.d((String)ACRA.LOG_TAG, (String)"Using default Mail Report Fields");
            fieldsList = ACRA.DEFAULT_MAIL_REPORT_FIELDS;
        }
        this.crashReportFields = Arrays.asList(fieldsList);
    }

    public String putCustomData(String key, String value) {
        return this.customParameters.put(key, value);
    }

    public String removeCustomData(String key) {
        return this.customParameters.remove(key);
    }

    public String getCustomData(String key) {
        return this.customParameters.get(key);
    }

    public CrashReportData createCrashData(Throwable th, boolean isSilentReport, Thread brokenThread) {
        CrashReportData crashReportData = new CrashReportData();
        try {
            String deviceId;
            PackageManagerWrapper pm;
            PackageInfo pi;
            crashReportData.put(ReportField.STACK_TRACE, this.getStackTrace(th));
            crashReportData.put(ReportField.USER_APP_START_DATE, this.appStartDate.format3339(false));
            if (isSilentReport) {
                crashReportData.put(ReportField.IS_SILENT, "true");
            }
            if (this.crashReportFields.contains((Object)ReportField.REPORT_ID)) {
                crashReportData.put(ReportField.REPORT_ID, UUID.randomUUID().toString());
            }
            if (this.crashReportFields.contains((Object)ReportField.INSTALLATION_ID)) {
                crashReportData.put(ReportField.INSTALLATION_ID, Installation.id(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.INITIAL_CONFIGURATION)) {
                crashReportData.put(ReportField.INITIAL_CONFIGURATION, this.initialConfiguration);
            }
            if (this.crashReportFields.contains((Object)ReportField.CRASH_CONFIGURATION)) {
                crashReportData.put(ReportField.CRASH_CONFIGURATION, ConfigurationCollector.collectConfiguration(this.context));
            }
            if (!(th instanceof OutOfMemoryError) && this.crashReportFields.contains((Object)ReportField.DUMPSYS_MEMINFO)) {
                crashReportData.put(ReportField.DUMPSYS_MEMINFO, DumpSysCollector.collectMemInfo());
            }
            if (this.crashReportFields.contains((Object)ReportField.PACKAGE_NAME)) {
                crashReportData.put(ReportField.PACKAGE_NAME, this.context.getPackageName());
            }
            if (this.crashReportFields.contains((Object)ReportField.BUILD)) {
                crashReportData.put(ReportField.BUILD, ReflectionCollector.collectConstants(Build.class));
            }
            if (this.crashReportFields.contains((Object)ReportField.PHONE_MODEL)) {
                crashReportData.put(ReportField.PHONE_MODEL, Build.MODEL);
            }
            if (this.crashReportFields.contains((Object)ReportField.ANDROID_VERSION)) {
                crashReportData.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
            }
            if (this.crashReportFields.contains((Object)ReportField.BRAND)) {
                crashReportData.put(ReportField.BRAND, Build.BRAND);
            }
            if (this.crashReportFields.contains((Object)ReportField.PRODUCT)) {
                crashReportData.put(ReportField.PRODUCT, Build.PRODUCT);
            }
            if (this.crashReportFields.contains((Object)ReportField.TOTAL_MEM_SIZE)) {
                crashReportData.put(ReportField.TOTAL_MEM_SIZE, Long.toString(ReportUtils.getTotalInternalMemorySize()));
            }
            if (this.crashReportFields.contains((Object)ReportField.AVAILABLE_MEM_SIZE)) {
                crashReportData.put(ReportField.AVAILABLE_MEM_SIZE, Long.toString(ReportUtils.getAvailableInternalMemorySize()));
            }
            if (this.crashReportFields.contains((Object)ReportField.FILE_PATH)) {
                crashReportData.put(ReportField.FILE_PATH, ReportUtils.getApplicationFilePath(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.DISPLAY)) {
                crashReportData.put(ReportField.DISPLAY, ReportUtils.getDisplayDetails(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.USER_CRASH_DATE)) {
                Time curDate = new Time();
                curDate.setToNow();
                crashReportData.put(ReportField.USER_CRASH_DATE, curDate.format3339(false));
            }
            if (this.crashReportFields.contains((Object)ReportField.CUSTOM_DATA)) {
                crashReportData.put(ReportField.CUSTOM_DATA, this.createCustomInfoString());
            }
            if (this.crashReportFields.contains((Object)ReportField.USER_EMAIL)) {
                crashReportData.put(ReportField.USER_EMAIL, this.prefs.getString("acra.user.email", "N/A"));
            }
            if (this.crashReportFields.contains((Object)ReportField.DEVICE_FEATURES)) {
                crashReportData.put(ReportField.DEVICE_FEATURES, DeviceFeaturesCollector.getFeatures(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.ENVIRONMENT)) {
                crashReportData.put(ReportField.ENVIRONMENT, ReflectionCollector.collectStaticGettersResults(Environment.class));
            }
            if (this.crashReportFields.contains((Object)ReportField.SETTINGS_SYSTEM)) {
                crashReportData.put(ReportField.SETTINGS_SYSTEM, SettingsCollector.collectSystemSettings(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.SETTINGS_SECURE)) {
                crashReportData.put(ReportField.SETTINGS_SECURE, SettingsCollector.collectSecureSettings(this.context));
            }
            if (this.crashReportFields.contains((Object)ReportField.SHARED_PREFERENCES)) {
                crashReportData.put(ReportField.SHARED_PREFERENCES, SharedPreferencesCollector.collect(this.context));
            }
            if ((pi = (pm = new PackageManagerWrapper(this.context)).getPackageInfo()) != null) {
                if (this.crashReportFields.contains((Object)ReportField.APP_VERSION_CODE)) {
                    crashReportData.put(ReportField.APP_VERSION_CODE, Integer.toString(pi.versionCode));
                }
                if (this.crashReportFields.contains((Object)ReportField.APP_VERSION_NAME)) {
                    crashReportData.put(ReportField.APP_VERSION_NAME, pi.versionName != null ? pi.versionName : "not set");
                }
            } else {
                crashReportData.put(ReportField.APP_VERSION_NAME, "Package info unavailable");
            }
            if (this.crashReportFields.contains((Object)ReportField.DEVICE_ID) && this.prefs.getBoolean("acra.deviceid.enable", true) && pm.hasPermission("android.permission.READ_PHONE_STATE") && (deviceId = ReportUtils.getDeviceId(this.context)) != null) {
                crashReportData.put(ReportField.DEVICE_ID, deviceId);
            }
            if (this.prefs.getBoolean("acra.syslog.enable", true) && pm.hasPermission("android.permission.READ_LOGS") || Compatibility.getAPILevel() >= 16) {
                Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS granted! ACRA can include LogCat and DropBox data.");
                if (this.crashReportFields.contains((Object)ReportField.LOGCAT)) {
                    crashReportData.put(ReportField.LOGCAT, LogCatCollector.collectLogCat(null));
                }
                if (this.crashReportFields.contains((Object)ReportField.EVENTSLOG)) {
                    crashReportData.put(ReportField.EVENTSLOG, LogCatCollector.collectLogCat("events"));
                }
                if (this.crashReportFields.contains((Object)ReportField.RADIOLOG)) {
                    crashReportData.put(ReportField.RADIOLOG, LogCatCollector.collectLogCat("radio"));
                }
                if (this.crashReportFields.contains((Object)ReportField.DROPBOX)) {
                    crashReportData.put(ReportField.DROPBOX, DropBoxCollector.read(this.context, ACRA.getConfig().additionalDropBoxTags()));
                }
            } else {
                Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS not allowed. ACRA will not include LogCat and DropBox data.");
            }
            if (this.crashReportFields.contains((Object)ReportField.APPLICATION_LOG)) {
                crashReportData.put(ReportField.APPLICATION_LOG, LogFileCollector.collectLogFile(this.context, ACRA.getConfig().applicationLogFile(), ACRA.getConfig().applicationLogFileLines()));
            }
            if (this.crashReportFields.contains((Object)ReportField.MEDIA_CODEC_LIST)) {
                crashReportData.put(ReportField.MEDIA_CODEC_LIST, MediaCodecListCollector.collecMediaCodecList());
            }
            if (this.crashReportFields.contains((Object)ReportField.THREAD_DETAILS)) {
                crashReportData.put(ReportField.THREAD_DETAILS, ThreadCollector.collect(brokenThread));
            }
        }
        catch (RuntimeException e) {
            Log.e((String)ACRA.LOG_TAG, (String)"Error while retrieving crash data", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            Log.e((String)ACRA.LOG_TAG, (String)("Error : application log file " + ACRA.getConfig().applicationLogFile() + " not found."), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)ACRA.LOG_TAG, (String)("Error while reading application log file " + ACRA.getConfig().applicationLogFile() + "."), (Throwable)e);
        }
        return crashReportData;
    }

    private String createCustomInfoString() {
        StringBuilder customInfo = new StringBuilder();
        for (String currentKey : this.customParameters.keySet()) {
            String currentVal = this.customParameters.get(currentKey);
            customInfo.append(currentKey);
            customInfo.append(" = ");
            customInfo.append(currentVal);
            customInfo.append("\n");
        }
        return customInfo.toString();
    }

    private String getStackTrace(Throwable th) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        for (Throwable cause = th; cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String stacktraceAsString = ((Object)result).toString();
        printWriter.close();
        return stacktraceAsString;
    }
}

