/*
 * Copyright 2011 Torsten Römer
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.luniks.android.inetify;

import android.location.Location;

/**
 * Interface for a class creating notifications.
 * 
 * @author torsten.roemer@luniks.net
 */
public interface Notifier {
	
	/**
	 * Creates an "internet connectivity test" notification based on the given TestInfo,
	 * cancels an existing notification if info is null.
	 * @param info test info
	 */
	void inetify(TestInfo info);

	/**
	 * Creates a "nearest Wifi" notification using the given location and Wifi location.
	 * @param location current location
	 * @param nearestLocation nearest Wifi location
	 */
	void locatify(Location location, WifiLocation nearestlocation);

}
