/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.util;

import android.graphics.Point;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.util.constants.MapViewConstants;

public class Mercator
implements MapViewConstants {
    static final double DEG2RAD = Math.PI / 180;

    private Mercator() {
    }

    public static Point projectGeoPoint(int aLatE6, int aLonE6, int aZoom, Point reuse) {
        return Mercator.projectGeoPoint((double)aLatE6 * 1.0E-6, (double)aLonE6 * 1.0E-6, aZoom, reuse);
    }

    public static Point projectGeoPoint(IGeoPoint pGeoPoint, int pZoom, Point pUseAsReturnValue) {
        return Mercator.projectGeoPoint((double)pGeoPoint.getLatitudeE6() * 1.0E-6, (double)pGeoPoint.getLongitudeE6() * 1.0E-6, pZoom, pUseAsReturnValue);
    }

    public static Point projectGeoPoint(double aLat, double aLon, int aZoom, Point aUseAsReturnValue) {
        Point p = aUseAsReturnValue != null ? aUseAsReturnValue : new Point(0, 0);
        p.x = (int)Math.floor((aLon + 180.0) / 360.0 * (double)(1 << aZoom));
        p.y = (int)Math.floor((1.0 - Math.log(Math.tan(aLat * (Math.PI / 180)) + 1.0 / Math.cos(aLat * (Math.PI / 180))) / Math.PI) / 2.0 * (double)(1 << aZoom));
        return p;
    }

    public static BoundingBoxE6 getBoundingBoxFromCoords(int left, int top, int right, int bottom, int zoom) {
        return new BoundingBoxE6(Mercator.tile2lat(top, zoom), Mercator.tile2lon(right, zoom), Mercator.tile2lat(bottom, zoom), Mercator.tile2lon(left, zoom));
    }

    public static BoundingBoxE6 getBoundingBoxFromPointInMapTile(Point aMapTile, int aZoom) {
        return new BoundingBoxE6(Mercator.tile2lat(aMapTile.y, aZoom), Mercator.tile2lon(aMapTile.x + 1, aZoom), Mercator.tile2lat(aMapTile.y + 1, aZoom), Mercator.tile2lon(aMapTile.x, aZoom));
    }

    public static GeoPoint projectPoint(int x, int y, int aZoom) {
        return new GeoPoint((int)(Mercator.tile2lat(y, aZoom) * 1000000.0), (int)(Mercator.tile2lon(x, aZoom) * 1000000.0));
    }

    public static double tile2lon(int x, int aZoom) {
        return (double)x / (double)(1 << aZoom) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int aZoom) {
        double n = Math.PI - Math.PI * 2 * (double)y / (double)(1 << aZoom);
        return 57.29577951308232 * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
    }
}

