/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.contributor;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.osmdroid.contributor.util.RecordedGeoPoint;
import org.osmdroid.contributor.util.RecordedRouteGPXFormatter;
import org.osmdroid.contributor.util.Util;
import org.osmdroid.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpxToPHPUploader {
    private static final Logger logger = LoggerFactory.getLogger(GpxToPHPUploader.class);
    protected static final String UPLOADSCRIPT_URL = "http://www.PLACEYOURDOMAINHERE.com/anyfolder/gpxuploader/upload.php";

    private GpxToPHPUploader() {
    }

    public static void uploadAsync(final ArrayList<RecordedGeoPoint> recordedGeoPoints) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Util.isSufficienDataForUpload(recordedGeoPoints)) {
                        return;
                    }
                    ByteArrayInputStream gpxInputStream = new ByteArrayInputStream(RecordedRouteGPXFormatter.create(recordedGeoPoints).getBytes());
                    HttpClient httpClient = HttpClientFactory.createHttpClient();
                    HttpPost request = new HttpPost(GpxToPHPUploader.UPLOADSCRIPT_URL);
                    MultipartEntity requestEntity = new MultipartEntity();
                    requestEntity.addPart("gpxfile", (ContentBody)new InputStreamBody((InputStream)gpxInputStream, "" + System.currentTimeMillis() + ".gpx"));
                    httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                    request.setEntity((HttpEntity)requestEntity);
                    HttpResponse response = httpClient.execute((HttpUriRequest)request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        logger.error("GPXUploader", (Object)"status != HttpStatus.SC_OK");
                    } else {
                        int read;
                        InputStreamReader r = new InputStreamReader(new BufferedInputStream(response.getEntity().getContent()));
                        char[] buf = new char[8192];
                        StringBuilder sb = new StringBuilder();
                        while ((read = r.read(buf)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        logger.debug("GPXUploader", (Object)("Response: " + sb.toString()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }
}

