/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import snoozesoft.systray4j.SubMenu;
import snoozesoft.systray4j.SysTrayAccess;
import snoozesoft.systray4j.SysTrayManager;
import snoozesoft.systray4j.SysTrayMenu;

class DaemonSysTray
implements SysTrayAccess,
Runnable {
    private static final String REQ_ADD_MAINMENU = "ADD MAINMENU";
    private static final String REQ_ADD_SUBMENU = "ADD SUBMENU";
    private static final String REQ_SET_ICON = "SET ICON";
    private static final String REQ_SHOW_ICON = "SHOW ICON";
    private static final String REQ_SET_TOOLTIP = "SET TOOLTIP";
    private static final String REQ_ADD_ITEM = "ADD ITEM";
    private static final String REQ_ENABLE_ITEM = "ENABLE ITEM";
    private static final String REQ_CHECK_ITEM = "CHECK ITEM";
    private static final String REQ_SET_ITEMLABEL = "SET ITEMLABEL";
    private static final String REQ_REMOVE_ITEM = "REMOVE ITEM";
    private static final String REQ_REMOVE_ALL = "REMOVE ALL";
    private static final String MSG_ICON_CLICKED = "ICON CLICKED";
    private static final String MSG_ICON_DBLCLICKED = "ICON DBLCLICKED";
    private static final String MSG_ITEM_SELECTED = "ITEM SELECTED";
    private HashMap menus;
    private Socket socket;
    private BufferedWriter writer;
    private BufferedReader reader;
    private boolean available = true;
    private int idCounter;
    private boolean ignoreException;

    DaemonSysTray() {
        try {
            String initResponse = null;
            int port = Integer.parseInt(SysTrayManager.properties.getProperty("daemon.port"));
            this.socket = new Socket("localhost", port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.writer.write("SysTray for Java v" + SysTrayMenu.VERSION + "\n");
            this.writer.flush();
            initResponse = this.reader.readLine();
            if (!initResponse.startsWith("systray4jd")) {
                System.err.println("systray4j: wrong response from daemon: " + initResponse);
                this.available = false;
                return;
            }
            this.menus = new HashMap();
            this.idCounter = 1;
            this.ignoreException = false;
            new Thread((Runnable)this, "DaemonSysTray").start();
        }
        catch (Exception e) {
            this.available = false;
        }
    }

    public void run() {
        block10: {
            try {
                int index = 0;
                String line = null;
                Integer menuId = null;
                Object menu = null;
                SysTrayMenu mainMenu = null;
                SubMenu subMenu = null;
                String message = this.reader.readLine();
                while (message != null) {
                    if (message.equals(MSG_ICON_CLICKED)) {
                        line = this.reader.readLine();
                        menuId = Integer.decode(line);
                        mainMenu = (SysTrayMenu)this.menus.get(menuId);
                        mainMenu.iconLeftClicked(false);
                    } else if (message.equals(MSG_ITEM_SELECTED)) {
                        line = this.reader.readLine();
                        menuId = Integer.decode(line);
                        line = this.reader.readLine();
                        index = Integer.parseInt(line);
                        menu = this.menus.get(menuId);
                        if (menu instanceof SysTrayMenu) {
                            mainMenu = menu;
                            mainMenu.menuItemSelected(index);
                        } else {
                            subMenu = menu;
                            subMenu.menuItemSelected(index);
                        }
                    } else {
                        if (!message.equals(MSG_ICON_DBLCLICKED)) {
                            System.out.println("DaemonSysTray - unknown message: " + message);
                            break;
                        }
                        line = this.reader.readLine();
                        menuId = Integer.decode(line);
                        mainMenu = (SysTrayMenu)this.menus.get(menuId);
                        mainMenu.iconLeftClicked(true);
                    }
                    message = this.reader.readLine();
                }
            }
            catch (IOException e) {
                if (this.ignoreException) break block10;
                e.printStackTrace();
            }
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void addMainMenu(SysTrayMenu menu, String iconFileName, String toolTip) {
        try {
            this.writer.write("ADD MAINMENU\n");
            this.writer.write(this.idCounter + "\n");
            this.writer.write(iconFileName + "\n");
            StringTokenizer st = new StringTokenizer(toolTip, "\n");
            this.writer.write(st.countTokens() + "\n");
            this.writer.write(toolTip + "\n");
            this.writer.flush();
            this.menus.put(new Integer(this.idCounter), menu);
            menu.id = this.idCounter++;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addSubMenu(SubMenu menu) {
        try {
            this.writer.write("ADD SUBMENU\n");
            this.writer.write(this.idCounter + "\n");
            this.writer.flush();
            this.menus.put(new Integer(this.idCounter), menu);
            menu.id = this.idCounter++;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setToolTip(int menuId, String tip) {
        try {
            this.writer.write("SET TOOLTIP\n");
            this.writer.write(menuId + "\n");
            StringTokenizer st = new StringTokenizer(tip, "\n");
            this.writer.write(st.countTokens() + "\n");
            this.writer.write(tip + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showIcon(int menuId, boolean show) {
        try {
            this.writer.write("SHOW ICON\n");
            this.writer.write(menuId + "\n");
            this.writer.write(show + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setIcon(int menuId, String iconFileName) {
        try {
            this.writer.write("SET ICON\n");
            this.writer.write(menuId + "\n");
            this.writer.write(iconFileName + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enableItem(int menuId, int itemIndex, boolean enable) {
        try {
            this.writer.write("ENABLE ITEM\n");
            this.writer.write(menuId + "\n");
            this.writer.write(itemIndex + "\n");
            this.writer.write(enable + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkItem(int menuId, int itemIndex, boolean check) {
        try {
            this.writer.write("CHECK ITEM\n");
            this.writer.write(menuId + "\n");
            this.writer.write(itemIndex + "\n");
            this.writer.write(check + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setItemLabel(int menuId, int itemIndex, String label) {
        try {
            this.writer.write("SET ITEMLABEL\n");
            this.writer.write(menuId + "\n");
            this.writer.write(itemIndex + "\n");
            this.writer.write(label + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addItem(int menuId, int itemIndex, String label, boolean checkable, boolean check, boolean enable) {
        try {
            this.writer.write("ADD ITEM\n");
            this.writer.write(menuId + "\n");
            this.writer.write(itemIndex + "\n");
            this.writer.write(label + "\n");
            this.writer.write(checkable + "\n");
            this.writer.write(check + "\n");
            this.writer.write(enable + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeItem(int menuId, int itemIndex) {
        try {
            this.writer.write("REMOVE ITEM\n");
            this.writer.write(menuId + "\n");
            this.writer.write(itemIndex + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeAll(int menuId) {
        try {
            this.writer.write("REMOVE ALL\n");
            this.writer.write(menuId + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.ignoreException = true;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

