/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
extends HttpServletResponseWrapper {
    private NoBodyOutputStream noBody = new NoBodyOutputStream();
    private PrintWriter writer;
    private boolean didSetContentLength;

    NoBodyResponse(HttpServletResponse r) {
        super(r);
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            super.setContentLength(this.noBody.getContentLength());
        }
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.checkHeader(name);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.checkHeader(name);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.checkHeader(name);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.checkHeader(name);
    }

    private void checkHeader(String name) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.didSetContentLength = true;
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }
}

