/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.Util;

class EditDatasourceDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int FIELD_SIZE = 20;
    private static final String TITLE_NEW = "New datasource";
    private static final String TITLE_EDIT = "Edit datasource";
    private JLabel nameLabel = new JLabel("Datasource name: ");
    private JLabel typeLabel = new JLabel("Datasource type: ");
    private JLabel heartbeatLabel = new JLabel("Heartbeat: ");
    private JLabel minLabel = new JLabel("Min value: ");
    private JLabel maxLabel = new JLabel("Max value: ");
    private JTextField nameField = new JTextField(20);
    private JComboBox typeCombo = new JComboBox();
    private JTextField heartbeatField = new JTextField(20);
    private JTextField minField = new JTextField(20);
    private JTextField maxField = new JTextField(20);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private DsDef dsDef;

    EditDatasourceDialog(Frame frame, DsDef dsDef) {
        super(frame, dsDef == null ? TITLE_NEW : TITLE_EDIT, true);
        this.constructUI(dsDef);
        this.pack();
        Util.centerOnScreen(this);
        this.setVisible(true);
    }

    private void constructUI(DsDef dsDef) {
        String[] stringArray = DsDef.DS_TYPES;
        for (String string : stringArray) {
            this.typeCombo.addItem(string);
        }
        this.typeCombo.setSelectedIndex(0);
        if (dsDef == null) {
            this.minField.setText("U");
            this.maxField.setText("U");
        } else {
            this.nameField.setText(dsDef.getDsName());
            this.nameField.setEnabled(false);
            this.typeCombo.setSelectedItem(dsDef.getDsType());
            this.typeCombo.setEnabled(false);
            this.heartbeatField.setText("" + dsDef.getHeartbeat());
            this.minField.setText("" + dsDef.getMinValue());
            this.maxField.setText("" + dsDef.getMaxValue());
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        jPanel.add(this.nameLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.typeLabel, gridBagConstraints);
        jPanel.add(this.typeLabel);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.heartbeatLabel, gridBagConstraints);
        jPanel.add(this.heartbeatLabel);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.minLabel, gridBagConstraints);
        jPanel.add(this.minLabel);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.maxLabel, gridBagConstraints);
        jPanel.add(this.maxLabel);
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        jPanel.add(this.okButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nameField, gridBagConstraints);
        jPanel.add(this.nameField);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.typeCombo, gridBagConstraints);
        jPanel.add(this.typeCombo);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.heartbeatField, gridBagConstraints);
        jPanel.add(this.heartbeatField);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.minField, gridBagConstraints);
        jPanel.add(this.minField);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.maxField, gridBagConstraints);
        jPanel.add(this.maxField);
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDatasourceDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDatasourceDialog.this.cancel();
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private void ok() {
        this.dsDef = this.createDsDef();
        if (this.dsDef != null) {
            this.close();
        }
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void cancel() {
        this.close();
    }

    private DsDef createDsDef() {
        long l;
        String string = this.nameField.getText();
        if (string == null || string.length() < 1 || string.length() > 20) {
            Util.error((Component)this, "Datasource name must be a non-empty string up to 20 chars long");
            return null;
        }
        String string2 = (String)this.typeCombo.getSelectedItem();
        try {
            l = Long.parseLong(this.heartbeatField.getText());
            if (l <= 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.error((Component)this, "Heartbeat must be a positive integer number");
            return null;
        }
        double d = Double.NaN;
        double d2 = Double.NaN;
        try {
            d = Double.parseDouble(this.minField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d2 = Double.parseDouble(this.maxField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2) && d >= d2) {
            Util.error((Component)this, "Min value must be less than max value");
            return null;
        }
        try {
            return new DsDef(string, string2, l, d, d2);
        }
        catch (RrdException rrdException) {
            Util.error((Component)this, rrdException);
            return null;
        }
    }

    DsDef getDsDef() {
        return this.dsDef;
    }
}

