/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import org.jrobin.core.Util;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class ValueAxis
implements RrdGraphConstants {
    private static final YLab[] ylab = new YLab[]{new YLab(0.1, 1, 2, 5, 10), new YLab(0.2, 1, 5, 10, 20), new YLab(0.5, 1, 2, 4, 10), new YLab(1.0, 1, 2, 5, 10), new YLab(2.0, 1, 5, 10, 20), new YLab(5.0, 1, 2, 4, 10), new YLab(10.0, 1, 2, 5, 10), new YLab(20.0, 1, 5, 10, 20), new YLab(50.0, 1, 2, 4, 10), new YLab(100.0, 1, 2, 5, 10), new YLab(200.0, 1, 5, 10, 20), new YLab(500.0, 1, 2, 4, 10), new YLab(1000.0, 1, 2, 5, 10), new YLab(2000.0, 1, 5, 10, 20), new YLab(5000.0, 1, 2, 4, 10), new YLab(10000.0, 1, 2, 5, 10), new YLab(20000.0, 1, 5, 10, 20), new YLab(50000.0, 1, 2, 4, 10), new YLab(100000.0, 1, 2, 5, 10), new YLab(0.0, 0, 0, 0, 0)};
    private RrdGraph rrdGraph;
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxis(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
    }

    boolean draw() {
        double d;
        int n;
        int n2;
        Font font = this.gdef.smallFont;
        Paint paint = this.gdef.colors[4];
        Paint paint2 = this.gdef.colors[5];
        Paint paint3 = this.gdef.colors[6];
        int n3 = (int)Math.ceil(this.rrdGraph.getSmallFontHeight());
        int n4 = (int)(this.worker.getFontAscent(font) / 2.0);
        int n5 = 2;
        int n6 = -1;
        double d2 = this.im.maxval - this.im.minval;
        double d3 = d2 / this.im.magfact;
        if (Double.isNaN(d3)) {
            return false;
        }
        int n7 = 1;
        String string = null;
        if (Double.isNaN(this.im.ygridstep)) {
            if (this.gdef.altYGrid) {
                n2 = (int)Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                if (n2 <= 0) {
                    n2 = 1;
                }
                string = (n = (int)Math.floor(Math.log10(d2))) < 0 ? Util.sprintf("%%%d.%df", n2 - n + 1, -n + 1) : Util.sprintf("%%%d.1f", n2 + 1);
                d = Math.pow(10.0, n);
                if (d == 0.0) {
                    d = 0.1;
                }
                if (d2 / d < 5.0) {
                    d /= 10.0;
                }
                if (d2 / d > 15.0) {
                    d *= 10.0;
                }
                if (d2 / d > 5.0) {
                    n5 = 1;
                    if (d2 / d > 8.0) {
                        n5 = 2;
                    }
                } else {
                    d /= 5.0;
                    n5 = 5;
                }
            } else {
                n2 = 0;
                while (ValueAxis.ylab[n2].grid > 0.0) {
                    n7 = (int)((double)this.im.ysize / (d3 / ValueAxis.ylab[n2].grid));
                    if (n6 == -1 && n7 > 5) {
                        n6 = n2;
                        break;
                    }
                    ++n2;
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    if (n7 * ValueAxis.ylab[n6].lfac[n2] < 2 * n3) continue;
                    n5 = ValueAxis.ylab[n6].lfac[n2];
                    break;
                }
                d = ValueAxis.ylab[n6].grid * this.im.magfact;
            }
        } else {
            d = this.im.ygridstep;
            n5 = this.im.ylabfact;
        }
        n2 = this.im.xorigin;
        n = n2 + this.im.xsize;
        int n8 = (int)(this.im.minval / d - 1.0);
        int n9 = (int)(this.im.maxval / d + 1.0);
        double d4 = d / this.im.magfact;
        for (int i = n8; i <= n9; ++i) {
            int n10 = this.rrdGraph.mapper.ytr(d * (double)i);
            if (n10 < this.im.yorigin - this.im.ysize || n10 > this.im.yorigin) continue;
            if (i % n5 == 0) {
                String string2 = i == 0 || this.im.symbol == ' ' ? (d4 < 1.0 ? (i != 0 && this.gdef.altYGrid ? Util.sprintf(string, d4 * (double)i) : Util.sprintf("%4.1f", d4 * (double)i)) : Util.sprintf("%4.0f", d4 * (double)i)) : (d4 < 1.0 ? Util.sprintf("%4.1f %c", d4 * (double)i, Character.valueOf(this.im.symbol)) : Util.sprintf("%4.0f %c", d4 * (double)i, Character.valueOf(this.im.symbol)));
                int n11 = (int)this.worker.getStringWidth(string2, font);
                this.worker.drawString(string2, n2 - n11 - 7, n10 + n4, font, paint3);
                this.worker.drawLine(n2 - 2, n10, n2 + 2, n10, paint2, TICK_STROKE);
                this.worker.drawLine(n - 2, n10, n + 2, n10, paint2, TICK_STROKE);
                this.worker.drawLine(n2, n10, n, n10, paint2, GRID_STROKE);
                continue;
            }
            if (this.gdef.noMinorGrid) continue;
            this.worker.drawLine(n2 - 1, n10, n2 + 1, n10, paint, TICK_STROKE);
            this.worker.drawLine(n - 1, n10, n + 1, n10, paint, TICK_STROKE);
            this.worker.drawLine(n2, n10, n, n10, paint, GRID_STROKE);
        }
        return true;
    }

    static class YLab {
        double grid;
        int[] lfac;

        YLab(double d, int n, int n2, int n3, int n4) {
            this.grid = d;
            this.lfac = new int[]{n, n2, n3, n4};
        }
    }
}

