/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.Task;
import foxtrot.WorkerThread;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.SwingUtilities;

public abstract class AbstractWorkerThread
implements WorkerThread {
    private static final Runnable EMPTY_EVENT = new Runnable(){

        public final void run() {
        }
    };

    protected AbstractWorkerThread() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTask(final Task task) {
        try {
            try {
                Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return task.run();
                    }
                }, task.getSecurityContext());
                task.setResult(obj);
            }
            catch (PrivilegedActionException x) {
                task.setThrowable(x.getException());
                Object var5_5 = null;
                task.setCompleted(true);
                SwingUtilities.invokeLater(EMPTY_EVENT);
                return;
            }
            catch (Throwable x) {
                task.setThrowable(x);
                Object var5_6 = null;
                task.setCompleted(true);
                SwingUtilities.invokeLater(EMPTY_EVENT);
                return;
            }
            Object var5_4 = null;
            task.setCompleted(true);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            task.setCompleted(true);
            SwingUtilities.invokeLater(EMPTY_EVENT);
            throw throwable;
        }
        SwingUtilities.invokeLater(EMPTY_EVENT);
    }

    public abstract void postTask(Task var1);

    public abstract boolean isWorkerThread();

    public abstract boolean isAlive();

    public abstract void start();
}

