/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CGI
extends HttpServlet {
    private static final long serialVersionUID = -6182088932884791073L;
    private static final Logger LOG = Log.getLogger(CGI.class);
    private boolean _ok;
    private File _docRoot;
    private String _path;
    private String _cmdPrefix;
    private EnvList _env;
    private boolean _ignoreExitState;
    private boolean _relative;

    public void init() throws ServletException {
        String os;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        this._relative = Boolean.parseBoolean(this.getInitParameter("cgibinResourceBaseIsRelative"));
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null) {
            tmp = this.getInitParameter("resourceBase");
            if (tmp == null) {
                tmp = this.getServletContext().getRealPath("/");
            }
        } else if (this._relative) {
            tmp = this.getServletContext().getRealPath(tmp);
        }
        if (tmp == null) {
            LOG.warn("CGI: no CGI bin !", new Object[0]);
            return;
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            LOG.warn("CGI: CGI bin does not exist - " + dir, new Object[0]);
            return;
        }
        if (!dir.canRead()) {
            LOG.warn("CGI: CGI bin is not readable - " + dir, new Object[0]);
            return;
        }
        if (!dir.isDirectory()) {
            LOG.warn("CGI: CGI bin is not a directory - " + dir, new Object[0]);
            return;
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.warn("CGI: CGI bin failed - " + dir, (Throwable)e);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (os = System.getProperty("os.name")) != null && os.toLowerCase(Locale.ENGLISH).indexOf("windows") != -1) {
            this._env.set("SystemRoot", "C:\\WINDOWS");
        }
        this._ok = true;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        if (!this._ok) {
            res.sendError(503);
            return;
        }
        String pathInContext = (this._relative ? "" : StringUtil.nonNull((String)req.getServletPath())) + StringUtil.nonNull((String)req.getPathInfo());
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: ContextPath : " + req.getContextPath(), new Object[0]);
            LOG.debug("CGI: ServletPath : " + req.getServletPath(), new Object[0]);
            LOG.debug("CGI: PathInfo    : " + req.getPathInfo(), new Object[0]);
            LOG.debug("CGI: _docRoot    : " + this._docRoot, new Object[0]);
            LOG.debug("CGI: _path       : " + this._path, new Object[0]);
            LOG.debug("CGI: _ignoreExitState: " + this._ignoreExitState, new Object[0]);
        }
        String first = both = pathInContext;
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists() || exe.isDirectory() || !exe.getCanonicalPath().equals(exe.getAbsolutePath())) {
            res.sendError(404);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CGI: script is " + exe, new Object[0]);
                LOG.debug("CGI: pathInfo is " + last, new Object[0]);
            }
            this.exec(exe, last, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = command.getAbsolutePath();
        File dir = command.getParentFile();
        String scriptName = req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length());
        String scriptPath = this.getServletContext().getRealPath(scriptName);
        String pathTranslated = req.getPathTranslated();
        int len = req.getContentLength();
        if (len < 0) {
            len = 0;
        }
        if (pathTranslated == null || pathTranslated.length() == 0) {
            pathTranslated = path;
        }
        String bodyFormEncoded = null;
        if (("POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            MultiMap parameterMap = new MultiMap();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String parameterName = (String)names.nextElement();
                parameterMap.addValues((Object)parameterName, req.getParameterValues(parameterName));
            }
            bodyFormEncoded = UrlEncoded.encode((MultiMap)parameterMap, (String)req.getCharacterEncoding(), (boolean)true);
        }
        EnvList env = new EnvList(this._env);
        env.set("AUTH_TYPE", req.getAuthType());
        if (bodyFormEncoded != null) {
            env.set("CONTENT_LENGTH", Integer.toString(bodyFormEncoded.length()));
        } else {
            env.set("CONTENT_LENGTH", Integer.toString(len));
        }
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        if (pathInfo != null && pathInfo.length() > 0) {
            env.set("PATH_INFO", pathInfo);
        }
        env.set("PATH_TRANSLATED", pathTranslated);
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("REMOTE_USER", req.getRemoteUser());
        env.set("REQUEST_METHOD", req.getMethod());
        env.set("SCRIPT_NAME", scriptName);
        env.set("SCRIPT_FILENAME", scriptPath);
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String value = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase(Locale.ENGLISH).replace('-', '_'), value);
        }
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        String execCmd = path;
        if (execCmd.charAt(0) != '\"' && execCmd.indexOf(" ") >= 0) {
            execCmd = "\"" + execCmd + "\"";
        }
        if (this._cmdPrefix != null) {
            execCmd = this._cmdPrefix + " " + execCmd;
        }
        LOG.debug("Environment: " + env.getExportString(), new Object[0]);
        LOG.debug("Command: " + execCmd, new Object[0]);
        Process p = dir == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir);
        if (bodyFormEncoded != null) {
            CGI.writeProcessInput(p, bodyFormEncoded);
        } else if (len > 0) {
            CGI.writeProcessInput(p, (InputStream)req.getInputStream(), len);
        }
        IO.copyThread((InputStream)p.getErrorStream(), (OutputStream)System.err);
        OutputStream os = null;
        try {
            int exitValue;
            String line = null;
            InputStream inFromCgi = p.getInputStream();
            while ((line = CGI.getTextLineFromStream(inFromCgi)).length() > 0) {
                int k;
                if (line.startsWith("HTTP") || (k = line.indexOf(58)) <= 0) continue;
                String key = line.substring(0, k).trim();
                String value = line.substring(k + 1).trim();
                if ("Location".equals(key)) {
                    res.sendRedirect(res.encodeRedirectURL(value));
                    continue;
                }
                if ("Status".equals(key)) {
                    String[] token = value.split(" ");
                    int status = Integer.parseInt(token[0]);
                    res.setStatus(status);
                    continue;
                }
                res.addHeader(key, value);
            }
            os = res.getOutputStream();
            IO.copy((InputStream)inFromCgi, (OutputStream)os);
            p.waitFor();
            if (!this._ignoreExitState && 0 != (exitValue = p.exitValue())) {
                LOG.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + path, new Object[0]);
                if (!res.isCommitted()) {
                    res.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException e) {
            LOG.debug("CGI: Client closed connection!", new Object[0]);
        }
        catch (InterruptedException ie) {
            LOG.debug("CGI: interrupted!", new Object[0]);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            p.destroy();
        }
    }

    private static void writeProcessInput(final Process p, final String input) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    OutputStreamWriter outToCgi = new OutputStreamWriter(p.getOutputStream());
                    outToCgi.write(input);
                    ((Writer)outToCgi).close();
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }).start();
    }

    private static void writeProcessInput(final Process p, final InputStream input, final int len) {
        if (len <= 0) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    OutputStream outToCgi = p.getOutputStream();
                    IO.copy((InputStream)input, (OutputStream)outToCgi, (long)len);
                    outToCgi.close();
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }).start();
    }

    private static String getTextLineFromStream(InputStream is) throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while ((b = is.read()) != -1 && b != 10) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    private static class EnvList {
        private Map<String, String> envMap;

        EnvList() {
            this.envMap = new HashMap<String, String>();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap<String, String>(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull((String)value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String getExportString() {
            StringBuilder sb = new StringBuilder();
            for (String variable : this.getEnvArray()) {
                sb.append("export \"");
                sb.append(variable);
                sb.append("\"; ");
            }
            return sb.toString();
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

