/*
 * Decompiled with CFR 0.152.
 */
package roboguice.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import roboguice.RoboGuice;
import roboguice.event.EventManager;
import roboguice.inject.RoboInjector;
import roboguice.service.event.OnConfigurationChangedEvent;
import roboguice.service.event.OnCreateEvent;
import roboguice.service.event.OnDestroyEvent;
import roboguice.service.event.OnStartEvent;

public abstract class RoboIntentService
extends IntentService {
    protected EventManager eventManager;

    public RoboIntentService(String name) {
        super(name);
    }

    public void onCreate() {
        RoboInjector injector = RoboGuice.getInjector((Context)this);
        this.eventManager = (EventManager)injector.getInstance(EventManager.class);
        injector.injectMembers((Object)this);
        super.onCreate();
        this.eventManager.fire(new OnCreateEvent());
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        this.eventManager.fire(new OnStartEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        try {
            if (this.eventManager != null) {
                this.eventManager.fire(new OnDestroyEvent());
            }
        }
        finally {
            try {
                RoboGuice.destroyInjector((Context)this);
            }
            finally {
                super.onDestroy();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Configuration currentConfig = this.getResources().getConfiguration();
        super.onConfigurationChanged(newConfig);
        this.eventManager.fire(new OnConfigurationChangedEvent(currentConfig, newConfig));
    }
}

