/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.inject.Singleton;
import roboguice.inject.InjectFragment;
import roboguice.inject.InjectView;
import roboguice.inject.Nullable;

@Singleton
public class ViewListener
implements TypeListener {
    protected static Class fragmentClass = null;
    protected static Class fragmentManagerClass = null;
    protected static Method fragmentGetViewMethod = null;
    protected static Method fragmentFindFragmentByIdMethod = null;
    protected static Method fragmentFindFragmentByTagMethod = null;

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (field.isAnnotationPresent(InjectView.class)) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new UnsupportedOperationException("Views may not be statically injected");
                    }
                    if (!View.class.isAssignableFrom(field.getType())) {
                        throw new UnsupportedOperationException("You may only use @InjectView on fields descended from type View");
                    }
                    if (Context.class.isAssignableFrom(field.getDeclaringClass()) && !Activity.class.isAssignableFrom(field.getDeclaringClass())) {
                        throw new UnsupportedOperationException("You may only use @InjectView in Activity contexts");
                    }
                    typeEncounter.register(new ViewMembersInjector<I>(field, field.getAnnotation(InjectView.class), typeEncounter));
                    continue;
                }
                if (!field.isAnnotationPresent(InjectFragment.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new UnsupportedOperationException("Fragments may not be statically injected");
                }
                if (fragmentClass != null && !fragmentClass.isAssignableFrom(field.getType())) {
                    throw new UnsupportedOperationException("You may only use @InjectFragment on fields descended from type Fragment");
                }
                if (Context.class.isAssignableFrom(field.getDeclaringClass()) && !Activity.class.isAssignableFrom(field.getDeclaringClass())) {
                    throw new UnsupportedOperationException("You may only use @InjectFragment in Activity contexts");
                }
                typeEncounter.register(new ViewMembersInjector<I>(field, field.getAnnotation(InjectFragment.class), typeEncounter));
            }
        }
    }

    static {
        try {
            fragmentClass = Class.forName("android.support.v4.app.Fragment");
            fragmentManagerClass = Class.forName("android.support.v4.app.FragmentManager");
            fragmentGetViewMethod = fragmentClass.getDeclaredMethod("getView", new Class[0]);
            fragmentFindFragmentByIdMethod = fragmentManagerClass.getMethod("findFragmentById", Integer.TYPE);
            fragmentFindFragmentByTagMethod = fragmentManagerClass.getMethod("findFragmentByTag", Object.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class ViewMembersInjector<T>
    implements MembersInjector<T> {
        protected static WeakHashMap<Object, ArrayList<ViewMembersInjector<?>>> viewMembersInjectors = new WeakHashMap();
        protected Field field;
        protected Annotation annotation;
        protected WeakReference<T> instanceRef;
        protected Provider fragmentManagerProvider;
        protected Provider<Activity> activityProvider;

        public ViewMembersInjector(Field field, Annotation annotation, TypeEncounter<T> typeEncounter) {
            this.field = field;
            this.annotation = annotation;
            this.activityProvider = typeEncounter.getProvider(Activity.class);
            if (fragmentManagerClass != null) {
                this.fragmentManagerProvider = typeEncounter.getProvider(fragmentManagerClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void injectMembers(T instance) {
            Class<ViewMembersInjector> clazz = ViewMembersInjector.class;
            synchronized (ViewMembersInjector.class) {
                Activity activity = (Activity)this.activityProvider.get();
                if (fragmentClass != null && fragmentClass.isInstance(instance)) {
                    ArrayList<ViewMembersInjector<Object>> injectors = viewMembersInjectors.get(instance);
                    if (injectors == null) {
                        injectors = new ArrayList();
                        viewMembersInjectors.put(instance, injectors);
                    }
                    injectors.add(this);
                } else {
                    ArrayList<ViewMembersInjector<Object>> injectors = viewMembersInjectors.get(activity);
                    if (injectors == null) {
                        injectors = new ArrayList();
                        viewMembersInjectors.put(activity, injectors);
                    }
                    injectors.add(this);
                }
                this.instanceRef = new WeakReference<T>(instance);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void reallyInjectMembers(Object activityOrFragment) {
            if (this.annotation instanceof InjectView) {
                this.reallyInjectMemberViews(activityOrFragment);
            } else {
                this.reallyInjectMemberFragments(activityOrFragment);
            }
        }

        protected void reallyInjectMemberViews(Object activityOrFragment) {
            Object instance = this.instanceRef.get();
            if (instance == null) {
                return;
            }
            if (activityOrFragment instanceof Context && !(activityOrFragment instanceof Activity)) {
                throw new UnsupportedOperationException("Can't inject view into a non-Activity context");
            }
            Object view = null;
            try {
                InjectView injectView = (InjectView)this.annotation;
                int id = injectView.value();
                if (id >= 0) {
                    view = fragmentClass != null && fragmentClass.isInstance(activityOrFragment) ? ((View)fragmentGetViewMethod.invoke(activityOrFragment, new Object[0])).findViewById(id) : ((Activity)activityOrFragment).findViewById(id);
                } else {
                    Object object = view = fragmentClass != null && fragmentClass.isInstance(activityOrFragment) ? ((View)fragmentGetViewMethod.invoke(activityOrFragment, new Object[0])).findViewWithTag((Object)injectView.tag()) : ((Activity)activityOrFragment).getWindow().getDecorView().findViewWithTag((Object)injectView.tag());
                }
                if (view == null && Nullable.notNullable(this.field)) {
                    throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
                }
                this.field.setAccessible(true);
                this.field.set(instance, view);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException f) {
                throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", view != null ? view.getClass() : "(null)", view, this.field.getType(), this.field.getName()), f);
            }
        }

        protected void reallyInjectMemberFragments(Object activityOrFragment) {
            Object instance = this.instanceRef.get();
            if (instance == null) {
                return;
            }
            if (activityOrFragment instanceof Context && !(activityOrFragment instanceof Activity)) {
                throw new UnsupportedOperationException("Can't inject fragment into a non-Activity context");
            }
            Object fragment = null;
            try {
                InjectFragment injectFragment = (InjectFragment)this.annotation;
                int id = injectFragment.value();
                fragment = id >= 0 ? fragmentFindFragmentByIdMethod.invoke(this.fragmentManagerProvider.get(), id) : fragmentFindFragmentByTagMethod.invoke(this.fragmentManagerProvider.get(), injectFragment.tag());
                if (fragment == null && Nullable.notNullable(this.field)) {
                    throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
                }
                this.field.setAccessible(true);
                this.field.set(instance, fragment);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException f) {
                throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", fragment != null ? fragment.getClass() : "(null)", fragment, this.field.getType(), this.field.getName()), f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void injectViews(Object activityOrFragment) {
            Class<ViewMembersInjector> clazz = ViewMembersInjector.class;
            synchronized (ViewMembersInjector.class) {
                ArrayList<ViewMembersInjector<?>> injectors = viewMembersInjectors.get(activityOrFragment);
                if (injectors != null) {
                    for (ViewMembersInjector<?> viewMembersInjector : injectors) {
                        viewMembersInjector.reallyInjectMembers(activityOrFragment);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

