/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.util;

import java.util.Vector;

public class Csv {
    public static String encode(String value, char quote) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == quote || c == '^') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            if (c < ' ') {
                buf.append('^');
                buf.append((char)(c + 64));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String encode(Object[] values) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            Object v;
            if (i != 0) {
                buf.append(',');
            }
            if ((v = values[i]) instanceof Number || v instanceof Boolean) {
                buf.append(v.toString());
                continue;
            }
            buf.append('\"');
            buf.append(Csv.encode(v.toString(), '\"'));
            buf.append('\"');
        }
        return buf.toString();
    }

    public static String[] decode(String line) {
        Vector<String> tmp = new Vector<String>();
        int p0 = 0;
        int len = line.length();
        while (true) {
            if (p0 < len && line.charAt(p0) <= ' ') {
                ++p0;
                continue;
            }
            if (p0 >= len) break;
            if (line.charAt(p0) == '\"') {
                StringBuffer buf = new StringBuffer();
                while (true) {
                    char c;
                    if ((c = line.charAt(++p0)) == '^' && ++p0 < len) {
                        char c2;
                        buf.append((c2 = line.charAt(p0++)) == '^' ? c2 : (char)(c2 - 64));
                        continue;
                    }
                    if (c == '\"') {
                        if (p0 == len || line.charAt(p0) != '\"') break;
                        ++p0;
                    }
                    buf.append(c);
                }
                tmp.addElement(buf.toString());
                while (p0 < len && line.charAt(p0) <= ' ') {
                    ++p0;
                }
                if (p0 >= len) break;
                if (line.charAt(p0) != ',') {
                    throw new RuntimeException("Comma expected at " + p0 + " line: " + line);
                }
                ++p0;
                continue;
            }
            int p1 = line.indexOf(44, p0);
            if (p1 == -1) {
                tmp.addElement(line.substring(p0).trim());
                break;
            }
            tmp.addElement(line.substring(p0, p1).trim());
            p0 = p1 + 1;
        }
        String[] result = new String[tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmp.elementAt(i);
        }
        return result;
    }
}

