/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.pim;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.kobjects.io.LookAheadReader;
import org.kobjects.pim.PimField;
import org.kobjects.pim.PimItem;

public class PimParser {
    LookAheadReader reader;
    Class type;

    public PimParser(Reader reader, Class type) {
        this.reader = new LookAheadReader(reader);
        this.type = type;
    }

    public PimItem readItem() throws IOException {
        String name;
        PimItem item;
        String beg = this.readName();
        if (beg == null) {
            return null;
        }
        if (!beg.equals("begin")) {
            throw new RuntimeException("'begin:' expected");
        }
        try {
            item = (PimItem)this.type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        this.reader.read();
        if (!item.getType().equals(this.readStringValue().toLowerCase())) {
            throw new RuntimeException("item types do not match!");
        }
        while (!(name = this.readName()).equals("end")) {
            String[] value;
            PimField field = new PimField(name);
            this.readProperties(field);
            switch (item.getType(name)) {
                case 1: {
                    value = this.readArrayValue(item.getArraySize(name));
                    break;
                }
                default: {
                    value = this.readStringValue();
                }
            }
            field.setValue(value);
            System.out.println("value:" + value);
            item.addField(field);
        }
        this.reader.read();
        System.out.println("end:" + this.readStringValue());
        return item;
    }

    String readName() throws IOException {
        String name = this.reader.readTo(":;").trim().toLowerCase();
        System.out.println("name:" + name);
        return this.reader.peek(0) == -1 ? null : name;
    }

    String[] readArrayValue(int size) throws IOException {
        Vector<String> values = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        boolean stay = true;
        do {
            buf.append(this.reader.readTo(";\n\r"));
            switch (this.reader.read()) {
                case 59: {
                    values.addElement(buf.toString());
                    buf.setLength(0);
                    break;
                }
                case 13: {
                    if (this.reader.peek(0) == 10) {
                        this.reader.read();
                    }
                }
                case 10: {
                    if (this.reader.peek(0) != 32) {
                        stay = false;
                        break;
                    }
                    this.reader.read();
                }
            }
        } while (stay);
        if (buf.length() != 0) {
            values.addElement(buf.toString());
        }
        String[] ret = new String[size];
        for (int i = 0; i < Math.min(ret.length, values.size()); ++i) {
            ret[i] = (String)values.elementAt(i);
        }
        return ret;
    }

    String readStringValue() throws IOException {
        String value = this.reader.readLine();
        while (this.reader.peek(0) == 32) {
            this.reader.read();
            value = value + this.reader.readLine();
        }
        return value;
    }

    void readProperties(PimField field) throws IOException {
        int c = this.reader.read();
        while (c == 32) {
            c = this.reader.read();
        }
        while (c != 58) {
            String name = this.reader.readTo(":;=").trim().toLowerCase();
            c = this.reader.read();
            if (c == 61) {
                field.setProperty(name, this.reader.readTo(":;").trim().toLowerCase());
                c = this.reader.read();
                continue;
            }
            field.setAttribute(name, true);
        }
    }
}

