/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.xmlrpc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.kobjects.base64.Base64;
import org.kobjects.isodate.IsoDate;
import org.kobjects.xml.XmlReader;

public class XmlRpcParser {
    private XmlReader parser = null;

    public XmlRpcParser(XmlReader parser) {
        this.parser = parser;
    }

    private final Hashtable parseStruct() throws IOException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        int type = this.nextTag();
        while (type != 3) {
            this.nextTag();
            String name = this.nextText();
            this.nextTag();
            result.put(name, this.parseValue());
            type = this.nextTag();
        }
        this.nextTag();
        return result;
    }

    private final Object parseValue() throws IOException {
        Object result = null;
        int event = this.parser.next();
        if (event == 4) {
            result = this.parser.getText();
            event = this.parser.next();
        }
        if (event == 2) {
            String name = this.parser.getName();
            if (name.equals("array")) {
                result = this.parseArray();
            } else if (name.equals("struct")) {
                result = this.parseStruct();
            } else {
                if (name.equals("string")) {
                    result = this.nextText();
                } else if (name.equals("i4") || name.equals("int")) {
                    result = new Integer(Integer.parseInt(this.nextText().trim()));
                } else if (name.equals("boolean")) {
                    result = new Boolean(this.nextText().trim().equals("1"));
                } else if (name.equals("dateTime.iso8601")) {
                    result = IsoDate.stringToDate(this.nextText(), 3);
                } else if (name.equals("base64")) {
                    result = Base64.decode(this.nextText());
                } else if (name.equals("double")) {
                    result = this.nextText();
                }
                this.nextTag();
            }
        }
        this.nextTag();
        return result;
    }

    private final Vector parseArray() throws IOException {
        this.nextTag();
        int type = this.nextTag();
        Vector<Object> vec = new Vector<Object>();
        while (type != 3) {
            vec.addElement(this.parseValue());
            type = this.parser.getType();
        }
        this.nextTag();
        this.nextTag();
        return vec;
    }

    private final Object parseFault() throws IOException {
        this.nextTag();
        Object value = this.parseValue();
        this.nextTag();
        return value;
    }

    private final Object parseParams() throws IOException {
        Vector<Object> params = new Vector<Object>();
        int type = this.nextTag();
        while (type != 3) {
            this.nextTag();
            params.addElement(this.parseValue());
            type = this.nextTag();
        }
        this.nextTag();
        return params;
    }

    public final Object parseResponse() throws IOException {
        Object result = null;
        this.nextTag();
        int event = this.nextTag();
        if (event == 2) {
            if ("fault".equals(this.parser.getName())) {
                result = this.parseFault();
            } else if ("params".equals(this.parser.getName())) {
                result = this.parseParams();
            }
        }
        return result;
    }

    private final int nextTag() throws IOException {
        int type = this.parser.getType();
        type = this.parser.next();
        if (type == 4 && this.parser.isWhitespace()) {
            type = this.parser.next();
        }
        if (type != 3 && type != 2) {
            throw new IOException("unexpected type: " + type);
        }
        return type;
    }

    private final String nextText() throws IOException {
        String result;
        int type = this.parser.getType();
        if (type != 2) {
            throw new IOException("precondition: START_TAG");
        }
        type = this.parser.next();
        if (type == 4) {
            result = this.parser.getText();
            type = this.parser.next();
        } else {
            result = "";
        }
        if (type != 3) {
            throw new IOException("END_TAG expected");
        }
        return result;
    }
}

