/*
 * Decompiled with CFR 0.152.
 */
package roboguice;

import android.app.Application;
import android.content.Context;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.StaticInjectionRequest;
import java.util.ArrayList;
import java.util.WeakHashMap;
import roboguice.config.DefaultRoboModule;
import roboguice.event.EventManager;
import roboguice.inject.ContextScope;
import roboguice.inject.ContextScopedRoboInjector;
import roboguice.inject.ResourceListener;
import roboguice.inject.RoboInjector;
import roboguice.inject.ViewListener;

public class RoboGuice {
    public static Stage DEFAULT_STAGE = Stage.PRODUCTION;
    protected static WeakHashMap<Application, Injector> injectors = new WeakHashMap();
    protected static WeakHashMap<Application, ResourceListener> resourceListeners = new WeakHashMap();
    protected static WeakHashMap<Application, ViewListener> viewListeners = new WeakHashMap();

    private RoboGuice() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector getBaseApplicationInjector(Application application) {
        Injector rtrn = injectors.get(application);
        if (rtrn != null) {
            return rtrn;
        }
        Class<RoboGuice> clazz = RoboGuice.class;
        synchronized (RoboGuice.class) {
            rtrn = injectors.get(application);
            if (rtrn != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return rtrn;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return RoboGuice.setBaseApplicationInjector(application, DEFAULT_STAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector setBaseApplicationInjector(final Application application, Stage stage, Module ... modules) {
        for (Element element : Elements.getElements((Module[])modules)) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public Void visit(StaticInjectionRequest element) {
                    RoboGuice.getResourceListener(application).requestStaticInjection(element.getType());
                    return null;
                }
            });
        }
        Class<RoboGuice> clazz = RoboGuice.class;
        synchronized (RoboGuice.class) {
            Injector rtrn = Guice.createInjector((Stage)stage, (Module[])modules);
            injectors.put(application, rtrn);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return rtrn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector setBaseApplicationInjector(Application application, Stage stage) {
        Class<RoboGuice> clazz = RoboGuice.class;
        synchronized (RoboGuice.class) {
            int id = application.getResources().getIdentifier("roboguice_modules", "array", application.getPackageName());
            String[] moduleNames = id > 0 ? application.getResources().getStringArray(id) : new String[]{};
            ArrayList<DefaultRoboModule> modules = new ArrayList<DefaultRoboModule>();
            DefaultRoboModule defaultRoboModule = RoboGuice.newDefaultRoboModule(application);
            modules.add(defaultRoboModule);
            try {
                for (String name : moduleNames) {
                    Class<Module> clazz2 = Class.forName(name).asSubclass(Module.class);
                    modules.add((DefaultRoboModule)clazz2.newInstance());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Injector rtrn = RoboGuice.setBaseApplicationInjector(application, stage, modules.toArray(new Module[modules.size()]));
            injectors.put(application, rtrn);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rtrn;
        }
    }

    public static RoboInjector getInjector(Context context) {
        Application application = (Application)context.getApplicationContext();
        return new ContextScopedRoboInjector(context, RoboGuice.getBaseApplicationInjector(application), RoboGuice.getViewListener(application));
    }

    public static <T> T injectMembers(Context context, T t) {
        RoboGuice.getInjector(context).injectMembers(t);
        return t;
    }

    public static DefaultRoboModule newDefaultRoboModule(Application application) {
        return new DefaultRoboModule(application, new ContextScope(), RoboGuice.getViewListener(application), RoboGuice.getResourceListener(application));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ResourceListener getResourceListener(Application application) {
        ResourceListener resourceListener = resourceListeners.get(application);
        if (resourceListener != null) return resourceListener;
        Class<RoboGuice> clazz = RoboGuice.class;
        synchronized (RoboGuice.class) {
            if (resourceListener != null) return resourceListener;
            resourceListener = new ResourceListener(application);
            resourceListeners.put(application, resourceListener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return resourceListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ViewListener getViewListener(Application application) {
        ViewListener viewListener = viewListeners.get(application);
        if (viewListener != null) return viewListener;
        Class<RoboGuice> clazz = RoboGuice.class;
        synchronized (RoboGuice.class) {
            if (viewListener != null) return viewListener;
            viewListener = new ViewListener();
            viewListeners.put(application, viewListener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return viewListener;
        }
    }

    public static void destroyInjector(Context context) {
        RoboInjector injector = RoboGuice.getInjector(context);
        ((EventManager)injector.getInstance(EventManager.class)).destroy();
        ((ContextScope)injector.getInstance(ContextScope.class)).destroy(context);
        injectors.remove(context);
    }

    public static class util {
        private util() {
        }

        public static void reset() {
            injectors.clear();
            resourceListeners.clear();
            viewListeners.clear();
        }
    }
}

