/**
 *  commons-gallery, a common API module for ReGalAndroid
 *  URLs: https://github.com/anthonydahanne/ReGalAndroid , http://blog.dahanne.net
 *  Copyright (c) 2010 Anthony Dahanne
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package net.dahanne.gallery.commons.model;

import java.io.Serializable;

public class Picture implements Serializable {

	private static final long serialVersionUID = 4719347243965813169L;
	private long id;
	private String title;
	private String fileName;

	private String thumbUrl;
	private int thumbWidth;
	private int thumbHeight;
	private int thumbSize;
	private String thumbImageCachePath;

	private String resizedUrl;
	private int resizedWidth;
	private int resizedHeight;
	private int resizedSize;
	private String resizedImageCachePath;

	private String fileUrl;
	private int width;
	private int height;
	private int fileSize;

	private String caption;
	private String forceExtension;
	private boolean hidden;
	
	private String publicUrl;


	public String getFileName() {
		return fileName;
	}

	public void setFileName(String name) {
		this.fileName = name;
	}

	public String getThumbUrl() {
		return thumbUrl;
	}

	public void setThumbUrl(String thumbName) {
		this.thumbUrl = thumbName;
	}

	public int getThumbWidth() {
		return thumbWidth;
	}

	public void setThumbWidth(int thumbWidth) {
		this.thumbWidth = thumbWidth;
	}

	public int getThumbHeight() {
		return thumbHeight;
	}

	public void setThumbHeight(int thumbHeight) {
		this.thumbHeight = thumbHeight;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getResizedUrl() {
		return resizedUrl;
	}

	public void setResizedUrl(String resizedName) {
		this.resizedUrl = resizedName;
	}

	public int getResizedWidth() {
		return resizedWidth;
	}

	public void setResizedWidth(int resizedWidth) {
		this.resizedWidth = resizedWidth;
	}

	public int getResizedHeight() {
		return resizedHeight;
	}

	public void setResizedHeight(int resizedHeight) {
		this.resizedHeight = resizedHeight;
	}

	public int getFileSize() {
		return fileSize;
	}

	public void setFileSize(int rawFilesize) {
		this.fileSize = rawFilesize;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int rawWidth) {
		this.width = rawWidth;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int rawHeight) {
		this.height = rawHeight;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getId() {
		return id;
	}

	public void setResizedImageCachePath(String resizedImagePath) {
		this.resizedImageCachePath = resizedImagePath;
	}

	public String getResizedImageCachePath() {
		return resizedImageCachePath;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getForceExtension() {
		return forceExtension;
	}

	public void setForceExtension(String forceExtension) {
		this.forceExtension = forceExtension;
	}

	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public void setThumbImageCachePath(String thumbImagePath) {
		this.thumbImageCachePath = thumbImagePath;
	}

	public String getThumbImageCachePath() {
		return thumbImageCachePath;
	}


	public int getThumbSize() {
		return thumbSize;
	}

	public void setThumbSize(int thumbSize) {
		this.thumbSize = thumbSize;
	}

	public int getResizedSize() {
		return resizedSize;
	}

	public void setResizedSize(int resizeSize) {
		this.resizedSize = resizeSize;
	}

	public String getFileUrl() {
		return fileUrl;
	}

	public void setFileUrl(String fileUrl) {
		this.fileUrl = fileUrl;
	}
	
	
	
//	@Override
//	public String toString() {
//		return new StringBuilder().append(title).append(name).toString();
//	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + fileSize;
		result = prime * result + ((fileUrl == null) ? 0 : fileUrl.hashCode());
		result = prime * result + height;
		result = prime * result + (int) (id ^ (id >>> 32));
		result = prime * result + ((fileName == null) ? 0 : fileName.hashCode());
		result = prime * result + resizedHeight;
		result = prime * result + resizedSize;
		result = prime * result
				+ ((resizedUrl == null) ? 0 : resizedUrl.hashCode());
		result = prime * result + resizedWidth;
		result = prime * result + thumbHeight;
		result = prime * result + thumbSize;
		result = prime * result
				+ ((thumbUrl == null) ? 0 : thumbUrl.hashCode());
		result = prime * result + thumbWidth;
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result + width;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Picture other = (Picture) obj;
		if (fileSize != other.fileSize)
			return false;
		if (fileUrl == null) {
			if (other.fileUrl != null)
				return false;
		} else if (!fileUrl.equals(other.fileUrl))
			return false;
		if (publicUrl == null) {
			if (other.publicUrl != null)
				return false;
		} else if (!publicUrl.equals(other.publicUrl))
			return false;
		if (height != other.height)
			return false;
		if (id != other.id)
			return false;
		if (fileName == null) {
			if (other.fileName != null)
				return false;
		} else if (!fileName.equals(other.fileName))
			return false;
		if (resizedHeight != other.resizedHeight)
			return false;
		if (resizedSize != other.resizedSize)
			return false;
		if (resizedUrl == null) {
			if (other.resizedUrl != null)
				return false;
		} else if (!resizedUrl.equals(other.resizedUrl))
			return false;
		if (resizedWidth != other.resizedWidth)
			return false;
		if (thumbHeight != other.thumbHeight)
			return false;
		if (thumbSize != other.thumbSize)
			return false;
		if (thumbUrl == null) {
			if (other.thumbUrl != null)
				return false;
		} else if (!thumbUrl.equals(other.thumbUrl))
			return false;
		if (thumbWidth != other.thumbWidth)
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		if (width != other.width)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("Picture [id=");
		stringBuilder.append(id);
		stringBuilder.append(", title=");
		stringBuilder.append(title);
		stringBuilder.append(", name=");
		stringBuilder.append(fileName);
		stringBuilder.append(", thumbUrl=");
		stringBuilder.append(thumbUrl);
		stringBuilder.append(", thumbWidth=");
		stringBuilder.append(thumbWidth);
		stringBuilder.append(", thumbHeight=");
		stringBuilder.append(thumbHeight);
		stringBuilder.append(", thumbSize=");
		stringBuilder.append(thumbSize);
		stringBuilder.append(", thumbImageCachePath=");
		stringBuilder.append(thumbImageCachePath);
		stringBuilder.append(", resizedUrl=");
		stringBuilder.append(resizedUrl);
		stringBuilder.append(", resizedWidth=");
		stringBuilder.append(resizedWidth);
		stringBuilder.append(", resizedHeight=");
		stringBuilder.append(resizedHeight);
		stringBuilder.append(", resizedSize=");
		stringBuilder.append(resizedSize);
		stringBuilder.append(", resizedImageCachePath=");
		stringBuilder.append(resizedImageCachePath);
		stringBuilder.append(", fileUrl=");
		stringBuilder.append(fileUrl);
		stringBuilder.append(", width=");
		stringBuilder.append(width);
		stringBuilder.append(", height=");
		stringBuilder.append(height);
		stringBuilder.append(", fileSize=");
		stringBuilder.append(fileSize);
		stringBuilder.append(", caption=");
		stringBuilder.append(caption);
		stringBuilder.append(", forceExtension=");
		stringBuilder.append(forceExtension);
		stringBuilder.append(", hidden=");
		stringBuilder.append(hidden);
		stringBuilder.append("]");
		return stringBuilder.toString();
	}

	public void setPublicUrl(String publicUrl) {
		this.publicUrl = publicUrl;
	}

	public String getPublicUrl() {
		return publicUrl;
	}
	

}
