package net.aangle.rvclock;

import java.util.ArrayList;
import java.util.List;

import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;

public class SelectApplicationDialogBuilder extends Builder {
    public interface ApplicationSelectListener {
        public void onApplicationSelected(String packageName, String className, String name);
    }
    
    private class ActivityStartInfo {
        String name;
        Drawable icon;
        String packageName;
        String className;
    }
    
    private List<ActivityStartInfo> activities;
    private Context context;
    private ApplicationSelectListener listener; 
    
    public SelectApplicationDialogBuilder(Context arg0, ApplicationSelectListener listener) {
        super(arg0);
        this.context = arg0;
        this.listener = listener;
        loadApplicationList(arg0);
    }

    private void loadApplicationList(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.addCategory(Intent.CATEGORY_LAUNCHER);
        List<ResolveInfo> foundActivities = pm.queryIntentActivities(intent, 0);
        activities = new ArrayList<ActivityStartInfo>(foundActivities.size());
        for (ResolveInfo ri: foundActivities) {
            ActivityStartInfo asi = new ActivityStartInfo();
            try {
				asi.name = pm.getResourcesForApplication(ri.activityInfo.applicationInfo).getString(ri.activityInfo.labelRes);
				asi.icon = pm.getResourcesForApplication(ri.activityInfo.applicationInfo).getDrawable(ri.activityInfo.icon);
			} catch (Exception e) {
				asi.name = pm.getApplicationLabel(ri.activityInfo.applicationInfo).toString();
	            asi.icon = pm.getApplicationIcon(ri.activityInfo.applicationInfo);				
			}
            asi.packageName = ri.activityInfo.packageName;
            asi.className = ri.activityInfo.name;
            activities.add(asi);
        }
    }

    public AlertDialog create() {
        setTitle(R.string.select_app_title);
        setAdapter(new Adapter(context, activities), new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface arg0, int arg1) {
                if (listener != null) {
                    ActivityStartInfo asi = activities.get(arg1);
                    listener.onApplicationSelected(asi.packageName, asi.className, asi.name);
                }
            }
        });
        return super.create();
    }
    
    private class Holder {
        public TextView name;
        public ImageView icon;
    }
    
    private class Adapter implements ListAdapter {
        private List<ActivityStartInfo> list;
        private LayoutInflater inflater;

        public Adapter(Context ctx, List<ActivityStartInfo> list) {
            this.inflater = (LayoutInflater)ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            this.list = list;
        }

        public int getCount() {
            return list.size();
        }

        public Object getItem(int arg0) {
            return list.get(arg0);
        }

        public long getItemId(int arg0) {
            return arg0;
        }

        public int getItemViewType(int arg0) {
            return 0;
        }

        public View getView(int position, View v, ViewGroup arg2) {
            Holder h;
            if (v != null) {
                h = (Holder) v.getTag();
            } else {
                v = inflater.inflate(R.layout.activity_chooser_layout, null);
                h = new Holder();
                h.icon = (ImageView) v.findViewById(R.id.list_icon);
                h.name = (TextView) v.findViewById(R.id.list_text);
                v.setTag(h);
            }
            ActivityStartInfo asi = list.get(position);
            h.icon.setImageDrawable(asi.icon);
            h.name.setText(asi.name);
            return v;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean hasStableIds() {
            return true;
        }

        public boolean isEmpty() {
            return list.size() == 0;
        }

        public void registerDataSetObserver(DataSetObserver arg0) {
            
        }

        public void unregisterDataSetObserver(DataSetObserver arg0) {
            
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int arg0) {
            return true;
        }
    }
}
