package net.aangle.rvclock;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.RemoteViews;

public abstract class RvClockWidget extends AppWidgetProvider {
	
	public static final boolean DEBUG = true;
	public static final String TAG = "RvClock";

	public static final String FORCE_UPDATE_WIDGET = "net.aangle.rvclock.FORCE_UPDATE";
	public static final String ACTION_CONFIGURE = "net.aangle.rvclock.CONFIGURE";

	public RvClockWidget() {
		super();
	}

	@Override
	public void onReceive(Context context, Intent intent) {
		if (DEBUG)
			Log.d(TAG, "Receive: " + intent.toString());
		if (FORCE_UPDATE_WIDGET.equals(intent.getAction()) || 
			AppWidgetManager.ACTION_APPWIDGET_UPDATE.equals(intent.getAction())) {
			AppWidgetManager apwm = AppWidgetManager.getInstance(context);
			int[] appWidgetIds = apwm.getAppWidgetIds(new ComponentName(
					context, getClass()));
			onUpdate(context, apwm, appWidgetIds);
		} else
			super.onReceive(context, intent);
	}

	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
		if (DEBUG)
			Log.d(TAG, "OnUpdate");
		final int len = appWidgetIds.length;
		
		Painter painter;
		
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
		
		for (int i = 0; i < len; ++i) {
		    painter = getPainter(context, appWidgetIds[i]);
			RemoteViews rv = new RemoteViews(context.getPackageName(), getWidgetLayout());
			painter.draw(context, rv);
			if (DEBUG)
				Log.d(TAG, "Updating widget id=" + appWidgetIds[i]);
			
			int onClick = Integer.parseInt(prefs.getString("on_click", "0"));
			
			switch (onClick) {
			case 0:
				if (DEBUG)
					Log.d(TAG, "Setting self-configure on-click");
				rv.setOnClickPendingIntent(R.id.image, painter.getSelfConfigureIntent(appWidgetIds[i], context));
				break;
			case 1:
				if (DEBUG)
					Log.d(TAG, "Setting up application intent");
				String app = prefs.getString(RvClockSetupActivity.EXEC_APP, "");
				if (TextUtils.isEmpty(app)) 
					rv.setOnClickPendingIntent(R.id.image, painter.getSelfConfigureIntent(appWidgetIds[i], context));
				else
					rv.setOnClickPendingIntent(R.id.image, getApplicationIntent(appWidgetIds[i], prefs, context));
				break;
			default:
				if (DEBUG)
					Log.d(TAG, "Do nothing on click");
				rv.setOnClickPendingIntent(R.id.image, PendingIntent.getActivity(context, 0, null, 0));
				break;
			}
			
				//rv.setOnClickPendingIntent(R.id.image, painter.getAlarmClockIntent(appWidgetIds[i], context));
			appWidgetManager.updateAppWidget(appWidgetIds[i], rv);				
		}
	}
	
	protected int getWidgetLayout() {
		return R.layout.rvclock_widget;
	}

	private PendingIntent getApplicationIntent(int i, SharedPreferences prefs, Context context) {
		Intent run = new Intent(Intent.ACTION_MAIN);
		run.addCategory(Intent.CATEGORY_DEFAULT);
		String[] app = prefs.getString(RvClockSetupActivity.EXEC_APP, "").split("\t");
		if (app.length != 3)
			return null;
		run.setComponent(new ComponentName(app[0], app[1]));
		return PendingIntent.getActivity(context, 0, run, 0);
	}

	protected abstract Painter getPainter(Context context, int id);

	@Override
	public void onDisabled(Context context) {
		super.onDisabled(context);
		AlarmManager alm = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		alm.cancel(getPendingIntent(context));
	}

	@Override
	public void onEnabled(Context context) {
		super.onEnabled(context);
		AlarmManager alm = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		long time = System.currentTimeMillis() / 60000 * 60000 + 60500;
		alm.setRepeating(AlarmManager.RTC, time, 60000,
				getPendingIntent(context));
		if (DEBUG)
			Log.d(TAG, "Set updating intent");
	}

	private PendingIntent getPendingIntent(Context context) {
		Intent intent = new Intent(context, getClass());
		intent.setComponent(new ComponentName(context, this.getClass()));
		intent.setAction(AppWidgetManager.ACTION_APPWIDGET_UPDATE);
		//intent.setAction(ACTION_CONFIGURE);
		return PendingIntent.getBroadcast(context, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);
	}

}