package net.aangle.rvclock;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.DialogPreference;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

public class RvClockSetupActivity extends PreferenceActivity implements OnClickListener, 
	OnSharedPreferenceChangeListener {

	private static final String MINUTE_COLOR = "minute_color";
	private static final String HOUR_COLOR = "hour_color";
	private static final String BG_COLOR = "bg_color";
	private static final String ON_CLICK = "on_click";
	public static final String EXEC_APP = "exec_app";
	
	private int widgetId;
	
	private boolean firstConfigure;
	
	private ListPreference bgPreference, clickPreference;
	private DialogPreference executePreference;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		addPreferencesFromResource(R.xml.rvclock_setup_prefs);
		setContentView(R.layout.setup_activity);
		
		Bundle extras = getIntent().getExtras();
		if (extras != null) {
			widgetId = extras.getInt(AppWidgetManager.EXTRA_APPWIDGET_ID, 
		            AppWidgetManager.INVALID_APPWIDGET_ID);
			if (RvClockWidget.DEBUG)
				Log.d(RvClockWidget.TAG, "Got config intent, widgetId=" + widgetId);
		} else  {
			if (RvClockWidget.DEBUG)
				Log.d(RvClockWidget.TAG, "No widgetIds received");
			finish();
		}
		
		firstConfigure = !getIntent().getAction().equals(RvClockWidget.ACTION_CONFIGURE);
		
		Button btn = (Button) findViewById(R.id.save_button);
		btn.setOnClickListener(this);
		
		Button reset = (Button) findViewById(R.id.reset_button);
		reset.setOnClickListener(this);
		
		bgPreference = (ListPreference) findPreference(BG_COLOR);
		clickPreference = (ListPreference) findPreference(ON_CLICK);
		executePreference = (DialogPreference) findPreference(EXEC_APP);
		
		clickPreference.setEnabled(firstConfigure);
		executePreference.setEnabled(Integer.parseInt(clickPreference.getValue()) == 1 || firstConfigure);
		
		setResult(Activity.RESULT_CANCELED);		
	}

	public void onClick(View arg0) {
		
		if (arg0.getId() == R.id.save_button) {
			
			Intent result = new Intent();
			result.putExtra(AppWidgetManager.EXTRA_APPWIDGET_ID, widgetId);
			setResult(RESULT_OK, result);
			
			// Fixing SharedPreferences
			SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
			
			if (Integer.parseInt(prefs.getString(ON_CLICK, "0")) == 1 && 
					TextUtils.isEmpty(prefs.getString(EXEC_APP, ""))) {
				Toast.makeText(this, R.string.no_app_selected, Toast.LENGTH_SHORT).show();
				return;
			}
			
			String color = prefs.getString(BG_COLOR, "0");
			int hours = prefs.getInt(HOUR_COLOR, Painter.HOUR_COLOR);
			int mins = prefs.getInt(MINUTE_COLOR, Painter.MINUTE_COLOR);
			SharedPreferences.Editor editor = prefs.edit();
			editor.putString("bg_color_" + widgetId, color);
			editor.putInt("hour_color_" + widgetId, hours);
			editor.putInt("minute_color_" + widgetId, mins);
			
			editor.putString("exec_app_" + widgetId, prefs.getString(EXEC_APP, ""));
			
			editor.commit();
	
			updateWidget();
			finish();
		} else if (arg0.getId() == R.id.reset_button) {
			SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
			Editor e = prefs.edit();
			if (firstConfigure)
				e.putString(ON_CLICK, "0");
			e.putString(BG_COLOR, "0");
			e.putInt(HOUR_COLOR, Painter.HOUR_COLOR);
			e.putInt(MINUTE_COLOR, Painter.MINUTE_COLOR);
			e.putString("exec_app_" + widgetId, "");
			e.commit();
		}
	}

	private void updateWidget() {
		if (RvClockWidget.DEBUG)
			Log.d(RvClockWidget.TAG, "Forcing widget update, widgetId=" + widgetId);
		AppWidgetManager awm = AppWidgetManager.getInstance(this);
		AppWidgetProviderInfo awinfo = awm.getAppWidgetInfo(widgetId);
		
		Intent updateWidget = new Intent(RvClockWidget.FORCE_UPDATE_WIDGET);
		updateWidget.setComponent(awinfo.provider);
		updateWidget.putExtra(AppWidgetManager.EXTRA_APPWIDGET_IDS, new int[] { widgetId });
		PendingIntent pi = PendingIntent.getBroadcast(this, 0, updateWidget, PendingIntent.FLAG_CANCEL_CURRENT);
		
		AlarmManager alm = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
		alm.set(AlarmManager.RTC, System.currentTimeMillis() + 250, pi);
	}

	public void onSharedPreferenceChanged(SharedPreferences prefs,
			String key) {
		if (BG_COLOR.equals(key)) {
			int idx = Integer.parseInt(prefs.getString(key, "0"));
			bgPreference.setSummary(getResources().getStringArray(R.array.bg_colors_list)[idx]);
		} else if (ON_CLICK.equals(key)) {
			int idx = Integer.parseInt(prefs.getString(key, "0"));
			clickPreference.setSummary(getResources().getStringArray(R.array.click_list)[idx]);
			executePreference.setEnabled(idx == 1);
		} else if (EXEC_APP.equals(key)) {
			String[] items = prefs.getString(key, "").split("\t");
			if (items.length == 3)
				executePreference.setSummary(items[2]);
			else
				executePreference.setSummary("");
		}
	}

	@Override
	protected void onPause() {
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);		
	}

	@Override
	protected void onResume() {
		super.onResume();
		final SharedPreferences prefs = getPreferenceScreen().getSharedPreferences();
        prefs.registerOnSharedPreferenceChangeListener(this);
        onSharedPreferenceChanged(prefs, BG_COLOR);
        onSharedPreferenceChanged(prefs, ON_CLICK);
        onSharedPreferenceChanged(prefs, EXEC_APP);
	}

}
