package net.aangle.rvclock;

import net.aangle.rvclock.ColorDialogBuilder.OnColorChangedListener;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.preference.DialogPreference;
import android.util.AttributeSet;

public class ColorPreference extends DialogPreference implements
		OnColorChangedListener {

	private int mColor;
	private AlertDialog mDialog;

	public ColorPreference(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public ColorPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		TypedArray a = context.obtainStyledAttributes(attrs,
                R.styleable.ColorPreference, defStyle, 0);
        mColor = a.getInteger(R.styleable.ColorPreference_color, Painter.HOUR_COLOR);
	}

	@Override
	protected Object onGetDefaultValue(TypedArray a, int index) {
		return super.onGetDefaultValue(a, index);
	}

	@Override
	protected void onSetInitialValue(boolean restorePersistedValue,
			Object defaultValue) {
		setColor(restorePersistedValue ? getPersistedInt(mColor) : (Integer) defaultValue);
	}
	
	@Override
    protected void showDialog(Bundle state) {
        Context context = getContext();

        // Create the dialog
        ColorDialogBuilder builder = new ColorDialogBuilder(context, this, mColor);
        builder.setTitle(R.string.pick_color);
        builder.setPositiveButton(R.string.close_dialog, null);
        //final Dialog dialog = mDialog = new ColorPickerDialog(context, this, mColor);
        final Dialog dialog = mDialog = builder.create();
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        dialog.setOnDismissListener(this);
        dialog.show();
    }	
	
	@Override
	public Dialog getDialog() {
		return mDialog;
	}

	public int getColor() {
		return mColor;
	}

	public void setColor(int color) {
		if (mColor != color) {
			mColor = color;
			persistInt(mColor);
			notifyDependencyChange(shouldDisableDependents());
			notifyChanged();
		}
	}

	public void colorChanged(int color) {
		setColor(color);
	}

}
