package net.aangle.rvclock;

import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class ColorDialogBuilder extends AlertDialog.Builder {
	
    public interface OnColorChangedListener {
        void colorChanged(int color);
    }

    private OnColorChangedListener mListener;
	private LinearLayout mPreview;
	private SeekBar mRed, mGreen, mBlue, mAlpha;
	private TextView mRedText, mGreenText, mBlueText, mAlphaText;
	private LayoutInflater mInflater;
	private int mColor;
	private View mView;
	
	private OnSeekBarChangeListener mOnColorChange = new OnSeekBarChangeListener() {
		
		public void onStopTrackingTouch(SeekBar seekBar) {
		}
		
		public void onStartTrackingTouch(SeekBar seekBar) {
		}
		
		public void onProgressChanged(SeekBar seekBar, int progress,
				boolean fromUser) {
			if (!fromUser)
				return;
			switch (seekBar.getId()) {
			case R.id.red:
				mColor = (mColor & 0xFF00FFFF) | ((progress & 0xFF) << 16);
				mRedText.setText(Integer.toString(progress));
				break;
			case R.id.green:
				mColor = (mColor & 0xFFFF00FF) | ((progress & 0xFF) << 8);
				mGreenText.setText(Integer.toString(progress));
				break;
			case R.id.blue:
				mColor = (mColor & 0xFFFFFF00) | (progress & 0xFF);
				mBlueText.setText(Integer.toString(progress));
				break;
			case R.id.alpha:
				mColor = (mColor & 0x00FFFFFF) | ((progress & 0xFF) << 24);
				mAlphaText.setText(Integer.toString(progress));
				break;				
			}
			mPreview.setBackgroundColor(mColor);
			if (mListener != null)
				mListener.colorChanged(mColor);
		}
	};
	public ColorDialogBuilder(Context context, OnColorChangedListener listener, int color) {
		super(context);
		
		mColor = color;
		mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		mView = mInflater.inflate(R.layout.color_dialog_layout, null);
		
		setView(mView);
		mPreview = (LinearLayout) mView.findViewById(R.id.color_preview);
		mRed = (SeekBar) mView.findViewById(R.id.red);
		mGreen = (SeekBar) mView.findViewById(R.id.green);
		mBlue = (SeekBar) mView.findViewById(R.id.blue);
		mAlpha = (SeekBar) mView.findViewById(R.id.alpha);
		
		mRedText = (TextView) mView.findViewById(R.id.red_value);
		mGreenText = (TextView) mView.findViewById(R.id.green_value);
		mBlueText = (TextView) mView.findViewById(R.id.blue_value);
		mAlphaText = (TextView) mView.findViewById(R.id.alpha_value);
		
		mAlpha.setProgress((mColor >> 24) & 0xFF);
		mRed.setProgress((mColor >> 16) & 0xFF);
		mGreen.setProgress((mColor >> 8) & 0xFF);
		mBlue.setProgress(mColor & 0xFF);
		
		mAlphaText.setText(Integer.toString((mColor >> 24) & 0xFF));
		mRedText.setText(Integer.toString((mColor >> 16) & 0xFF));
		mGreenText.setText(Integer.toString((mColor >> 8) & 0xFF));
		mBlueText.setText(Integer.toString(mColor & 0xFF));
		
		mPreview.setBackgroundColor(mColor);		
		
		mRed.setOnSeekBarChangeListener(mOnColorChange);
		mGreen.setOnSeekBarChangeListener(mOnColorChange);
		mBlue.setOnSeekBarChangeListener(mOnColorChange);
		mAlpha.setOnSeekBarChangeListener(mOnColorChange);
		
		mListener = listener;		
	}
}
