<div align="center">
    <img width="200" height="200" style="display: block; border: 1px solid #f5f5f5; border-radius: 9999px;" src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/icon.png">
</div>

<br>
<br>
<br>

<div align="center">
    <img alt="GitHub" src="https://img.shields.io/github/license/ReadYouApp/ReadYou?color=c3e7ff&style=flat-square">
    <a target="_blank" href="https://github.com/ReadYouApp/ReadYou/releases">
        <img alt="Version" src="https://img.shields.io/github/v/release/ReadYouApp/ReadYou?color=c3e7ff&label=version&style=flat-square">
    </a>
    <img alt="GitHub last commit" src="https://img.shields.io/github/last-commit/ReadYouApp/ReadYou?color=c3e7ff&style=flat-square">
    <br>
    <a target="_blank" href="https://t.me/ReadYouApp">
        <img alt="Telegram" src="https://img.shields.io/badge/Telegram-ReadYouApp-c3e7ff?logo=telegram&style=flat-square">
    </a>
    <a target="_blank" href="https://www.figma.com/file/ViBW8GbUgkTMmK6a80h8X1/Read-You?node-id=7028%3A23673">
        <img alt="Figma" src="https://img.shields.io/badge/Figma-ReadYou-c3e7ff?logo=figma&style=flat-square">
    </a>
</div>

<div align="center">
    <h1>Read You</h1>
    <p>Ein Android RSS-Reader, präsentiert im <a target="_blank" href="https://m3.material.io/">Material You</a> Designstil.</p>
    <p><a target="_blank" href="https://github.com/ReadYouApp/ReadYou/blob/main/README.md">English</a>&nbsp;&nbsp;|&nbsp;&nbsp;
    Deutsch&nbsp;&nbsp;|&nbsp;&nbsp;
    <a target="_blank" href="https://github.com/ReadYouApp/ReadYou/blob/main/README-zh-CN.md">简体中文</a>&nbsp;&nbsp;|&nbsp;&nbsp;
    <a target="_blank" href="https://github.com/ReadYouApp/ReadYou/blob/main/README-zh-TW.md">繁體中文</a>&nbsp;&nbsp;|&nbsp;&nbsp;
    <a target="_blank" href="https://github.com/ReadYouApp/ReadYou/blob/main/README-fa.md">فارسی</a></p>
    <br/>
    <br/>
    <img src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/phoneScreenshots/startup.png" width="19.2%" alt="startup" />
    <img src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/phoneScreenshots/feeds.png" width="19.2%" alt="feeds" />
    <img src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/phoneScreenshots/flow.png" width="19.2%" alt="flow" />
    <img src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/phoneScreenshots/read.png" width="19.2%" alt="read" />
    <img src="https://raw.githubusercontent.com/ReadYouApp/ReadYou/main/fastlane/metadata/android/de-DE/images/phoneScreenshots/settings.png" width="19.2%" alt="settings" />
    <br/>
    <br/>
</div>

## Funktionen

**Read You** ist ein Android RSS-Reader, präsentiert im [Material You](https://m3.material.io/) Designstil.

Nachfolgend sind die bisher erzielten Fortschritte und die Ziele aufgeführt, an denen in naher Zukunft gearbeitet werden soll:

- [x] RSS Links abonieren
- [x] OPML-Dateien importieren oder exportieren
- [x] Benachrichtigung über neue Artikel
- [x] Optimierung der Lesbarkeit von Artikeln
- [x] Gesamtinhalt abrufen für Originalartikel
- [x] Mehrere Konten
- [x] Bionisches Lesen
- [x] Vorlesen
- [ ] Android Widget
- [ ] ...

## Integration

**Read You** ist mit einigen APIs von Drittanbietern kompatibel, um bei der Nutzung Ihrer bestehenden Cloud-Konten als Datenquellen zu unterstützen.

- [x] Fever
- [x] Google Reader
- [x] FreshRSS
- [ ] Miniflux
- [ ] Tiny Tiny RSS
- [ ] Inoreader
- [ ] Feedly
- [ ] Feedbin
- [ ] ...

## Herunterladen

[<img src="https://s1.ax1x.com/2023/01/12/pSu1a36.png" alt="Hole es auf GitHub" height="80">](https://github.com/ReadYouApp/ReadYou/releases)
[<img src="https://s1.ax1x.com/2023/01/12/pSnTZ0f.png"
     alt="Hole es im Telegram Channel"
     height="80">](https://t.me/ReadYouApp)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on-de.png"
     alt="Jetzt bei F-Droid"
     height="80">](https://f-droid.org/packages/me.ash.reader/)

F-Droid-Versionen können nicht auf andere Versionen aktualisiert werden und werden kompiliert, signiert und einheitlich verteilt von [F-Droid](https://f-droid.org/docs/FAQ_-_General/).

## Nightly

Wir bieten Nightly-Versionen zu Testzwecken an. Diese Versionen enthalten die neuesten Funktionen und Verbesserungen, sind jedoch möglicherweise nicht so stabil wie unsere regulären Versionen. Bitte beachten Sie, dass Nightly-Builds möglicherweise Fehler enthalten und nicht für den täglichen Gebrauch empfohlen werden.

Sie können die Nightly-Version über den folgenden Link herunterladen:

<a target="_blank" href="https://github.com/ReadYouApp/ReadYou/actions/workflows/build_commit.yaml">Nightly-Builds überprüfen</a>

Wählen Sie den neuesten Workflow auf der GitHub Actions-Seite aus und laden Sie die Artefakte von der Zusammenfassungsseite des Workflows herunter (Es ist möglicherweise erforderlich, sich bei GitHub anzumelden).

**Denken Sie daran, Ihre Daten vor dem Ausprobieren der Nightly-Version zur Sicherheit zu sichern, falls Probleme auftreten.**

## Spenden

**Read You** ist eine kostenlose Open-Source-Software, die von der Open-Source-Gemeinschaft profitiert, und jeder Benutzer kann ihre volle Funktionalität kostenlos genießen. Wenn Sie also meine aktuelle Arbeit wertschätzen, können Sie mir gerne eine Tasse Kaffee spendieren ☕️.

[<img src="https://s1.ax1x.com/2023/01/12/pSnHqpQ.png" alt="donate" height="80">](https://afdian.net/a/ashinch)

Danke für all die Liebe und Unterstützung ❤️

## Übersetzen

Vielen Dank an alle **Read You** Übersetzer, und wenn Sie einen Beitrag leisten möchten, reichen Sie bitte eine Übersetzung über [Weblate](https://hosted.weblate.org/engage/readyou/) ein.

[<img src="https://hosted.weblate.org/widgets/readyou/-/horizontal-auto.svg" alt="Übersetzungsstatus" />](https://hosted.weblate.org/engage/readyou/)

## Build

> Gerne können Sie einen [Pull Request](https://github.com/ReadYouApp/ReadYou/pulls) öffnen. [GitHub Actions](https://github.com/ReadYouApp/ReadYou/actions) verpackt automatisch alle Varianten an APK Dateien für jeden Commit.

**Read You** ist auf der Android nativen [Jetpack Compose](https://developer.android.com/jetpack/compose) Architektur implementiert.

1. Zuerst müssen Sie sich den Quellcode von **Read You** herunterladen.

    ```shell
    git clone https://github.com/ReadYouApp/ReadYou.git
    ```

2. Öffnen Sie es dann mit [Android Studio (neueste Version)] (https://developer.android.com/studio).

3. Wenn Sie auf die Schaltfläche `▶ Run` klicken, wird die App automatisch erstellt und ausgeführt.

    > Falls es zu Schwierigkeiten kommt, wähle bitte die Release version.

## Credits

### Open Source Projekte

- [MusicYou](https://github.com/Kyant0/MusicYou)
- [ParseRSS](https://github.com/muhrifqii/ParseRSS)
- [Readability4J](https://github.com/dankito/Readability4J)
- [opml-parser](https://github.com/mdewilde/opml-parser)
- [compose-html](https://github.com/ireward/compose-html)
- [Rome](https://github.com/rometools/rome)
- [Feeder](https://gitlab.com/spacecowboy/Feeder)
- [Seal](https://github.com/JunkFood02/Seal)
- [news-flash](https://gitlab.com/news-flash)
- [besticon](https://github.com/mat/besticon)
- [Jiffy Reader](https://github.com/ansh/jiffyreader.com)
- ...

### Special Thanks

[<img src="https://avatars.githubusercontent.com/u/76829190?v=4" width="180" height="180" style="display: block; border: 1px solid #f5f5f5; border-radius: 9999px;"/>](https://github.com/Kyant0)

Vielen Dank an **@Kyant0** für die Design-Inspiration und die Implementierung der Monet-Engine für **Read You**.

[<img src="https://resources.jetbrains.com/storage/products/company/brand/logos/jb_beam.png" width="200" alt="Copyright © 2000-2023 JetBrains s.r.o. JetBrains and the JetBrains logo are registered trademarks of JetBrains s.r.o."/>](https://www.jetbrains.com/)

Vielen Dank an **JetBrains** für die Bereitstellung von kostenlosen Open-Source-Lizenzen für IDEs für **Read You**.

[<img src="https://hosted.weblate.org/widgets/readyou/-/287x66-white.png"  width="200"/>](https://hosted.weblate.org/engage/readyou/)

Vielen Dank an **Weblate** für das kostenlose Hosting von Open-Source-Projekten für **Read You**.

## Lizenz

GNU GPL v3.0 © [Read You](https://github.com/ReadYouApp/ReadYou/blob/main/LICENSE)
