import 'package:drift_dev/api/migrations_native.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:talker_flutter/talker_flutter.dart';
import 'package:tsdm_client/instance.dart';
import 'package:tsdm_client/shared/providers/storage_provider/models/database/database.dart';

import '../data/generated_migrations/schema.dart';

void main() {
  setUpAll(() async {
    talker = TalkerFlutter.init();
  });

  test('upgrade from 1 to 2', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(1);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 2);
    await db.close();
  });

  test('upgrade from 2 to 3', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(2);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 3);
    await db.close();
  });

  test('upgrade from 3 to 4', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(3);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 4);
    await db.close();
  });

  test('upgrade from 4 to 5', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(4);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 5);
    await db.close();
  });

  // This test is skipped because it fails to run in github actions but passed
  // on a local machine:
  // ❌ /home/runner/work/tsdm_client/tsdm_client/test/regression/test_002_database_migration_test.dart: upgrade from 5 to 6 (failed)
  //   SqliteException(1): while executing, SQL logic error, SQL logic error (code 1)
  //     Causing statement: ALTER TABLE "broadcast_message" ADD COLUMN "already_read" INTEGER NULL CHECK ("already_read" IN (0, 1));, parameters:
  //   package:sqlite3/src/implementation/exception.dart 75:3                                                     throwException
  //   package:sqlite3/src/implementation/database.dart 244:9                                                     DatabaseImplementation.execute
  //   package:drift/src/sqlite3/database.dart 145:16                                                             Sqlite3Delegate.runWithArgsSync
  //   package:drift/native.dart 378:30                                                                           _NativeDelegate.runCustom.<fn>
  //   dart:async                                                                                                 new Future.sync
  //   package:drift/native.dart 378:19                                                                           _NativeDelegate.runCustom
  //   package:drift/src/runtime/executor/helpers/engines.dart 115:19                                             _BaseExecutor.runCustom.<fn>
  test('upgrade from 5 to 6', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(5);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 6);
    await db.close();
  }, skip: true);

  test('upgrade from 6 to 7', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(6);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 7);
    await db.close();
  });

  test('upgrade from 7 to 8', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(7);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 8);
    await db.close();
  });

  test('upgrade from 8 to 9', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(8);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 9);
    await db.close();
  });

  test('upgrade from 9 to 10', () async {
    final verifier = SchemaVerifier(GeneratedHelper());
    final connection = await verifier.startAt(9);
    final db = AppDatabase(connection);
    await verifier.migrateAndValidate(db, 10);
    await db.close();
  });
}
