// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'bbcode_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class BBCodeEditorLocalizationsZh extends BBCodeEditorLocalizations {
  BBCodeEditorLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get ok => '确定';

  @override
  String get cancel => '取消';

  @override
  String get edit => '编辑';

  @override
  String get copyBBCode => '复制BBCode';

  @override
  String get copyQuilDelta => '复制Quill delta';

  @override
  String get delete => '删除';

  @override
  String get imageDialogLink => '链接';

  @override
  String get imageDialogWidth => '宽度';

  @override
  String get imageDialogHeight => '高度';

  @override
  String get imageDialogEmptySize => '大小为空';

  @override
  String get imageDialogInvalidSize => '无效的数字';

  @override
  String get imageBuilderDialogTitle => '操作图片';

  @override
  String get imageBuilderDialogEdit => '编辑';

  @override
  String get imageBuilderDialogDelete => '删除';

  @override
  String get imageBuilderDialogCopyLink => '复制图片链接';

  @override
  String get emojiInsertEmoji => '插入表情';

  @override
  String get userMention => '提醒用户';

  @override
  String get userMentionDialogUsername => '用户名';

  @override
  String get userMentionDialogEmptyUsername => '用户名不能为空';

  @override
  String get portationTitle => '导入和导出';

  @override
  String get portationExportBBCode => '导出为BBCode';

  @override
  String get portationImportBBCode => '导入BBCode';

  @override
  String get portationImportBBCodeFailed => '导入失败，可能是无效的BBCode';

  @override
  String get portationExportQuillDelta => '导出为Quill Delta';

  @override
  String get portationImportQuillDelta => '导入Quill Delta';

  @override
  String get portationImportQuillDeltaFailed => '导入失败，可能是无效的Quill delta';

  @override
  String get portationCopyBBCode => '复制BBCode到剪切板';

  @override
  String get portationCopyQuillDelta => '复制Quill Delta到剪切板';

  @override
  String get portationCopiedToClipboard => '已复制到剪切板';

  @override
  String get portationSelectDirectory => '选择一个位置保存：';

  @override
  String get spoiler => '折叠区域';

  @override
  String get spoilerDefaultTitle => '点此展开';

  @override
  String get spoilerCollapse => '收起';

  @override
  String get spoilerExpand => '展开';

  @override
  String get spoilerExpandOrCollapse => '展开/收起';

  @override
  String get spoilerEditPageTitle => '编辑折叠区域';

  @override
  String get spoilerEditPageOuter => '外部文字';

  @override
  String get spoilerEditPageOuterHelper => '显示在外部按钮上的文字';

  @override
  String get spoilerEditPageInner => '内部内容';

  @override
  String get spoilerEditPageInnerHelper => '可被折叠收起的内容';

  @override
  String get spoilerEditPageSave => '保存';

  @override
  String get spoilerV2 => '折叠区域';

  @override
  String get spoilerV2HeaderTip => '后续内容可被折叠';

  @override
  String get spoilerV2HeaderTitleTip => '标题：';

  @override
  String get spoilerV2TailTip => '先前内容可被折叠';

  @override
  String get spoilerV2EditTitle => '编辑折叠区域标题';

  @override
  String get spoilerV2EditTitleInvalidTitle => '标题不能包含 \'[\' 或者 \']\'';

  @override
  String get spoilerV2EditTitleNotEmpty => '标题不能为空';

  @override
  String get hide => '隐藏区域';

  @override
  String get hideWithReply => '隐藏以回复';

  @override
  String get hideWithReplyDetail => '用户需要回复才能看到内容';

  @override
  String get hideWithReplyOuter => '回复后可见';

  @override
  String get hideWithPoints => '隐藏以积分';

  @override
  String get hideWithPointsDetail => '用户需要至少持有这么多积分才能看到内容';

  @override
  String get hideWithPointsOuterHead => '持有 ';

  @override
  String get hideWithPointsOuterTail => ' 积分后可见';

  @override
  String get hidePoints => '积分';

  @override
  String get hidePointsInvalid => '无效的积分数值';

  @override
  String get hideV2 => '隐藏区域';

  @override
  String get hideV2HeaderTip => '后续内容会被隐藏';

  @override
  String get hideV2HeaderPointsRequired => '需要积分：';

  @override
  String get hideV2HeaderReplyRequired => '回复后内容可见';

  @override
  String get hideV2TailTip => '先前内容会被隐藏';

  @override
  String get hideV2EditPoints => '编辑可见要求的积分';

  @override
  String get hideV2EditPointsTip => '积分应大于0，否则将为“回复后可见”';

  @override
  String get hideV2EditPointsInvalid => '无效的积分';

  @override
  String get hideV2EditPointsNotEmpty => '积分不能为空';

  @override
  String get divider => '分割线';

  @override
  String get free => '免费区域';

  @override
  String get freeHeaderTip => '后续内容在购买前可见';

  @override
  String get freeTailTip => '先前内容在购买前可见';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class BBCodeEditorLocalizationsZhHant extends BBCodeEditorLocalizationsZh {
  BBCodeEditorLocalizationsZhHant() : super('zh_Hant');

  @override
  String get ok => '確定';

  @override
  String get cancel => '取消';

  @override
  String get edit => '編輯';

  @override
  String get copyBBCode => '複製BBCode';

  @override
  String get copyQuilDelta => '複製Quill delta';

  @override
  String get delete => '刪除';

  @override
  String get imageDialogLink => '連結';

  @override
  String get imageDialogWidth => '寬度';

  @override
  String get imageDialogHeight => '高度';

  @override
  String get imageDialogEmptySize => '大小為空';

  @override
  String get imageDialogInvalidSize => '無效的數字';

  @override
  String get imageBuilderDialogTitle => '操作圖片';

  @override
  String get imageBuilderDialogEdit => '編輯';

  @override
  String get imageBuilderDialogDelete => '刪除';

  @override
  String get imageBuilderDialogCopyLink => '複製圖片連結';

  @override
  String get emojiInsertEmoji => '插入表情';

  @override
  String get userMention => '提醒使用者';

  @override
  String get userMentionDialogUsername => '使用者名稱';

  @override
  String get userMentionDialogEmptyUsername => '使用者名稱不能為空';

  @override
  String get portationTitle => '導入與導出';

  @override
  String get portationExportBBCode => '導出為BBCode';

  @override
  String get portationImportBBCode => '導入BBCode';

  @override
  String get portationImportBBCodeFailed => '導入失敗，可能是無效的BBCode';

  @override
  String get portationExportQuillDelta => '導出為Quill Delta';

  @override
  String get portationImportQuillDelta => '導入Quill Delta';

  @override
  String get portationImportQuillDeltaFailed => '導入失敗，可能是無效的Quill delta';

  @override
  String get portationCopyBBCode => '複製 BBCode 到剪貼簿';

  @override
  String get portationCopyQuillDelta => '複製 Quill Delta 到剪貼簿';

  @override
  String get portationCopiedToClipboard => '已複製到剪貼簿';

  @override
  String get portationSelectDirectory => '選擇一個位置儲存：';

  @override
  String get spoiler => '折疊區域';

  @override
  String get spoilerDefaultTitle => '點此展開';

  @override
  String get spoilerCollapse => '收起';

  @override
  String get spoilerExpand => '展開';

  @override
  String get spoilerExpandOrCollapse => '展開/收起';

  @override
  String get spoilerEditPageTitle => '編輯折疊區域';

  @override
  String get spoilerEditPageOuter => '外部文字';

  @override
  String get spoilerEditPageOuterHelper => '顯示在外部按鈕上的文字';

  @override
  String get spoilerEditPageInner => '內部內容';

  @override
  String get spoilerEditPageInnerHelper => '可被折疊收起的內容';

  @override
  String get spoilerEditPageSave => '儲存';

  @override
  String get spoilerV2 => '折疊區域';

  @override
  String get spoilerV2HeaderTip => '後續內容可被折疊';

  @override
  String get spoilerV2HeaderTitleTip => '標題：';

  @override
  String get spoilerV2TailTip => '先前內容可折疊';

  @override
  String get spoilerV2EditTitle => '編輯折疊區域標題';

  @override
  String get spoilerV2EditTitleInvalidTitle => '標題不能包含 \'[\' 或 \']\'';

  @override
  String get spoilerV2EditTitleNotEmpty => '標題不能為空';

  @override
  String get hide => '隱藏區域';

  @override
  String get hideWithReply => '隱藏以回覆';

  @override
  String get hideWithReplyDetail => '用戶需要回复才能看到內容';

  @override
  String get hideWithReplyOuter => '回覆後可見';

  @override
  String get hideWithPoints => '隱藏以積分';

  @override
  String get hideWithPointsDetail => '使用者需要至少持有這麼多積分才能看到內容';

  @override
  String get hideWithPointsOuterHead => '持有 ';

  @override
  String get hideWithPointsOuterTail => ' 積分後可見';

  @override
  String get hidePoints => '積分';

  @override
  String get hidePointsInvalid => '無效的積分數值';

  @override
  String get hideV2 => '隱藏區域';

  @override
  String get hideV2HeaderTip => '後續內容會被隱藏';

  @override
  String get hideV2HeaderPointsRequired => '需要積分：';

  @override
  String get hideV2HeaderReplyRequired => '回復後內容可見';

  @override
  String get hideV2TailTip => '先前內容會被隱藏';

  @override
  String get hideV2EditPoints => '編輯可見要求的積分';

  @override
  String get hideV2EditPointsTip => '積分應大於0，否則將為「回復後可見」';

  @override
  String get hideV2EditPointsInvalid => '無效的積分';

  @override
  String get hideV2EditPointsNotEmpty => '積分不能為空';

  @override
  String get divider => '分割線';

  @override
  String get free => '免費區域';

  @override
  String get freeHeaderTip => '後續內容購買前可見';

  @override
  String get freeTailTip => '先前內容在購買前可見';
}
