import 'dart:convert';

import 'package:dart_bbcode_parser/src/lexer.dart';
import 'package:dart_bbcode_parser/src/token.dart';
import 'package:test/test.dart';

void main() {
  group('raw tokens generated by lexer', () {
    test('Text token', () {
      final lexer = Lexer(input: 'text')..scanAll();
      final tokens = lexer.tokens;
      expect(tokens.length, equals(1));
      expect(tokens.first.length, equals(4));
      expect(tokens.first.position.start, equals(0));
      expect(tokens.first.position.end, equals(4));
      expect(tokens.first.toBBCode(), equals('text'));
      expect(tokens.first.tokenType, equals(TokenType.text));
      expect(tokens.first.toJson(), equals(jsonEncode({'token': 'Text', 'start': 0, 'end': 4, 'data': 'text'})));
      expect(tokens.first.toString(), equals(jsonEncode({'token': 'Text', 'start': 0, 'end': 4, 'data': 'text'})));
      expect(tokens.first.hashCode.runtimeType, equals(int));
    });

    test('TagHead token', () {
      final lexer = Lexer(input: '[b]')..scanAll();
      final tokens = lexer.tokens;
      expect(tokens.length, equals(1));
      expect(tokens.first.length, equals(3));
      expect(tokens.first.position.start, equals(0));
      expect(tokens.first.position.end, equals(3));
      expect(tokens.first.toBBCode(), equals('[b]'));
      expect(tokens.first.tokenType, equals(TokenType.tagHead));
      expect(
        tokens.first.toJson(),
        equals(jsonEncode({'token': 'TagHead', 'start': 0, 'end': 3, 'name': 'b', 'attribute': null})),
      );
      expect(
        tokens.first.toString(),
        equals(jsonEncode({'token': 'TagHead', 'start': 0, 'end': 3, 'name': 'b', 'attribute': null})),
      );
      expect(tokens.first.hashCode.runtimeType, equals(int));
    });

    test('TagTail token', () {
      final lexer = Lexer(input: '[/b]')..scanAll();
      final tokens = lexer.tokens;
      expect(tokens.length, equals(1));
      expect(tokens.first.length, equals(4));
      expect(tokens.first.position.start, equals(0));
      expect(tokens.first.position.end, equals(4));
      expect(tokens.first.toBBCode(), equals('[/b]'));
      expect(tokens.first.tokenType, equals(TokenType.tagTail));
      expect(tokens.first.toJson(), equals(jsonEncode({'token': 'TagTail', 'start': 0, 'end': 4, 'name': 'b'})));
      expect(tokens.first.toString(), equals(jsonEncode({'token': 'TagTail', 'start': 0, 'end': 4, 'name': 'b'})));
      expect(tokens.first.hashCode.runtimeType, equals(int));
    });
  });
}
