# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.13.0] - 2025-11-25

### Added

- 帖子：现在在帖子内默认长按或右键打开当前楼层的菜单，而不是点击楼层时设置为回复当前楼层。
  - 可在设置 -> 行为内修改。
- 安卓：恢复16kb page size支持。
- 用户：支持设置第二牌子。
  - 个人资料页 -> 右上角菜单 -> 我的称号。
- 用户：支持设置个人资料。
  - 个人资料页 -> 右上角菜单 -> 编辑资料。
  - 编辑资料时自动移除多余的网址domain前缀，请放心修改。
- 安卓：现在使用kotlin native http client代替cronet_http。
  - 修复一些代理自动设置错误的问题。
  - 修复了在高版本安卓上app切换到后台时网络请求中断的问题。
  - 加快了网络请求速度。
  - 减小apk大小约3MB。

### Fixed

- 帖子：修复红包没有人领取时红包详情页面打开灰屏的问题。
- 编辑：修复在图片后方编辑文字时无法正常显示图片的问题。
- 编辑：修复解析bbcode时没有正确处理未闭合的tag导致内容错误的问题。
- app：修复因消息数量过多导致OOM而闪退的问题。
  - 现在读取本地存储的历史消息时，每类消息各最多最新的500条。
- app：修复一些没有dispose导致内存泄漏的问题。

### Changed

- app：更新UI布局。
  - 逐渐引入M3 Expressive组件。
- 调试：现在会按天将运行日志保存到文件。
  - 可在设置 -> 存储 -> 清除缓存中清除历史日志。
- build：修复在CI中构建安卓产物时`No space left on device`的问题。
- deps：现在最低要求Flutter 3.38.3。
- deps: Kotlin 2.2.21; Gradle 9.2.1; AGP 8.13.1; NDK r29;

## [1.12.0] - 2025-10-01

### Added

- 安卓：现在在安卓上使用原生的退出软件方式，侧滑退出时只会将应用移动到后台，而不是彻底关闭。
  - 删除了侧滑两次退出确认的功能。
- 帖子：更新了选择阅读权限的对话框的样式。
- 分区：现在支持在帖子卡片上长按或右键查看打开菜单，菜单中包含一些不需要进入帖子页面也可用的功能。
- app：支持15周年坛庆特殊积分。

### Fixed

- 通知：修复了某些情况下在私信和公共消息页面中打开未读会产生灰屏的问题。

### Changed

- deps：现在最低要求Flutter 3.35。

## [1.11.0] - 2025-07-27

### Added

- app：支持保存图片。
- app：重做在应用中打开页面的功能。
  - 可以根据网页链接、用户名、用户uid、分区fid、帖子tid、楼层pid打开对应的页面。
  - 相对应的可以在分区和帖子的右上角菜单以及楼层右下角菜单中复制对应id。
  - 在分区和帖子的右上角菜单内增加“在应用中打开页面”的入口。
- app：现在在应用启动时会清除一部分已知但之前版本不支持清理的缓存文件。
- app：在分区和帖子的右上角菜单中提供更多选项。

### Fixed

- 编辑：修复提交编辑帖子的结果时在没有出错的情况下提示错误的问题。
- 编辑：修复某些情况下退出软件时黑屏的问题。
- 通知：修复从通知页中通知包含的链接图标打开相关页面时，通知没有被标记为已读的问题。
- 通知：修复某些情况下获取消息时时间范围出错导致遗漏消息的问题。
- 私信：修复从私信页面聊天记录页面打开当前登录用户的资料页时报错的问题。
- 设置：修复设置页面可能存在的布局溢出问题。

### Changed

- 编辑：现在在Android和iOS上，如果在提交编辑帖子的结果时失败，会收起键盘。
- 通知：现在默认开启“提醒”和“公共消息”类型消息的未读红点。
- app：更新部分UI样式。
- app：在安卓平台上启用impeller。

## [1.10.0] - 2025-07-12

### Added

- 帖子：支持查看楼层的全部评分历史。
- 帖子：支持查看当前已购买帖子的人数信息。
- 通知：现在在通知页面内，即使当前选项卡对应的消息类型为空（显示“没有数据”），也允许下拉刷新页面。
- app：现在在Android、iOS和macOS上使用native http client以加快访问速度。
  - 提升了直连速度。
  - 现在在上述三个平台上，每个网络请求都会使用当前代理设置，不再需要手动设置或者重启app重新检测。
  - Windows和Linux平台依然维持老版本的情况，在未来版本会迁移。
  - 由于本次改动，在Android平台上不再支持16kb page size，对Android15及以上版本略有影响。
  - 由于本次改动，支持的iOS最低版本提升至13.0。
- app：现在应用图标在Android平台上支持adaptive icon和monochrome icon特性。
- 设置：在设置帖子卡片外观的页面内增加帖子图标含义的解释说明。

### Fixed

- 编辑：修复在折叠区域`spoiler`上增加样式导致导出的折叠区域展开后不可见的问题。
- 编辑：修复解析某些末尾没有空行的bbcode内容时，编辑器不可用的问题。
- app：修复访问某些链接时由于增加了额外url参数导致访问出错的问题。
- app：修复安卓上底部弹窗会被底部导航栏和顶部状态栏遮挡的问题。
- app：修复大部分图标按钮缺少tooltip的问题。
- app：修复打开底部弹窗时如果app窗口大小发生变化，弹窗会出现在窗口中间的问题。

### Changed

- 编辑：现在折叠区域`spoiler`、隐藏区域`hide`和免费区域`free`的头尾两部分在编辑器中不再占据一整行。
- app：更新多处UI样式。

## [1.9.0] - 2025-06-28

### Added

- 编辑：BBCode Parser支持解析列表，包括有序列表`list=1`和无序列表`list`。
  - 受限于编辑器的渲染流程，目前对于列表有如下限制：
  - 不能在列表中使用折叠`spoiler`、隐藏`hide`、免费`free`和代码块`code`。
  - 列表每一项`*`中不支持多行文本，如果出现多行文本，会合并到同一行。
  - 如果一个格式（例如文字颜色`color`）横跨了多个列表项`*`，其格式不保证一定正确。
- 编辑：BBCode Parser现已进入稳定状态。
  - [Parser](https://github.com/realth000/dart_bbcode_parser)已达到100%覆盖率，修复了绝大多数解析结果有误和解析时报错的问题。
  - 说明：现在BBCode Parser用在以下场景：编辑已发布的帖子、编辑回复模板、导入回复模板、在帖子和聊天页面中展开底部回复框。将纯文本BBCode解析为所见即所得的内容。
  - 原先开关BBCode Parser的选项现在同时于上述场景中生效，如果遇到问题可以关闭BBCode Parser，恢复为纯文本编辑。

### Fixed

- 编辑：修复解析BBCode时内容中的图片`img`会导致编辑器卡顿的问题。
- 模板：修复编辑回复模板时，如果用新模板覆盖同名旧模板且当前只有一个模板，编辑完成后模板页面中显示的模板内容依然为覆盖前的旧内容的问题。
- 通知：修复通知页面中偶现“标注为已读”不生效的问题。
- 私信：修复发送私信消息失败时，失败提示会被键盘挡住的问题。
  - 现在发送消息失败时也会收起键盘。

### Changed

- app：更新所有对话框的样式。
- 编辑：现在编辑器中列表`list`每一项最左边的heading会保持普通的颜色，不再被文本颜色`color`影响。

## [1.8.1] - 2025-06-15

### Fixed

- 编辑：修复在帖子和回复模板中使用`free`会导致灰屏的问题。
- html：修复部分`code`中行与行之间多一个空行的问题。
- app：修复应用启动时黑屏的问题。

## [1.8.0] - 2025-06-14

### Added

- 评分：新增评分模板功能，可以预设评分的数值，在评分时使用模板内记录的分数数值填充。
  - 在设置 -> 行为 -> 评分模板中配置。
- 帖子：新增回复模板功能，可以预设回复模板，在发帖和回复时填充模板内记录的内容。
  - 在设置 -> 行为 -> 回复模板中配置。
- 帖子：现在收起再展开底部的回复框以后，编辑器内的文本也会维持所见即所得的样式。
  - 维持支持的样式与编辑帖子时支持的样式相同。
- 帖子：现在一直显示帖子页面顶部的导航栏，无论在页面中滚动到哪个位置。
- 帖子：现在在帖子顶部的标题栏中点击帖子ID，可以复制帖子相关的信息。
  - 可复制帖子标题、ID、链接（包括不带域名/带有域名、普通文本格式和BBCode格式共四种）。
  - 删除了原本向下滚动时出现的只有一行的标题栏。
- 帖子：现在复制楼层内的文本时，可以快速复制或分享全部文本。
- 帖子：现在可以在帖子和分区页面的右上角菜单中跳转到设置页。
- app：支持自动清理图片缓存。
  - 现在可在应用启动时自动清理长时间未使用的图片缓存。
  - 可在设置中配置图片视为“长时间未使用”的时长，默认清理7天未使用的图片缓存。
  - 在设置 -> 缓存中配置。
- app：支持自动检测代理。
  - 应用启动时可以检测一次代理设置，并作为本次运行过程中使用的代理配置。
  - 默认关闭，可在设置 -> 高级 -> 自动检测代理中开启。
- app：在底部弹窗上增加关闭弹窗的按钮。

### Fixed

- 编辑：修复将某些数值的颜色转换成BBCode时，颜色格式不规范导致再次解析时得到的颜色有误的问题。
- 编辑：修复内置的颜色数值错误的问题。
  - 例如原先内置的海军色`Navy`数值为`0xFF000066`，现已更正为`0xFF000080`。
- 编辑：修复解析颜色时，一些不规范的颜色数值解析结果不正确的问题。
- 编辑：修复解析代码`code`时每一行两侧的空格会被去除掉的问题。
- app：修复安卓上关闭“按两次退出”的情况下退出应用会黑屏的问题。

### Changed

- 编辑：现在将内容转换为BBCode时，论坛支持的有名字的颜色会保持使用颜色名字，而不是使用对应的数值。
  - 例如暗红色，以前转换成BBCode是`color=8B0000`，现在是`color=DarkRed`
  - 现在在解析颜色时会尽量将颜色解析为带名字的颜色，而不是总是使用其数值。
- app：优化了图片详情页面中，图片的详细数据对话框的样式。

## [1.7.0] - 2025-05-31

### Added

- 编辑：支持输入免费区域`[free]`标签。
  - 免费区域`[free]`其中的内容即使在未购买帖子时也依然可见。
  - 只能用于帖子一楼（可以设置售价的楼层）。
- 编辑：调整折叠区域`[spoiler]`和隐藏区域`[hide]`的编辑方式。
  - 使用一头一尾两部分作为区域的边界，代替原先跳转到新页面再编辑区域内容的方式。
  - 现在包含区域的样式能够正确影响区域内部的问题。例如在`[b][hide]xxx[/hide][b]`中，`[hide]`包含的文字也为粗体。
- 编辑：恢复在安卓平台使用可视化的折叠区域`[spoiler]`和隐藏区域`[hide]`。
  - 视觉样式和操作方式与其他平台无异。
- app：更新了底部弹窗样式，现在绝大部分底部弹窗的高度会根据内部包含的内容的高度自动调整。

### Fixed

- 编辑：修复移动端编辑器工具栏底部按钮显示不完整的问题。
- 编辑：修复解析bbcode时，图片`[img]`上的其他样式会丢失的问题。
- 编辑：修复选择背景颜色时，弹窗标题为“字体颜色”而不是“背景颜色”的问题。
- html：修复解析网页中存在的链接时由于链接包含错误的字符导致异常的问题。
- html：修复某些情况下，有序列表`[list=1]`和无序列表`[list]`中的所有项`[*]`挤在同一行的问题。
- html：修复上标文字`[sup]`会丢弃其他文字样式（如粗体`[b]`、斜体`[i]`）的问题。
- 设置：修复更新日志页面显示底部导航栏的问题。

### Changed

- app：更新多处页面和底部弹窗布局。
- app：减少了在加载图片的流程出现预期内的错误时打印日志的问题。
- deps: 现在依赖`Flutter >= 3.32`。

## [1.6.0] - 2025-05-06

### Added

- 帖子：支持显示用户资料中与威望对应的等级牌子的信息。
- 帖子：支持复制帖子楼层内的文字内容。
  - 从楼层右下角菜单中选择复制文字，可选择文字复制。
  - 目前为临时方案，待后续改进。
- 安卓：适配底部透明导航条。
- 用户：现在支持在资料页右上角菜单中编辑自己的头像。
  - 编辑时可以预览填入的头像外链对应的头像图片。
- 编辑：现在在编辑帖子时输入颜色使用更丰富的颜色拾取器。
  - 拾取器支持简单、高级、自定义三种输入方式。
  - 简单模式与先前版本的拾取器效果相同，使用与网页端相同的内置颜色。
  - 高级模式可以选择符合Material规范的主要颜色。
  - 自定义模式支持通过输入Web Color的颜色名称或者颜色的hex值指定颜色。
  - 自定义模式会记忆最近输入的颜色。
- 编辑：支持在插入网页链接时从剪切版识别并粘贴来自bilibili的分享链接。
  - 链接格式为：【视频标题】视频链接。
- app：现在会显示由于用户操作而导致的积分变动，例如回复和购买。
- app：重做查看图片页面。
  - 现在图片自动缩放至全屏。
  - 可以查看图片的详细数据，包括原始url、缓存名称、图片尺寸和缓存文件大小。
- app：支持检查软件版本。
  - 现在默认在应用启动时检查软件的最新版本信息。
  - 默认检查可在设置中关闭。
- 安卓：适配了高版本安卓上的透明底部导航栏。

### Fixed

- 帖子：修复安卓平台无法在用户资料中的宠物部分上下滑动整个页面的问题。
- 帖子：修复从通知跳转到帖子页再从顶部导航栏跳转到分区页时帖子筛选项为空的问题。
- 搜索：修复在仅搜索用户名或者fid时无法在收起搜索框的情况下翻页的问题。
- app：修复一些底部弹窗会重复出现的问题。
- 编辑：修复在编辑图片时，设置仅自动填充单条边的长度会导致转换出的BBCode缺少图片尺寸的问题。
- 编辑：修复解析bbcode时在连续的左中括号处解析结果有误的问题。

## [1.5.0] - 2025-04-05

### Added

- 帖子：现在帖子的每一层右下角菜单里会写上当前楼层。
  - 方便操作比较长的楼层时知道在操作几楼。
- 帖子：现在可以在帖子里看楼层用户的勋章、牌子、宠物、签到信息和签名档。
  - 点击楼层用户的头像后对话框里可见。
  - 用户没有的项会隐藏，不显示，比如勋章、宠物、签到信息和签名档。
- 设置：获取更新时可以导航至论坛上的app下载公告帖。
- 编辑：发帖时允许在没有帖子分类的分区内发帖。
  - 现在每一层楼都有一个标题（subject），无论是不是一楼。除一楼外的楼层填写标题会在楼层正文前加一些`<h2>`样式的文字。
  - 相应的，进入编辑页面后焦点会定位在正文里，而不是标题，因为标题绝大部分情况下没有用了。
- 用户：重做用户资料页，现在和pc网页显示的内容一样多了。
  - 新增显示以下内容：是否在线、用户组的名字、勋章、累计签到天数、在线时间、注册时间、最近的活动情况、注册IP和上次访问IP（默认用星号代替）。
  - 重新用用户头像填充头像后面的背景。

### Fixed

- 编辑：修复安卓平台导入导出Quill Delta和BBCode时失败的问题。
- 编辑：修复转换为BBCode后图片丢失尺寸的问题。
- 帖子：修复评分记录卡片在平分数值大时可能换行的问题。

### Changed

- app：更新了更多底部弹窗的布局，现在更多的弹窗有圆角了（包括编辑器）。
- app：移除了冗余的底部通知，现在界面里显示“加载失败”的场景里不会弹底部通知了。
- 设置：现在用全屏查看更新历史，而不是原来的对话框。
- 安卓：target SDK更新到36（安卓16），并且支持16kb page size。
  - 在安卓15及以上版本支持以16KB内存页的模式运行，而不需要兼容模式。

## [1.4.1] - 2025-03-23

### Fixed

- app：回到之前版本的http client以修复handshake failed的问题。

## [1.4.0] - 2025-03-22

### Added

- 编辑：添加了实验性的BBCode parser，在编辑帖子内容时编辑器会将BBCode转换并渲染为所见即所得的内容。
  - 目前支持如下tag：`[b]`、`[i]`、`[u]`、`[s]`、`[url]`、`[size]`、`[color]`、`[backcolor]`、`[sup]`、`[img]`、`[hr]`、`[align]`、`[code]`、`[quote]`。
  - 此功能以提供可视化编辑功能为主，仅对常见的错误和易混淆的意外情况进行特殊处理。
  - 可以在设置里开关上述BBCode parser，关闭后编辑帖子时会像先前版本一样编辑源码文本。
  - 此功能为实验性质，可能含有较多问题，如果在编辑时发现内容不符合实际，请先退出编辑，在设置中关闭上述开关后以纯文本模式编辑。
- 编辑：现在在打开设置链接的对话框时，如果此时编辑器中选中的文字是可识别的链接，选中文字会出现在对话框的链接一栏里，而不是描述。
- 帖子：支持解析帖子中实际设置的售价上限，以代替原先固定的数值`65535`。
- html解析：支持显示`[sup]`。
- app：现在使用另一种http客户端实现，加快访问速度。

### Fixed

- 帖子：修复回复框内容清空后，收起编辑框后文字内容又出现的问题。
- 帖子：修复某些情况下页面顶部信息中缺少帖子id的问题。
- 编辑：修复转换出的BBCode末尾总会多出一个空行的问题。
- 编辑：修复无法在安卓平台导入导出BBCode和Quill Delta的问题。
- html解析：修复在已经包含了`@`的文本前又加了一个链接图标的问题。
- html解析：修复解析某些不包含行号的`[code]`时内容为空的问题。
- 登录：修复登录失败时一直停留在加载状态且无任何提示的问题。

### Changed

- 帖子：允许在发送回复时收起回复框。
- 编辑：增加了在移动平台上编辑器左右两边的边距。
- app：更新多处页面布局。

## [1.3.0] - 2025-03-08

### Added

- 帖子：支持在不显示已购买人数的帖子里进行购买。
- 帖子：现在在发送回复时，如果编辑器处于收起状态，会在编辑器尾部显示提示。
- 帖子：现在如果帖子已被关闭但当前用户依然有回复权限，会在回复框上方提示当前帖子已关闭。
- 搜索：支持在指定作者uid或者分区fid的情况下不输入关键字来进行搜索。
- Android：沉浸状态栏。
- 通知：恢复了在`v1.0.1`中移除的定时拉取通知功能。
- 通知：调整了设置拉取通知间隔时长的方式，现在使用slider来选择。
- 通知：现在自动拉取通知的间隔时长可以在以下数值中选择：
  - `1分钟`、`2分钟`、`3分钟`、`5分钟`、`10分钟`、`20分钟`、`40分钟`、`1小时`、`从不`。
- 通知：现在在开启自动拉取通知时，通知页面顶部会显示距离下一次自动拉取通知还有多久时间的进度条。
- 多用户：更新切换和管理账户的页面。
  - 现在可以清除某一未登录账户的登录信息，只删除在本地存储的cookie，不向服务器发送退出登录的请求。
  - 现在可以更方便地重新登录某一账户，在重新登录时自动填充用户名。
- html解析：现在会识别html页面内容里的邮件scheme`mailto:`。
- html解析：现在会在邮件`mailto:`链接前显示特殊的邮件图标，而不是通用的url链接图标。
- 私信：现在在成功发送一条私聊消息以后会收起键盘。

### Fixed

- Android：修复与横屏相关的一些布局问题。
- 通知：修复了与自动拉取通知有关的很多问题。
- 通知：修复了将某一类通知标记为已读可能导致下次拉取通知时丢失消息的问题。
- 通知：修复了在通知页面之外拉取到信息时没有更新最近拉取时间，导致拉取到重复通知的问题。
- 帖子：修复了成功回复帖子时在编辑器已经收起的情况下，清除编辑器内容时会弹起一次键盘的问题。
- html解析：修复了在无序列表的每一项之间多余一个空行的问题。
- html解析：修复了渲染没有`<br>`结尾的代码块时所有内容挤到同一行里的问题。

### Changed

- 通知：现在在手动拉取通知时，会将自动拉取通知的时间间隔进度归零。
- 帖子：调整帖子操作历史卡片的布局，在单行内容超过最大宽度时换行而不是显示省略号。
- 多用户：优化切换用户失败时的报错显示。
- app：调整多处UI布局。

## [1.2.0] - 2025-02-23

### Added

- 私信：在私信聊天页面显示对方的离线/在线状态。
  - 仅有发起聊天的页面可以显示，聊天历史记录页面由于网页端不存在该信息故无法显示。
- 帖子：可以直接在楼层菜单执行“在浏览器中打开”。
- 帖子：在帖子顶部显示当前所在位置，包括帖子所在大区和分区。
- 帖子：通过帖子顶部显示的大区、分区和帖子分类信息可以像网页端一样导航到相应页面。
- 帖子：点击帖子顶部的操作记录卡片可以像网页端一样显示近期所有的操作记录（不止最后一条）。
- 帖子：会显示楼层里的投票部分。
  - 考虑到投票的使用频率、开发难度以及使用风险，只提供“在浏览器中打开”的功能。
- 帖子：会显示楼层里用积分隐藏并且用户满足积分要求的区域。
  - 相比原来多了个提示：以下区域高于xxx积分才会显示。
- 搜索：搜索结果的帖子卡片上会显示帖子所在分区。
- 打开链接：识别大区`gid`的网页链接并打开相应页面。
- 打开链接：识别分区`fid`链接中的筛选类型参数`typeid`并打开相应的页面。
- 大区：可以通过打开链接或者帖子顶部的导航栏跳转到相应的大区页面。

### Fixed

- 用户：修复用户资料页中通知按钮不会显示未读消息数的问题。
- html：修复将有序列表显示为无序列表的问题。
- 私信：修复发送信息失败时发送按钮一直加载中的问题。
- 编辑：升级底层编辑器，修复了一些问题。
- 帖子：修复一些帖子里顶部信息中缺少帖子id和所属分区的问题。
- 帖子：修复楼层里用户昵称很长时布局溢出的问题。

### Changed

- app：修复一些弹窗样式。
- 编辑：更新了编辑器文本框样式。
- 编辑：针对Android和iOS，将编辑器工具栏底部垫高，更符合涉及规范。
- deps：升级到`flutter >= 3.29`，`Dart >= 3.7`。

## [1.1.1] - 2025-01-15

### Added

- app：支持2025年春节活动特殊积分。

### Fixed

- 编辑：修复Linux上无法复制粘贴的问题。

## [1.1.0] - 2025-01-15

### Added

- 帖子：新增红包领取情况统计页面。
  - 点击红包卡片右上角图标进入，可以按照时间和领取的红包大小排序。
  - 可以在未领取红包的情况下查看红包的领取统计。
- 帖子：展示最后一次帖子操作。
  - 此功能未来可能会随着底层迁移而移除。
- 帖子：解析楼层屏蔽状态，如果被屏蔽了，显示提示而不是空内容。
- app：支持更换字体。
  - 需要手动输入字体名称，不在安卓上屏蔽该功能。
- app：支持导出和导入数据。
  - 导出时会保存除缓存信息外的所有数据，包括但不限于cookie、偏好设置、消息记录、帖子访问记录等，**注意数据安全**。
  - 导入时会**覆盖**当前已有的上述**全部数据**，请在必要时使用其他手段备份。
  - 导入时不会对数据库格式做校验，**不要导入不可信的数据源**。

### Fixed

- 编辑：修复编辑器中文本颜色和背景颜色在移动平台不生效的问题。
- 帖子：修复一些主题和分区中解析不到帖子标题的问题。
- 帖子：修复在一些分区中无法回复帖子内其他楼层的问题。
- 帖子：修复从链接打开的帖子中，仅查看该作者楼层参数不生效的问题。
- 帖子：修复从链接打开的帖子中，楼层排序参数不生效的问题。
- 帖子：修复当楼层作者信息解析失败时，应用卡住的问题。
- 帖子：修复仅作者可见的楼层显示两个可见提示卡片的问题。
- 网页：修复部分网页链接打不开的问题。

### Changed

- app：修复编译警告。
- app：支持在应用中查看日志。
- app：支持导出日志。
- app：添加F-Droid badge by @linsui in #159
- app：优化加载头像缓存的流程。
- 调试：增加些许调试功能。

### Removed

- 升级：移除检测升级的功能，只保留条抓电脑相应下载源链接的功能。

## [1.0.2] - 2024-12-29

### Fixed

- app: 在安卓平台上禁用impeller以修复各种渲染和白屏问题。

### Changed

- debug: 增加了一点用来调试的功能。
- app: 应用名缩短为“天使动漫” by [@Qing-Novel](https://github.com/Qing-Novel) in [#151](https://github.com/realth000/tsdm_client/pull/151)
- android: F-Droid配置 by [@linsui](https://github.com/linsui) in [#141](https://github.com/realth000/tsdm_client/pull/141)
  - 这个版本稍后应该可以从F-Droid下载了。
  - 非常感谢[@linsui](https://github.com/linsui)帮忙发布到F-Droid。
- internal: 更新以下依赖项版本 by [@Malus-risus](https://github.com/Malus-risus) in [#154](https://github.com/realth000/tsdm_client/pull/154)
  - `kotlin=2.1.0`
  - `gradle=8.12`
  - `AGP=8.7.3`

## [1.0.1] - 2024-12-28

### Fixed

- 编辑：修复保存折叠区域和隐藏区域的内容时，光标不在区域旁边会导致保存失败的问题。
- 编辑：修复安卓上使用折叠区域和隐藏区域会导致卡死的问题。
  - 在安卓上暂时改为插入`hide`和`spoiler`源代码，需要重构相关功能。

### Changed

- app: 去除了一部分不需要的依赖。
- internal: 依赖的flutter最低版本提升至3.27.1。

### Removed

- 通知：暂时移除自动拉取通知的功能，待相关问题修复后再恢复。

## [1.0.0] - 2024-12-13

### Added

- 编辑：重做编辑器。
  - 增加折叠和展开三种状态。
  - 折叠状态下只显示输入框。
  - 展开状态下显示所有支持的bbcode格式，输入框不限制最大外观高度。
  - 在图片上显示设置的图片宽高。
  - 插入图片时自动填写图片宽高。
  - 在提醒用户时，支持搜索用户和随机好友。
  - 编辑帖子时支持设置阅读权限。
  - 支持在编辑帖子时导出和导入编辑内容，支持BBCode和Quill Delta两种格式。
    - BBCode格式导入后暂不支持渲染，会以纯文本形式显示，后续会支持此功能。如要保存帖子，现在更推荐以Quill Delta的格式保存。
- 编辑：现在在编辑帖子页中的阅读权限图标上现实当前设定的阅读权限数值（如果有的话）。
- 编辑：支持设置售价。
- 编辑：现在按照网页端渲染图片大小的规则以相同的方式显示图片。
  - 按照网页端的规则，图片的最大宽度为550。
- 编辑：现在在修改图片大小时，编辑器中显示的图片大小也会随之变化。
- 编辑：现在打开编辑框后，如果编辑框内有内容，会将光标定位到内容的末尾，而不是停在开头。
- 编辑：支持折叠区域`[spoiler]`。
  - 点击后打开菜单，可以编辑或者复制以Quill delta/BBCode的形式复制区域内的内容。
  - 编辑时会在一个新的页面中编辑，完成编辑后点右上角按钮保存并返回。
  - **编辑前建议将光标定位到折叠区域旁边，否则可能会保存失败或修改掉其他内容。**
- 编辑：支持隐藏区域`[hide]`。
  - 支持回复后可见的`[hide]`和要求积分数的`[hide=$POINTS]`。
  - 点击后打开菜单，可以编辑或者复制以Quill delta/BBCode的形式复制区域内的内容。
  - 编辑时会在一个新的页面中编辑，完成编辑后点右上角按钮保存并返回。
  - **编辑前建议将光标定位到隐藏区域旁边，否则可能会保存失败或修改掉其他内容。**
- 编辑：支持分割线`[hr]`。
- 用户：用户页面向下滚动到用户名隐藏时，在顶部显示用户名。
- 用户：支持解析14周年坛庆积分。
- 分区：支持显示在帖子中最后回复的用户。
- 分区：高亮显示近期发布的帖子。
  - 24小时内发布的帖子会加粗发布时间。
  - 默认开启，可在设置 -> 外观 -> 帖子卡片 -> 高亮近期发布的帖子中关闭。
- 分区：高亮帖子作者的用户名。
  - 默认开启，可在设置 -> 外观 -> 帖子卡片 -> 高亮帖子作者的用户名中关闭。
- 分区：支持发帖。
  - 可在发帖时设置标题、分类、阅读权限和附加选项。
  - 支持编辑和保存草稿。
- 设置：支持设置帖子卡片的外观，包括对齐方式、是否显示最后回复的用户、内容高亮和底部信息高亮。
  - 默认不居中并显示最后回复的用户，高亮近期发布的帖子时间、帖子作者和帖子信息，可在外观 -> 帖子卡片中关闭。
- 设置：更新选择颜色页面的样式，显示对应的主题颜色。
- 设置：更新开关样式。
- 网页：解析网页中的字体背景颜色。
- 网页：解析网页时，若处在深色模式下，将难以看清的浅色转换为深色。
- 网页：现在在渲染网页时，不会变更文字换行位置。
  - 看起来可能和网页端不同，但这是为了后续能够复制文本内容。
- 网页：支持解析网易云音乐的外链播放器（仅显示歌曲信息并提供点击跳转功能）。
- 网页：现在会解析帖子等位置中的表格。
- 网页：解析`<ul>`，`<nav>`和`<section>`。
- 网页：解析`<span>`中的背景颜色。
- 认证：支持使用UID和邮箱登录。
- 认证：登录失败时自动刷新验证码。
- 帖子：显示楼层用户的昵称和分组，回复时间调整为精确格式。
- 帖子：支持复制楼层的分享链接。
- 帖子：支持从消息页的回复提醒跳转过来后滚动到相应回复。
- 帖子：支持在解析网页链接时解析其中指定的楼层，并在页面加载后跳转到该楼层。
  - 当网页链接形式为`tid=$THREAD_ID&page=$PAGE#pid$POST_ID`时，忽视“倒序浏览楼层”的设置以保证加载指定的页数。
- 帖子：现在对处于草稿状态的帖子，会在帖子卡片右上角和帖子页面顶部给出提示。
- 帖子：发帖和编辑时可设置阅读权限。
- 帖子：我的帖子页面中显示更多帖子信息。
- 帖子：我的帖子页面中修改帖子卡片布局。
- 帖子：支持解析新人报道分区的帖子中的新人报道表格。
- 帖子：现在已被领完的红包会直接显示领完了。
- 帖子：支持在发帖时设置帖子售价。
- 帖子：现在在退出当前回复的帖子后后收起回复框。
- 帖子：减少了回复框上方显示当前回复楼层的信息栏的高度。
- 通知：现在来源于帖子中的消息会直接跳转到帖子的相应楼层，而不经过消息详情页。
- 通知：支持自动拉取消息。
  - 安卓平台上自动拉取到通知时发送系统通知。
  - 系统通知会显示最新一次自动拉取消息的情况，包括各类未读消息的数量和最新一条重要消息的通知。
  - 重要程度：私信 > 公共消息 > 提醒。
  - 默认开启，可在设置 -> 行为中调整和关闭。
- 通知：支持将消息标记为已读或未读。
  - 已读/未读状态仅本机有效。
  - 可在卡片上的菜单中更改标记状态。
  - 可在消息页面右上角菜单中批量将某一类消息标记为已读。
- 通知：现在消息页面内的卡片会在未读消息上显示小圆点。
  - 默认开启私信的小圆点标识，可在设置 -> 外观中调整。
- 通知：现在消息按钮角标显示的是所有类型的未读消息的数量总和。
- 通知：新增筛选未读通知的按钮。
- 通知：支持删除单个通知。
  - 卡片右上角菜单 -> 删除消息。
- app：支持设置和使用代理。
  - 默认关闭，可在设置 -> 高级 -> 启用代理中打开。
  - 在设置 -> 高级 -> 代理设置中设置代理的参数，可测试代理是否连通。
- app：优化图片加载流程，加载更平滑。
- app：现在在头像加载失败时会使用本地默认的头像，避免头像一直空白。
- app：现在加载失败的头像更容易触发重新加载。
- app：桌面平台上设置窗口标题。
- app：桌面平台上支持记住窗口大小和位置。
  - 默认开启，可在设置 -> 窗口中关闭。
- app：桌面平台支持窗口居中。
  - 默认关闭，可在设置 -> 窗口中开启。
- app：在linux上通过`$XDG_CURRENT_DESKTOP`检查是否位于平铺窗管环境中，如果是，不再记录窗口大小和位置。
- app：更新应用图标（感谢@Qing-Novel）。
- app：打包表情，现在应用安装包内自带所有表情。
- app：支持解析网页链接并在应用内打开。
  - 在主页和分区右上角按钮打开相应入口。
- app：支持avif格式的图片。
  - 不支持动图，只保留第一帧。
- app：现在可以在主页和分区页通过支持的论坛网页链接在应用内打开相应页面。
- app：支持多用户登录和切换。
- app：支持自动签到。
  - 启动时会为所有登录的账户签到。
  - 默认开启，可在设置 -> 签到中关闭。
- app：全局缓存和加载用户头像。
  - 现在原本无法显示用户头像的地方会通过已记录的头像缓存加载对应的用户头像。
  - 例如主页和分区内帖子作者的头像会在加载过一次后显示头像，而不是用户名的第一个字。
  - 后续会逐步扩大这一特性支持的范围。
- app：现在在点击图片弹出的操作菜单中，复制图片链接和打开跳转链接的部分会显示链接地址。
- 登录：在登录界面显示注册账户的跳转链接。
- 历史：新增帖子浏览记录。
  - 记录帖子名称、浏览的用户，帖子所在分区以及浏览时间。
- 统计：更新积分统计页面的布局，在积分历史中显示积分发生变动时的时间。

### Fixed

- app：修复当图片缓存失效时，图片没有重新加载的问题。
- app：修复图片加载失败时依然显示正在加载的问题。
- app：修复先前升级flutter版本导致的默认配色问题，现在使用默认的蓝色作为色调。
- app：修正各类边距值不是Material 3取值的问题。
- app：修复一些情况下，网络连接报错但UI没有更新的问题。
- app：修复部分图片无法加载的问题。
- app：修复突发图片加载失败时一直重复加载的问题。
- app：修复在macOS上无法联网的问题。
- app：修复在更新图片缓存时报错后，图片不会再次加载的问题。
- app：修复无法通过点击私信链接跳转到应用内私信页面的问题。
- app：修复加载重复图片时的闪烁。
  - 现在只有在第一次加载时会有加载外观。
- app：绕过了存在负数的“xx秒前”的问题，现在用“刚刚”这样模糊的词代替。
- 翻译：修复部分错误翻译。
- 帖子：修复部分签名档存在样式溢出的用户的所在楼层无法回复和评分的问题。
- 帖子：修复帖子评分中头像无法加载时不显示且不断重试的问题。
- 帖子：修复用户资料中的腹黑显示为天然的问题。
- 帖子：修复滚动时偶现的白屏。
- 帖子：修复折叠/展开卡片上文字颜色错误的问题。
- 帖子：修复部分折叠/展开卡片解析失败的问题。
- 帖子：修复评分内头像加载失败时无显示的问题。
- 帖子：修复在开启倒序浏览帖子时，从通知跳转到帖子后加载下一页的页数错误的问题。
- 帖子：修复一处解析到帖子id总是错误的问题。
- 帖子：修复下载表情的弹窗关闭后，后台依然在下载表情的问题。
- 通知：修复在当前页不是第一页的情况下更改浏览顺序时，顺序变更后再加载下一页时页数错误的问题。
- 通知：修复消息按钮角标显示的提醒数量不会随着浏览通知而更新的问题。
- 通知：修复拉取消息受不同设备影响的问题，现在只会以本机的拉取情况更新消息。
- 通知：修复解析7天内的公共消息时失败的问题。
- 通知：修复某些情况下公共消息详情加载失败的问题。
- 帖子：修复在开启倒序浏览帖子时，从通知跳转到帖子后无法切换浏览顺序的问题。
- 帖子：修复某些情况下浏览帖子时标题没有刷新的问题。
- 认证：修复登录页面刷新验证码时布局抖动的问题。
- 统计：修复积分统计中的积分值。
- 分区：修复开启帖子筛选条件时，显示没有置顶帖的问题。
- 分区：修复刷新页面后，置顶和子板块为空的问题。
- 主页：修复部分网络不稳定的情况下将加载失败显示为未登录的问题。
- 网页：修复折叠/展开按钮上的文字丢失颜色的问题。
- 网页：修复解析颜色时，部分颜色解析失败或错误的问题。
- 网页：修复解析`div`时布局错误的问题。
  - 初步处理， 现在某些情况下会多一些空行。
- 网页：修复折叠卡片的尾部多余的空行。
- 网页：修复粗体字样式丢失的问题。
- 网页：修复某些情况下，嵌套的字体样式丢失的问题。
- 网页：修复斜体字丢失的问题。
- 网页：修复部分帖子元素解析后在末尾有多余空行的问题。
- 网页：修复解析图片时图片大小不生效的问题。
- 统计：修复统计页面的积分中数据没有对齐的问题。
- 通知：修复无法现实某些类型的提醒的问题，现在能够显示所有类型的提醒。
- 用户：修复其他用户资料页刷新后显示当前登录用户资料的问题。
- 编辑：修复转换出的BBCode在某些情况下图片的大小为null的问题。
- 设置：修复Windows上自动构建编译出的版本中本地更新日志乱码的问题。

### Changed

- app：更改登录和拉取通知的实现方式，现在登录、首页和通知页的加载速度比原来更快。
- app：更新底部弹窗样式。
- app：图片加载时显示占位图片的大小调整为80x80。
- app：更新图片加载时的样式。
- app：更新图片加载时占位图片的样式，现在使用更浅的颜色。
- app：更新app描述和版权页样式。
- app：去除各种卡片的高度，更符合Material 3。
- app：优化布局，除去一些空白。
- app：现在会显示网络连接报错的原因。
- app：更新设置界面颜色选择和开关的样式。
- app：现在将表情打包到软件中，不需要也不再通过网络下载。
  - 导致软件大小增加约12MB。
- app：重构主页和论坛页布局。
- app：安卓平台上启动时使用透明色的状态栏。
- app：更新引用文字的外观样式，现在更紧凑。
- app：现在不会显示内容为空白的引用文字。
- 关于：更新版本号格式，更符合semver。
- 分区：某些情况下分区为空时显示登录按钮。
- 帖子：现在帖子的当前页码只会显示在右上角，随页面滚动而刷新。
- 帖子：优化帖子中各种卡片和按钮的样式。
- 用户：移除资料页顶部的背景图，使得顶部按钮更明显，同时减少可能的卡顿。
- 主页：迁移至官方轮播图，以修复一些问题。
- 主页：禁用已登录用户头像上的hero动画。
- 主页：更新了加载流程，减少了加载时间，现在应该和分区页一样快了。
- 主页：调整主页布局。
- 网页：现在解析网页内容时，不再改变换行位置。
  - 这会导致部分内容的换行位置与原始网页不同，但后续可以支持复制内容的功能。
- 通知：由于通知功能的实现方式发生了变更，更改了通知页的布局。
- 通知：现在消息页面内如果没有消息，会显示提示而不是什么都不显示。
- internal：提高flutter版本至 3.24（dart 3.5）。
- internal：gradle的参数mx增加到4608。
- internal：最低要求macOS 11。
- internal：重构功能：
  - 大部分设置项配置和读写逻辑。
  - 使用`talker`代替默认的`printer`做日志审计。
  - 数据库从isar迁移到drift。
  - **旧版本数据会丢失。**

## [0.14.0] - 2024-07-12

### Added

- 帖子：评分时提供默认评分理由。
- 帖子：评分时显示今日剩余可评分分数。
- 主页：新增点击可回到顶部的悬浮按钮。
- 通知：在通知详情页面回复后显示回复成功。
- app：适配夏日活动特殊积分。

### Fixed

- 帖子：修复评分数超出限制时依然提示评分成功的问题。
- 帖子：修复具有版主权限时无法回复其他楼层的问题。
- 分区：修复可用的筛选帖子的选项为空时依然显示筛选按钮的问题。
- 分区：修复用户具有版主权限时看不到帖子的问题。
- 通知：修复无法从用户艾特（@）通知跳转到原帖子的问题。
- 私信：聊天记录页面禁用无法使用的hero动画以避免异常。
- 关于：修复提交次数记录一直为1的问题。
- 主页：修复宽屏设备中侧边栏边框弧度问题。
- 设置：修复某些情况下Windows上本地更新日志乱码的问题。
- 通知：修复从通知进入对应帖子后，再返回通知界面时用户名称动画错误的问题。

### Changed

- 私信：私信的聊天记录和回复框之间加了一点距离。
- 通知：即使回复提醒所在的帖子已被关闭，也显示回复框以提示已关闭状态。
- 主页：恢复支持宽屏设备的布局，现在在宽屏上置顶帖会以多列而不是单列形式排布。
- 设置：仅在ios和Android显示防误触退出功能（桌面平台该功能无效）。
- 设置：更新选择色调的对话框样式。

## [0.13.1] - 2024-06-16

### Fixed

- 帖子：修复帖子只能倒序浏览的问题。

### Changed

- app: 更新样式和布局，更符合Material Design 3。

## [0.13.0] - 2024-06-14

### Added

- 帖子：支持对加载的图片进行操作：
  - 支持全屏查看、复制图片链接、打开附带的链接、重新加载图片。
- 帖子：支持默认倒序浏览。
  - 同网页端的倒序浏览，开启后帖子里优先看到最新发布的楼层。
  - 默认关闭，可在设置 -> 行为中开启。
- 设置：内置截止发布版本时的更新日志，不需要联网。
  - 设置 -> 其他-> 更新日志。
- 设置：清理缓存时支持按缓存类别清理。
- 用户：退出账户前增加确认弹窗，防止误退出。
- app：增加一些页面切换动画。

### Fixed

- app：修复加载图片时由于网站证书无效而无限加载的问题。
- app：修复计算时间时，存在负数的“xx秒以前”的问题。
- 解析网页：修复网址链接无法点击的问题。
- 解析网页：修复部分网址链接没有附加链接图标的问题。
- 帖子：修复楼层用户的简要信息中在线状态始终为离线的问题。
- 帖子：修复部分默认倒序浏览的帖子中无法更改排序的问题。
- 主页：修复轮播图在后台依然滚动的问题。
- 主页：修复轮播图在窗口大小改变后布局不正确的问题。
- 主页：修复某些情况下主页未完全加载时脱离加载状态的问题。

### Changed

- 关于：更新页面信息。
- 解析网页：优化解析流程。
- 主页：更新首页轮播图样式。

## [0.12.0] - 2024-06-01

### Added

- 应用：支持防误触退出，按两次返回才会退出应用。
  - 只在Android和iOS上有效。
  - 默认开启，可在设置 -> 行为中关闭。
- 主页：调整主页布局，可通过主页置顶帖子查看帖子作者的资料页。
- 首页：将“我的”页面从首页选项卡中去除。
- 用户：重构用户页面，显示更多用户信息。
  - 显示基本资料，用户组、积分信息。
  - 以html格式解析个人签名。
- 帖子：解析滚动区域marquee内的元素。
  - 虽然这些元素不会按原网页那样滚动。

### Fixed

- 帖子：修复未登录时可以切换编辑器的问题。
- 帖子：修复楼层用户的简要信息中缺少宣传度的问题。
- 编辑：修复编辑器的滚动导致页面标题栏背景色改变的问题。
  - 应该只在页面主体滚动时改变颜色。
- 首页：首页底部选项卡来回切换时重复加载的问题。
- 通知：修复包含长楼层的评分详情页面无法滚动的问题。

### Changed

- app：更新页面加载样式，减少使用圆形进度条。
- 帖子/编辑：更新帖子和编辑器中网页链接和艾特用户的样式，去掉背景色。
  - 背景色bug较多，暂时去除。

## [0.11.0] - 2024-05-19

### Added

- 通知：支持查看私信和公共消息。
  - 主页 -> 通知按钮。
- 通知：支持查看公共消息的完整详情。
- 私信：支持查看私信历史。
- 帖子：支持向楼层所属用户发送信息。
  - 楼层用户头像或名称 -> 对话框内按钮。
- 用户：支持从其他用户的用户资料页发送私信。
  - 资料页 -> 右上角发送按钮。

### Fixed

- 编辑：修复网页链接和提醒用户的样式。
- 编辑：修复艾特不存在的用户时，跳转到用户资料页后页面异常的问题。
- 编辑：修复发送文字失败后发送按钮不可用的问题。
- 帖子：修复楼层用户的简要信息中缺少用户组和昵称的问题。

### Changed

- 帖子：移除了楼层中的多余widget，优化性能。
- internal: flutter版本提高至3.22

## [0.10.1] - 2024-05-03

### Fixed

- 通知：修复无法跳转到提醒（@）类型的通知所在帖子的问题。
- 分区：修复帖子列表中，帖子的阅读权限被解析为天使币的问题。
- 帖子：修复楼层用户的简要信息中UID不正确的问题。
- 帖子：修复楼层用户的简要信息中缺少天使币的问题。
- 帖子：修复楼层最后编辑信息在用户名存在空格时信息错误的问题。
- 编辑：修复一部分切换编辑器后光标重置到文本开始位置的问题。
  - 如果切换前光标位于文本末尾，切换编辑器后光标也会位于文本末尾。
- 签到：修复签到附言字数过少或过多时依然可以保存的问题。
- 签到：修复签到附言的剩余可用字数计算不正确的问题。
- 签到：修复打开修改签到附言的对话框后显示的剩余可用字数不正确的问题。

### Changed

- 积分：现在默认收起已登录用户的积分统计信息页面中的查询框。

## [0.10.0] - 2024-04-27

### Added

- 帖子：帖子内通过楼层作者的头像和名称可以查看作者的简要信息。

### Fixed

- 编辑：修复帖子关闭后可以切换编辑器的问题。
- 编辑：修复帖子内发布回复后编辑器不可用的问题。

## [0.9.0] - 2024-04-12

### Added

- 编辑：支持提醒用户（@用户名）。
- 通知：通知为空时显示“通知为空”提示。

### Fixed

- 更新：修复更新页中获取最新一个版本的更新记录时内容为空的问题。
- 编辑：修复编辑器中插入图片时图片尺寸格式错误。
  - 图片的长和宽只允许使用整数。
- 编辑：修复粗体、斜体、下划线和删除线蔓延到之后的文本的问题。

### Changed

- 安卓：增加一些构建选项，减少了一半的apk体积（25MB -> 12MB）。
- 帖子：更新楼层中网页链接的样式，现在和bbcode编辑器相同。
- 帖子：更新网页链接的外观样式。
- 编辑：更新网页链接的外观样式。
- 编辑：编辑器插入网页链接时，不再自动加`https://`前缀。
- 网页：更新解析网页时标签`<li>`的样式。

## [0.8.0] - 2024-03-31

### Added

- 编辑：提供实验性的富文本bbcode编辑器，初步支持所见即所得。
  - 显示文本样式包括字体大小、粗体、斜体、下划线、删除线、字体颜色、背景色。
  - 支持插入表情、图片和网页链接。
  - 目前尚未做反向的解析bbcode，从普通编辑器切换到富文本时已有内容依然是纯文本属于正常现象，未来会支持。
  - 表情会从论坛下载，大约15MB，注意流量。
  - 在编辑器左下角图标切换普通编辑器和富文本编辑器。
- 帖子：解析更多的折叠/展开样式。
  - 现在支持\<details\> tag。
- 更新：更新页面可查看完整更新历史。
  - 右上角按钮。

### Fixed

- 帖子: 依旧是修复了楼层中很多多余或缺少的空行。
- 帖子：未登录时禁用回复框并提示需要登录。
- 帖子：修复切换楼层浏览排序（正序/倒序）后帖子当前页数不正确的问题。
- 首页：修复一些加载首页时无限转圈的问题。

### Changed

- 帖子：嵌套的卡片现在内层比外层高，以作区分。
- 帖子：更改展开/折叠区域的按钮样式，更明显。
- internal: 从Equatable迁移到dart_mappable。

## [0.7.1] - 2024-02-23

### Fixed

- app：修复Windows平台构建

## [0.7.0] - 2024-02-23

### Added

- 帖子：显示悬赏状态及对应的最佳答案。
- 帖子：支持编辑已发布的帖子。
  - 楼层右下角菜单 -> 编辑。
  - 一些附加选项可能不完全支持。
  - 暂不支持设置阅读权限和售价。
- 帖子：显示帖子楼层的最后编辑状态，包括时间和用户名。
- 帖子：帖子内按页数显示分组。
- 帖子：现在发送回复后会提示发送成功。
- 帖子：解析分割线\<hr\>。
- 消息：支持显示批量评分类型的提醒。
- 消息：在通知页内显示已有x条相同通知被忽略。
- 积分：支持筛选积分变更历史。
- app：现在在安卓和IOS上尝试使用和当前语言的应用标题。

### Fixed

- 积分：修复积分统计页面我的积分标签页中缺少空隙的问题。
- 帖子：修复部分楼层丢失字体颜色的问题。
- 我的帖子：修复我的帖子页面的丢失最新一条回复的问题。
- 消息：修复了离开消息详情页面后依然更新state导致异常的问题。
- app: 修复了很多处解析html时多余或缺少换行的问题。

### Changed

- 帖子：现在引用的文本用双引号包裹，而不是在一块更“高”的Card里。
  - 涉及评分通知、帖子楼层内引用的文本。
- 消息：高亮显示消息中的帖子标题和积分变动。
- internal: 支持flutter 3.19。
- internal: 去除安卓gradle构建脚本中标记为弃用的部分。
- internal: 提高最低依赖版本：flutter 3.19和dart 3.3。

## [0.6.0] - 2024-02-08

### Added

- 新增提示帖子内的红包已经领完了。
- 新增支持看帖时只看某个作者的楼层。
  * 楼层右下角菜单 -> 只看该作者/看所有作者。
- 新增支持看帖时倒序浏览。
  * 帖子右上角菜单 -> 倒序浏览/正序浏览。
- 新增支持从好友邀请参与话题的消息跳转到相应帖子。
- 新增支持筛选帖子。
- 新增支持查看新添加的好友的提醒。~~虽然加好友请求的提醒还没做~~
- 新增显示积分的统计信息和积分的变更记录的页面。
  * 我的 -> 右上角统计信息按钮。
- 在首页和我的页面内提醒有未读的消息。
  * 有提醒时显示提醒数量，只有短消息时显示红点。
  * 默认开启，可在设置中关闭。
- 在消息提醒卡片上显示是多久以前的消息。~~终于分得清哪个是哪个了~~
- 缓存首页轮播图。

### Fixed

- 修复无法解析部分带有投票的楼层的问题。
- 修复无法解析部分带有隐藏区域的楼层的问题。
- 修复上个版本引入的无法解析购买区域的问题。
- 修复更新页面无法跳转到github release的问题。
- 修复部分楼层中处于\<dl\>和\<dd\>标签内的内容无法显示的问题。
- 修复部分楼层中自定义字体周围多余换行的问题。

### Changed

- 不再显示被设置为不显示的html节点。

## [0.5.1] - 2024-01-31

### Fixed

- 修复了不显示仅作者可见的回复区域的问题。
- 修复了主页中展示的分类置顶贴分类标注顺序错误的问题。

### Changed

- 尝试打包MacOS和iOS平台的产物。
- 尝试支持MacOS和iOS平台的应用内更新。
- 现在更新页面中会始终显示跳转到github release的按钮。
- 成功领取红包后关闭红包领取按钮。

## [0.5.0] - 2024-01-26

### Added

- 新增解析仅作者可见的帖子回复。
- 新增支持领取红包。
  - 但是应该还没有领取提示。
  - ~~太难测了，先将就一下。~~
- 加载图片时显示带微光的占位图片以提示加载状态。
- 分区页面的置顶标签页内显示版规。
- 分区页面的所有标签页均支持下拉刷新。
- 分区页面点击当前标签页时滚动当前页面到顶部。
- 支持从评分卡片和消息卡片上的用户头像和名称跳转到用户信息页。
- 支持从首页的用户头像和名称跳转到当前用户信息页面。

### Fixed

- 修复设置色调时没有显示当前使用的色调颜色的问题。
- 修复设置色调时对话框标题会随着滚动的问题。
- 修复访问没有权限查看的分区时没有提示的问题。
- 修复部分情况下在帖子里的图片加载失败时不显示默认图片的问题。
- 修复一些图片加载失败的问题。
- 修复个人信息页面向下滚动后无法滚动回顶部的问题。
- 修复图片在已有缓存的情况下依然闪烁一次的问题。
- 修复通知页面内点击用户名可跳转到用户信息页面的部分过宽的问题。
- 修复一些情况下加载图片失败时没有使用默认图片的问题。
- 修复从链接跳转过去的帖子缺少标题的问题。
- 修复从连接跳转过去的分区缺少标题的问题。
- 修复分区页面只能在帖子标签页刷新的问题。
- 修复分区页面在加载时右上角跳页的按钮可以点击的问题。
- 修复跳转到无权限访问的帖子时没有提示的问题。
- 修复帖子页面楼层尾部有多于空行的问题。
- 修复帖子页面内一些楼层中文字排版没有换行的问题。
- 修复帖子页面内发表回复后无法再次输入回复的问题。

### Changed

- 现在尝试给自己的回复评分时会显示不能评分的提示。

## [0.4.0] - 2024-01-21

### Added

- 新增支持旅行者主题。
- 新增支持给帖子评分。
- 当从网络请求拉取图片失败时，使用默认的图片logo。
- 现在首页，分区和个人资料页可以下拉刷新。
- 去除了首屏加载页，现在软件启动后直接进入首页。
- 现在设置页面中修改签到想说的话时默认显示当前想说的话，方便修改。
- 现在搜索页内刷新搜索结果时会隐藏之前的搜索结果。
- 现在消息页面内，评分消息如果评分理由为空，会隐藏评分理由。
- 现在会缓存我的提醒页面内选项卡中已加载的数据，不再在切换选项卡时刷新。

### Fixed

- 修复不属于任何分类的帖子的页面内标题为空的问题。
- 修复无法从帖子的艾特（@）查看用户信息的问题。
- 修复用户信息页面的头像在头像不可用时未使用默认头像的问题。
- 修复用户信息页面打开几秒后会闪烁一次的问题。
- 修复论坛和帖子页面内有时候无法下拉刷新的问题。
- 修复消息页内无法通过评分类型的消息跳转到相应帖子的问题。

### Changed

- 更新隐藏区域卡片上的按钮样式，更明显。
- 如果帖子的评分消息中评分理由为空，不显示评分理由。
- 登录后，加载首页的时机推迟到访问首页时，而不是登录后直接加载。
- 帖子已经加载完时不再显示toast，而是显示snack bar。
- internal: 从riverpod迁移到bloc。

## [0.3.0] - 2023-12-30

### Added

- 新增解析帖子名称的颜色和字重。
- 新增解析帖子分类和状态图标（已关闭，评分，投票，加精，置顶等）。
- 新增解析论坛页面中的置顶帖。
- 新增解析一级标题到四级标题。
- 新增解析代码块标签（\<code\>）。
- 新增设置->关于->开源许可页面。
- 新增设置颜色色调。
- 新增用户信息页面，支持从楼层和帖子卡片跳转。
- 在已被关闭的帖子内关闭回复栏。
- 解析无序列表时在文字前添加圆点。
- 支持检查和下载最新版本。
- 支持从提醒跳转到帖子对应楼层的页面（目前只能滚动到同一页）。

### Fixed

- 修复页面中时间显示和网页端有误差的问题。
- 修复帖子页面加载数据报错。
- 修复论坛页面跳页后子论坛标签页内容变空的问题。
- 修复论坛页面在子版块标签页内无法跳页的问题。
- 修复论坛卡片上的最新帖子无法跳转的问题。
- 修复帖子内发送回复后发送按钮依然可点击的问题。
- 修复论坛页面刷新时偶见的异常。
- 修复清除缓存时卡住的问题。
- 修复帖子内标题包含分区名等非标题信息的问题。
- 修复搜索页面可能在窄屏幕上溢出问题。

## [0.2.0] - 2023-12-22

### Added

- 新增解析帖子楼层正文`postmessage`中的隐藏部分。
- 新增解析帖子中由于积分不足而隐藏的部分。
- 新增解析帖子中回复后才可见的部分。
- 新增解析对帖子回复的点评。
- 新增解析帖子中的展开/折叠部分。
- 现在打开帖子中的链接时对支持的链接优先以页面的形式在应用内打开。
- 现在论坛页面和帖子页面支持电梯直达。
- 帖子的评分表支持左右滚动以适应屏幕过窄的情况。
- 现在在帖子页面的列表顶部会显示帖子ID和帖子分类。

### Fixed

- 修复无法在具有多个隐藏部分的帖子中购买的问题。
- 修复当帖子的回复评分为扣分时显示总评分为空的问题。
- 修复安卓上帖子标题下方空白和其他页面不一致的问题。
- 修复搜索页面中跳页的对话框默认选中的页不是当前页的问题。
- 修复解析帖子分类时失败的问题。
- 修复因为未解析`pre`标签导致部分楼层内容为空的问题。
- 修复帖子中某些文字段落之间的换行消失的问题。

### Changed

- 展示帖子回复中代码块的方式由下划线文本改为代码卡片。
- 帖子页面中楼层顶部的标题使用完整的标题。
- 分区页面的分区标签栏按左对齐。

## [0.1.1] - 2023-12-17

### Fixed

- 修复主页帖子跳转失败的问题。

## [0.1.0] - 2023-12-16

### Added

- 首个release，新增基本的登录，看帖，回复等功能。

