// Copyright 2019 terrier989@gmail.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/*
Some source code in this file was adopted from 'dart:html' in Dart SDK. See:
  https://github.com/dart-lang/sdk/tree/master/tools/dom

The source code adopted from 'dart:html' had the following license:

  Copyright 2012, the Dart project authors. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Google Inc. nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

part of '../../html.dart';

abstract class PaymentAddress {
  PaymentAddress._();

  List<String>? get addressLine;

  String? get city;

  String? get country;

  String? get dependentLocality;

  String? get languageCode;

  String? get organization;

  String? get phone;

  String? get postalCode;

  String? get recipient;

  String? get region;

  String? get sortingCode;
}

@Native('PaymentInstruments')
class PaymentInstruments {
  factory PaymentInstruments._() {
    throw UnimplementedError();
  }

  Future clear() => throw UnimplementedError();

  Future<bool> delete(String instrumentKey) => throw UnimplementedError();

  Future<Map<String, dynamic>?> get(String instrumentKey) =>
      throw UnimplementedError();

  Future has(String instrumentKey) => throw UnimplementedError();

  Future<List<dynamic>> keys() => throw UnimplementedError();

  Future set(String instrumentKey, Map details) {
    throw UnimplementedError();
  }
}

@Native('PaymentManager')
class PaymentManager {
  factory PaymentManager._() {
    throw UnimplementedError();
  }

  PaymentInstruments? get instruments {
    throw UnimplementedError();
  }

  String? get userHint {
    throw UnimplementedError();
  }

  set userHint(String? value) {
    throw UnimplementedError();
  }
}

@Native('PaymentRequest')
class PaymentRequest extends EventTarget {
  factory PaymentRequest(List<Map> methodData, Map details, [Map? options]) {
    throw UnimplementedError();
  }

  String? get id {
    throw UnimplementedError();
  }

  PaymentAddress? get shippingAddress {
    throw UnimplementedError();
  }

  String? get shippingOption {
    throw UnimplementedError();
  }

  String? get shippingType {
    throw UnimplementedError();
  }

  Future abort() => throw UnimplementedError();

  Future<bool> canMakePayment() => throw UnimplementedError();

  Future<PaymentResponse> show() => throw UnimplementedError();
}

@Native('PaymentResponse')
class PaymentResponse {
  factory PaymentResponse._() {
    throw UnimplementedError();
  }

  Object? get details {
    throw UnimplementedError();
  }

  String? get methodName {
    throw UnimplementedError();
  }

  String? get payerEmail {
    throw UnimplementedError();
  }

  String? get payerName {
    throw UnimplementedError();
  }

  String? get payerPhone {
    throw UnimplementedError();
  }

  String? get requestId {
    throw UnimplementedError();
  }

  PaymentAddress? get shippingAddress {
    throw UnimplementedError();
  }

  String? get shippingOption {
    throw UnimplementedError();
  }

  Future complete([String? paymentResult]) => throw UnimplementedError();
}
