import 'package:analyzer/source/source_range.dart';
import 'package:custom_lint_builder/custom_lint_builder.dart';

import '../../utils/ast_node_extensions.dart';
import '../../utils/pubspec_extension.dart';
import '../../utils/type_checker.dart';
import '../../utils/utils.dart';

class WrapWithLayoutBuilder extends DartAssist {
  @override
  Future<void> run(
    CustomLintResolver resolver,
    ChangeReporter reporter,
    CustomLintContext context,
    SourceRange target,
  ) async {
    if (!context.pubspec.isFlutterProject) return;

    context.registry.addInstanceCreationExpression((node) {
      final sourceRange = node.keywordAndConstructorNameSourceRange;
      if (!sourceRange.covers(target)) return;

      final type = node.staticType;
      if (type == null || !widgetChecker.isSuperTypeOf(type)) return;

      if (layoutBuilderChecker.isExactlyType(type)) return;

      final parentWidget = findParentWidget(node);
      if (parentWidget != null) {
        final parentType = parentWidget.staticType;
        if (parentType != null && layoutBuilderChecker.isExactlyType(parentType)) {
          return;
        }
      }

      final changeBuilder = reporter.createChangeBuilder(
        message: 'Wrap with LayoutBuilder',
        priority: 29,
      );

      changeBuilder.addDartFileEdit((builder) {
        builder.addSimpleInsertion(node.offset, 'LayoutBuilder(builder: (context, constraints) { return ');
        builder.addSimpleInsertion(node.end, '; },)');
      });
    });
  }
}
