# 🌱 Contributing

First, we would like to thank you for your time and efforts on this project, we appreciate it.

> [!IMPORTANT]
> The package version in `pubspec.yaml` **should not be modified**; this will be handled by a maintainer or CI.

## 📋 Development Prerequisites

- [Flutter SDK](https://docs.flutter.dev/get-started/install), which can be installed by following the instructions the
  provided link, also make sure to add it to your path so `flutter --version` and `dart --version` work
- [IntelliJ IDEA Community Edition](https://www.jetbrains.com/idea/download/)
  or [Android Studio](https://developer.android.com/studio) (with Dart and Flutter plugins) or
  use [VS Code](https://code.visualstudio.com/) (with Dart and flutter extensions)

## 🧪 Test your changes

Make sure you have the [Requirement](#-development-prerequisites) installed and configured correctly

To test your changes:

1. Run the tests using your IDE or `flutter test`

## Guidelines 📝

1. **Documentation**:

   Document public APIs using Dart comments (https://dart.dev/effective-dart/documentation).
   Provide comprehensive documentation for any complex algorithms, data structures, or significant functionality.
   Write clear and concise commit messages and pull request descriptions.

2. **Performance**:

   Write efficient code and avoid unnecessary overhead.

3. **Code Review**:

   Encourage code reviews for all changes to maintain code quality and catch potential issues early.
   Use pull requests and code reviews to discuss proposed changes and improvements.

4. **Consistency**:

   Adhere to a consistent coding style throughout the project for improvement readability and maintainability

5. **Meaningful Names**:

   Use descriptive variable, class, and function names that clearly convey their purpose.

6. **Testing**:

   Try to write tests when possible
