import 'package:test/test.dart';

import 'utils/test_mappable.dart';

void main() {
  group('simple model', () {
    test('generates correct mapper code', () async {
      await testMappable(
        {
          'model': '''
            import 'package:dart_mappable/dart_mappable.dart';
            
            part 'model.mapper.dart';
            
            @MappableClass()
            class Model with ModelMappable {
              final String a;
              final int b;
              final double? c;
              final bool d;
            
              Model(this.a, {this.b = 18, this.c, required this.d});
            }
          ''',
        },
        outputs: {
          'model':
              '// coverage:ignore-file\n'
              '// GENERATED CODE - DO NOT MODIFY BY HAND\n'
              '// ignore_for_file: type=lint\n'
              '// ignore_for_file: unused_element, unnecessary_cast, override_on_non_overriding_member\n'
              '// ignore_for_file: strict_raw_type, inference_failure_on_untyped_parameter\n'
              '\n'
              'part of \'model.dart\';\n'
              '\n'
              'class ModelMapper extends ClassMapperBase<Model> {\n'
              '  ModelMapper._();\n'
              '\n'
              '  static ModelMapper? _instance;\n'
              '  static ModelMapper ensureInitialized() {\n'
              '    if (_instance == null) {\n'
              '      MapperContainer.globals.use(_instance = ModelMapper._());\n'
              '    }\n'
              '    return _instance!;\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  final String id = \'Model\';\n'
              '\n'
              '  static String _\$a(Model v) => v.a;\n'
              '  static const Field<Model, String> _f\$a = Field(\'a\', _\$a);\n'
              '  static int _\$b(Model v) => v.b;\n'
              '  static const Field<Model, int> _f\$b = Field(\'b\', _\$b, opt: true, def: 18);\n'
              '  static double? _\$c(Model v) => v.c;\n'
              '  static const Field<Model, double> _f\$c = Field(\'c\', _\$c, opt: true);\n'
              '  static bool _\$d(Model v) => v.d;\n'
              '  static const Field<Model, bool> _f\$d = Field(\'d\', _\$d);\n'
              '\n'
              '  @override\n'
              '  final MappableFields<Model> fields = const {\n'
              '    #a: _f\$a,\n'
              '    #b: _f\$b,\n'
              '    #c: _f\$c,\n'
              '    #d: _f\$d,\n'
              '  };\n'
              '\n'
              '  static Model _instantiate(DecodingData data) {\n'
              '    return Model(data.dec(_f\$a),\n'
              '        b: data.dec(_f\$b), c: data.dec(_f\$c), d: data.dec(_f\$d));\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  final Function instantiate = _instantiate;\n'
              '\n'
              '  static Model fromMap(Map<String, dynamic> map) {\n'
              '    return ensureInitialized().decodeMap<Model>(map);\n'
              '  }\n'
              '\n'
              '  static Model fromJson(String json) {\n'
              '    return ensureInitialized().decodeJson<Model>(json);\n'
              '  }\n'
              '}\n'
              '\n'
              'mixin ModelMappable {\n'
              '  String toJson() {\n'
              '    return ModelMapper.ensureInitialized().encodeJson<Model>(this as Model);\n'
              '  }\n'
              '\n'
              '  Map<String, dynamic> toMap() {\n'
              '    return ModelMapper.ensureInitialized().encodeMap<Model>(this as Model);\n'
              '  }\n'
              '\n'
              '  ModelCopyWith<Model, Model, Model> get copyWith =>\n'
              '      _ModelCopyWithImpl<Model, Model>(this as Model, \$identity, \$identity);\n'
              '  @override\n'
              '  String toString() {\n'
              '    return ModelMapper.ensureInitialized().stringifyValue(this as Model);\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  bool operator ==(Object other) {\n'
              '    return ModelMapper.ensureInitialized().equalsValue(this as Model, other);\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  int get hashCode {\n'
              '    return ModelMapper.ensureInitialized().hashValue(this as Model);\n'
              '  }\n'
              '}\n'
              '\n'
              'extension ModelValueCopy<\$R, \$Out> on ObjectCopyWith<\$R, Model, \$Out> {\n'
              '  ModelCopyWith<\$R, Model, \$Out> get \$asModel =>\n'
              '      \$base.as((v, t, t2) => _ModelCopyWithImpl<\$R, \$Out>(v, t, t2));\n'
              '}\n'
              '\n'
              'abstract class ModelCopyWith<\$R, \$In extends Model, \$Out>\n'
              '    implements ClassCopyWith<\$R, \$In, \$Out> {\n'
              '  \$R call({String? a, int? b, double? c, bool? d});\n'
              '  ModelCopyWith<\$R2, \$In, \$Out2> \$chain<\$R2, \$Out2>(Then<\$Out2, \$R2> t);\n'
              '}\n'
              '\n'
              'class _ModelCopyWithImpl<\$R, \$Out> extends ClassCopyWithBase<\$R, Model, \$Out>\n'
              '    implements ModelCopyWith<\$R, Model, \$Out> {\n'
              '  _ModelCopyWithImpl(super.value, super.then, super.then2);\n'
              '\n'
              '  @override\n'
              '  late final ClassMapperBase<Model> \$mapper = ModelMapper.ensureInitialized();\n'
              '  @override\n'
              '  \$R call({String? a, int? b, Object? c = \$none, bool? d}) =>\n'
              '      \$apply(FieldCopyWithData({\n'
              '        if (a != null) #a: a,\n'
              '        if (b != null) #b: b,\n'
              '        if (c != \$none) #c: c,\n'
              '        if (d != null) #d: d\n'
              '      }));\n'
              '  @override\n'
              '  Model \$make(CopyWithData data) => Model(data.get(#a, or: \$value.a),\n'
              '      b: data.get(#b, or: \$value.b),\n'
              '      c: data.get(#c, or: \$value.c),\n'
              '      d: data.get(#d, or: \$value.d));\n'
              '\n'
              '  @override\n'
              '  ModelCopyWith<\$R2, Model, \$Out2> \$chain<\$R2, \$Out2>(Then<\$Out2, \$R2> t) =>\n'
              '      _ModelCopyWithImpl<\$R2, \$Out2>(\$value, \$cast, t);\n'
              '}\n'
              '',
        },
      );
    });

    test('raw string as key for field', () async {
      await testMappable(
        {
          'model': '''
            import 'package:dart_mappable/dart_mappable.dart';
            
            part 'model.mapper.dart';
            
            @MappableRecord()
            typedef FullName = (@MappableField(key: r'\$firstName') String, String);

            @MappableClass()
            class Rawkeymodel with RawkeymodelMappable {
              final String a;
              final FullName? b;
            
              Rawkeymodel({
                @MappableField(key: r'\$key') required this.a,
                this.b,
              });
            }
          ''',
        },
        outputs: {
          'model':
              '// coverage:ignore-file\n'
              '// GENERATED CODE - DO NOT MODIFY BY HAND\n'
              '// ignore_for_file: type=lint\n'
              '// ignore_for_file: unused_element, unnecessary_cast, override_on_non_overriding_member\n'
              '// ignore_for_file: strict_raw_type, inference_failure_on_untyped_parameter\n'
              '\n'
              'part of \'model.dart\';\n'
              '\n'
              'class RawkeymodelMapper extends ClassMapperBase<Rawkeymodel> {\n'
              '  RawkeymodelMapper._();\n'
              '\n'
              '  static RawkeymodelMapper? _instance;\n'
              '  static RawkeymodelMapper ensureInitialized() {\n'
              '    if (_instance == null) {\n'
              '      MapperContainer.globals.use(_instance = RawkeymodelMapper._());\n'
              '      FullNameMapper.ensureInitialized();\n'
              '    }\n'
              '    return _instance!;\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  final String id = \'Rawkeymodel\';\n'
              '\n'
              '  static String _\$a(Rawkeymodel v) => v.a;\n'
              '  static const Field<Rawkeymodel, String> _f\$a = Field(\'a\', _\$a, key: r\'\$key\');\n'
              '  static FullName? _\$b(Rawkeymodel v) => v.b;\n'
              '  static const Field<Rawkeymodel, FullName> _f\$b = Field(\'b\', _\$b, opt: true);\n'
              '\n'
              '  @override\n'
              '  final MappableFields<Rawkeymodel> fields = const {\n'
              '    #a: _f\$a,\n'
              '    #b: _f\$b,\n'
              '  };\n'
              '\n'
              '  static Rawkeymodel _instantiate(DecodingData data) {\n'
              '    return Rawkeymodel(a: data.dec(_f\$a), b: data.dec(_f\$b));\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  final Function instantiate = _instantiate;\n'
              '\n'
              '  static Rawkeymodel fromMap(Map<String, dynamic> map) {\n'
              '    return ensureInitialized().decodeMap<Rawkeymodel>(map);\n'
              '  }\n'
              '\n'
              '  static Rawkeymodel fromJson(String json) {\n'
              '    return ensureInitialized().decodeJson<Rawkeymodel>(json);\n'
              '  }\n'
              '}\n'
              '\n'
              'mixin RawkeymodelMappable {\n'
              '  String toJson() {\n'
              '    return RawkeymodelMapper.ensureInitialized()\n'
              '        .encodeJson<Rawkeymodel>(this as Rawkeymodel);\n'
              '  }\n'
              '\n'
              '  Map<String, dynamic> toMap() {\n'
              '    return RawkeymodelMapper.ensureInitialized()\n'
              '        .encodeMap<Rawkeymodel>(this as Rawkeymodel);\n'
              '  }\n'
              '\n'
              '  RawkeymodelCopyWith<Rawkeymodel, Rawkeymodel, Rawkeymodel> get copyWith =>\n'
              '      _RawkeymodelCopyWithImpl<Rawkeymodel, Rawkeymodel>(\n'
              '          this as Rawkeymodel, \$identity, \$identity);\n'
              '  @override\n'
              '  String toString() {\n'
              '    return RawkeymodelMapper.ensureInitialized()\n'
              '        .stringifyValue(this as Rawkeymodel);\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  bool operator ==(Object other) {\n'
              '    return RawkeymodelMapper.ensureInitialized()\n'
              '        .equalsValue(this as Rawkeymodel, other);\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  int get hashCode {\n'
              '    return RawkeymodelMapper.ensureInitialized().hashValue(this as Rawkeymodel);\n'
              '  }\n'
              '}\n'
              '\n'
              'extension RawkeymodelValueCopy<\$R, \$Out>\n'
              '    on ObjectCopyWith<\$R, Rawkeymodel, \$Out> {\n'
              '  RawkeymodelCopyWith<\$R, Rawkeymodel, \$Out> get \$asRawkeymodel =>\n'
              '      \$base.as((v, t, t2) => _RawkeymodelCopyWithImpl<\$R, \$Out>(v, t, t2));\n'
              '}\n'
              '\n'
              'abstract class RawkeymodelCopyWith<\$R, \$In extends Rawkeymodel, \$Out>\n'
              '    implements ClassCopyWith<\$R, \$In, \$Out> {\n'
              '  \$R call({String? a, FullName? b});\n'
              '  RawkeymodelCopyWith<\$R2, \$In, \$Out2> \$chain<\$R2, \$Out2>(Then<\$Out2, \$R2> t);\n'
              '}\n'
              '\n'
              'class _RawkeymodelCopyWithImpl<\$R, \$Out>\n'
              '    extends ClassCopyWithBase<\$R, Rawkeymodel, \$Out>\n'
              '    implements RawkeymodelCopyWith<\$R, Rawkeymodel, \$Out> {\n'
              '  _RawkeymodelCopyWithImpl(super.value, super.then, super.then2);\n'
              '\n'
              '  @override\n'
              '  late final ClassMapperBase<Rawkeymodel> \$mapper =\n'
              '      RawkeymodelMapper.ensureInitialized();\n'
              '  @override\n'
              '  \$R call({String? a, Object? b = \$none}) =>\n'
              '      \$apply(FieldCopyWithData({if (a != null) #a: a, if (b != \$none) #b: b}));\n'
              '  @override\n'
              '  Rawkeymodel \$make(CopyWithData data) =>\n'
              '      Rawkeymodel(a: data.get(#a, or: \$value.a), b: data.get(#b, or: \$value.b));\n'
              '\n'
              '  @override\n'
              '  RawkeymodelCopyWith<\$R2, Rawkeymodel, \$Out2> \$chain<\$R2, \$Out2>(\n'
              '          Then<\$Out2, \$R2> t) =>\n'
              '      _RawkeymodelCopyWithImpl<\$R2, \$Out2>(\$value, \$cast, t);\n'
              '}\n'
              '\n'
              'class FullNameMapper extends RecordMapperBase<FullName> {\n'
              '  static FullNameMapper? _instance;\n'
              '  FullNameMapper._();\n'
              '\n'
              '  static FullNameMapper ensureInitialized() {\n'
              '    if (_instance == null) {\n'
              '      MapperContainer.globals.use(_instance = FullNameMapper._());\n'
              '      MapperBase.addType(<A, B>(f) => f<(A, B)>());\n'
              '    }\n'
              '    return _instance!;\n'
              '  }\n'
              '\n'
              '  static String _\$\$1(FullName v) => v.\$1;\n'
              '  static const Field<FullName, String> _f\$\$1 =\n'
              '      Field(\'\\\$1\', _\$\$1, key: r\'\$firstName\');\n'
              '  static String _\$\$2(FullName v) => v.\$2;\n'
              '  static const Field<FullName, String> _f\$\$2 = Field(\'\\\$2\', _\$\$2);\n'
              '\n'
              '  @override\n'
              '  final MappableFields<FullName> fields = const {\n'
              '    #\$1: _f\$\$1,\n'
              '    #\$2: _f\$\$2,\n'
              '  };\n'
              '\n'
              '  @override\n'
              '  Function get typeFactory => (f) => f<FullName>();\n'
              '\n'
              '  @override\n'
              '  List<Type> apply(MappingContext context) {\n'
              '    return [];\n'
              '  }\n'
              '\n'
              '  static FullName _instantiate(DecodingData<FullName> data) {\n'
              '    return (data.dec(_f\$\$1), data.dec(_f\$\$2));\n'
              '  }\n'
              '\n'
              '  @override\n'
              '  final Function instantiate = _instantiate;\n'
              '\n'
              '  static FullName fromMap(Map<String, dynamic> map) {\n'
              '    return ensureInitialized().decodeMap<FullName>(map);\n'
              '  }\n'
              '\n'
              '  static FullName fromJson(String json) {\n'
              '    return ensureInitialized().decodeJson<FullName>(json);\n'
              '  }\n'
              '}\n'
              '\n'
              'extension FullNameMappable on FullName {\n'
              '  Map<String, dynamic> toMap() {\n'
              '    return FullNameMapper.ensureInitialized().encodeMap(this);\n'
              '  }\n'
              '\n'
              '  String toJson() {\n'
              '    return FullNameMapper.ensureInitialized().encodeJson(this);\n'
              '  }\n'
              '\n'
              '  FullNameCopyWith<FullName> get copyWith =>\n'
              '      _FullNameCopyWithImpl(this, \$identity, \$identity);\n'
              '}\n'
              '\n'
              'extension FullNameValueCopy<\$R> on ObjectCopyWith<\$R, FullName, FullName> {\n'
              '  FullNameCopyWith<\$R> get \$asFullName =>\n'
              '      \$base.as((v, t, t2) => _FullNameCopyWithImpl(v, t, t2));\n'
              '}\n'
              '\n'
              'abstract class FullNameCopyWith<\$R> implements RecordCopyWith<\$R, FullName> {\n'
              '  \$R call({String? \$1, String? \$2});\n'
              '  FullNameCopyWith<\$R2> \$chain<\$R2>(Then<FullName, \$R2> t);\n'
              '}\n'
              '\n'
              'class _FullNameCopyWithImpl<\$R> extends RecordCopyWithBase<\$R, FullName>\n'
              '    implements FullNameCopyWith<\$R> {\n'
              '  _FullNameCopyWithImpl(super.value, super.then, super.then2);\n'
              '\n'
              '  @override\n'
              '  late final RecordMapperBase<FullName> \$mapper =\n'
              '      FullNameMapper.ensureInitialized();\n'
              '  @override\n'
              '  \$R call({String? \$1, String? \$2}) => \$apply(\n'
              '      FieldCopyWithData({if (\$1 != null) #\$1: \$1, if (\$2 != null) #\$2: \$2}));\n'
              '  @override\n'
              '  FullName \$make(CopyWithData data) =>\n'
              '      (data.get(#\$1, or: \$value.\$1), data.get(#\$2, or: \$value.\$2));\n'
              '\n'
              '  @override\n'
              '  FullNameCopyWith<\$R2> \$chain<\$R2>(Then<FullName, \$R2> t) =>\n'
              '      _FullNameCopyWithImpl(\$value, \$cast, t);\n'
              '}\n'
              '',
        },
      );
    });
  });
}
