# Nextcloud Deck for Android

[![Android CI](https://github.com/stefan-niedermann/nextcloud-deck/workflows/Android%20CI/badge.svg)](https://github.com/stefan-niedermann/nextcloud-deck/actions)
[![GitHub issues](https://img.shields.io/github/issues/stefan-niedermann/nextcloud-deck.svg)](https://github.com/stefan-niedermann/nextcloud-deck/issues)
[![GitHub stars](https://img.shields.io/github/stars/stefan-niedermann/nextcloud-deck.svg)](https://github.com/stefan-niedermann/nextcloud-deck/stargazers)
[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

An Android client for [Nextcloud Deck App](https://github.com/nextcloud/deck/).

## ▶️ Access

[![Latest Release](https://img.shields.io/github/v/tag/stefan-niedermann/nextcloud-deck?label=latest+release&sort=semver)](https://github.com/stefan-niedermann/nextcloud-deck/releases)
[![F-Droid Release](https://img.shields.io/f-droid/v/it.niedermann.nextcloud.deck)](https://f-droid.org/de/packages/it.niedermann.nextcloud.deck/)

[<img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png"
      alt="Get it on Play Store"
      height="80">](https://play.google.com/store/apps/details?id=it.niedermann.nextcloud.deck.play)
[<img src="https://f-droid.org/badge/get-it-on.png"
      alt="Get it on F-Droid"
      height="80">](https://f-droid.org/repository/browse/?fdid=it.niedermann.nextcloud.deck)
[<img src="https://raw.githubusercontent.com/stefan-niedermann/paypal-donate-button/master/paypal-donate-button.png"
      alt="Donate with PayPal"
      height="80">](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=ZD39ZE7MGEGBL&source=url)
[<img src="https://raw.githubusercontent.com/stefan-niedermann/DonateButtons/master/LiberaPay.png"
      alt="Donate using Liberapay"
      height="80">](https://liberapay.com/stefan-niedermann/donate)

## 👀 Screenshots

| List View | Card View |
| --- | --- |
| ![Screenshot of list view](/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png) | ![Screenshot of card](/fastlane/metadata/android/en-US/images/phoneScreenshots/5.png) |

## 🚀 Features
* Multiple accounts 👥
* Works offline 🔌
* Manage cards, lists and boards 📝
* Manage tags 🏷
* Supports attachments 📎, activities ⚡ & comments 💬
* Dark mode 🌙
* Translated in many languages 🌎

## 👪 Join the team
* Test the app with different devices
* Report issues in the [issue tracker](https://github.com/stefan-niedermann/nextcloud-deck/issues)
* [Pick a good first issue](https://github.com/stefan-niedermann/nextcloud-deck/labels/good%20first%20issue) :notebook:
* Create a [Pull Request](https://opensource.guide/how-to-contribute/#opening-a-pull-request)
* Help increasing the test coverage by contributing unit tests
* Translate the app on [Transifex](https://app.transifex.com/nextcloud/nextcloud/android-deck/)
* Send me a bottle of your favorite beer :beers: :wink:

## 🔗 Requirements
* [Nextcloud](https://nextcloud.com/) instance running
* [Nextcloud Android](https://github.com/nextcloud/android) app installed (≥ 3.9.0)
* [Nextcloud Deck](https://github.com/nextcloud/deck) app enabled (≥ 0.6.4)

## 📓 License
All contributions to this repository are considered to be licensed under the [GNU GENERAL PUBLIC LICENSE 3+](/LICENSE).

Contributors to the Deck Android app retain their copyright. Therefore we recommend to add following line to the header of a file, if you changed it substantially:

```
@copyright Copyright (c) <year>, <your name> (<your email address>)
```
