/*
 * Copyright (C) 2013-2023 Federico Iosue (federico@iosue.it)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package it.feio.android.omninotes.utils;

import android.content.Context;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import it.feio.android.omninotes.MainActivity;


public class KeyboardUtils {

  private KeyboardUtils() {
    // hides public constructor
  }

  public static void showKeyboard(View view) {
    if (view == null) {
      return;
    }

    view.requestFocus();

    InputMethodManager inputManager = (InputMethodManager) view.getContext().getSystemService(
        Context.INPUT_METHOD_SERVICE);
    inputManager.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT);

    ((InputMethodManager) view.getContext().getSystemService(Context.INPUT_METHOD_SERVICE))
        .showSoftInput(view, 0);

    if (!isKeyboardShowed(view)) {
      inputManager.toggleSoftInput(InputMethodManager.SHOW_FORCED, 0);
    }
  }


  public static boolean isKeyboardShowed(View view) {
    if (view == null) {
      return false;
    }
    InputMethodManager inputManager = (InputMethodManager) view.getContext().getSystemService(
        Context.INPUT_METHOD_SERVICE);
    return inputManager.isActive(view);
  }


  public static void hideKeyboard(View view) {
    if (view == null) {
      return;
    }
    InputMethodManager imm = (InputMethodManager) view.getContext()
        .getSystemService(Context.INPUT_METHOD_SERVICE);
    if (!imm.isActive()) {
      return;
    }
    imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
  }


  public static void hideKeyboard(MainActivity mActivity) {
    mActivity.getWindow().setSoftInputMode(
        WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
  }
}
