package it.devapp.android;
/* -------------------------------------------------
 * Autore : Francesco Colucci 2012
 */
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;

import android.graphics.drawable.Drawable;
import android.text.TextPaint;


import java.util.ArrayList;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.MapView;
import com.google.android.maps.OverlayItem;
import android.graphics.drawable.BitmapDrawable;

public class GeoOverlay extends ItemizedOverlay {
	
	Context mContext;
	int markerHeight;
	// costanti usate in draw
	int TITLE_MARGIN = 30;
	int FONT_SIZE = 30;
	
	// il chiamante
	GeoActivity mchiamante;
	
	// geoPoint di cui determinare la distanza
	GeoPoint geo1 = null;
	GeoPoint geo2 = null;
	
	// Geopoint temporaneo da utilizzare in GeoActivity contenenti i punti di cui si desidera il percorso
	GeoPoint tmp_geo1, tmp_geo2;   
	
	boolean sono_premuti_2_punti = false;
	
	private ArrayList<OverlayItem> mOverlays = new ArrayList<OverlayItem>();
			
	public GeoOverlay(Drawable arg0) {
		//super(arg0);
		
		super(boundCenterBottom(arg0));
		markerHeight = ((BitmapDrawable) arg0).getBitmap().getHeight();
		
	}

	@Override
	protected OverlayItem createItem(int i) {
		
		return mOverlays.get(i);
	}
    
	public boolean geo1_premuto()
	{
		if (geo1 != null)
			return true;
		else 
			return false;
	}	
	
	@Override
	public int size() {
		
		return mOverlays.size();
	}
	@Override
	public void draw(Canvas canvas, MapView mapView, boolean shadow) {
 	/**	
		Paint strokePaint = new Paint();
	    strokePaint.setARGB(255, 0, 0, 0);
	    strokePaint.setTextAlign(Paint.Align.CENTER);
	    strokePaint.setTextSize(16);
	    strokePaint.setTypeface(Typeface.DEFAULT_BOLD);
	    strokePaint.setStyle(Paint.Style.STROKE);
	    strokePaint.setStrokeWidth(2);

	    Paint textPaint = new Paint();
	    textPaint.setARGB(255, 255, 255, 255);
	    textPaint.setTextAlign(Paint.Align.CENTER);
	    textPaint.setTextSize(FONT_SIZE);
	    textPaint.setTypeface(Typeface.DEFAULT_BOLD);

	    canvas.drawText("Nostra Posizione", 100, 100, strokePaint);
	    canvas.drawText("Nostra Posizione", 100, 100, textPaint); 
  **/		
		
		super.draw(canvas, mapView, shadow);
		
//     go through all OverlayItems and draw title for each of them
		
        for (OverlayItem item:mOverlays)
        {
            // Converts latitude & longitude of this overlay item to coordinates on screen.
            // As we have called boundCenterBottom() in constructor, so these coordinates
            // will be of the bottom center position of the displayed marker.
            //
            GeoPoint point = item.getPoint();
            Point markerBottomCenterCoords = new Point();
            mapView.getProjection().toPixels(point, markerBottomCenterCoords);

            // Find the width and height of the title 
            TextPaint paintText = new TextPaint(Paint.ANTI_ALIAS_FLAG);
            Paint paintRect = new Paint();

            Rect rect = new Rect();
            paintText.setTextSize(FONT_SIZE);
            paintText.getTextBounds(item.getTitle(), 0, item.getTitle().length(), rect);

            // TITLE_MARGIN = dx , TITLE_MARGIN = dy
            rect.inset(-TITLE_MARGIN, -TITLE_MARGIN);
            rect.offsetTo(markerBottomCenterCoords.x - rect.width()/2, markerBottomCenterCoords.y - markerHeight - rect.height());

            paintText.setTextAlign(Paint.Align.CENTER);
            paintText.setTextSize(FONT_SIZE);
            paintText.setARGB(255, 255, 0, 0); // testo red
        //    paintRect.setARGB(1, 0, 0, 0); // riquadro appena visibile
            paintRect.setARGB(5, 0, 0, 0); // riquadro non visibile
            
            canvas.drawRoundRect( new RectF(rect), 2, 2, paintRect);
            canvas.drawText(item.getTitle(), rect.left + rect.width() / 2,
                    rect.bottom - TITLE_MARGIN, paintText);
        }
		
	} // fine draw
	
	public void addOverlay(OverlayItem overlay) {
	    mOverlays.add(overlay);
	    this.populate();
	    
	}
	public GeoOverlay(Drawable defaultMarker, Context context, GeoActivity chiamante) {
		super(boundCenterBottom(defaultMarker));
          
		  mContext = context;
		  mchiamante = chiamante;
		}
	/* ----------------------------------------------------- 
	        Calcola la Distanza in Km tra due Geopoint
	-------------------------------------------------------- */       
	public double CalculationByDistance(GeoPoint StartP, GeoPoint EndP) {  
	      double lat1 = StartP.getLatitudeE6()/1E6;  
	      double lat2 = EndP.getLatitudeE6()/1E6;  
	      double lon1 = StartP.getLongitudeE6()/1E6;  
	      double lon2 = EndP.getLongitudeE6()/1E6;  
	      double dLat = Math.toRadians(lat2-lat1);  
	      double dLon = Math.toRadians(lon2-lon1);  
	      double a = Math.sin(dLat/2) * Math.sin(dLat/2) +  
	         Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) *  
	         Math.sin(dLon/2) * Math.sin(dLon/2);  
	      double c = 2 * Math.asin(Math.sqrt(a));  
	      return 6371 * c;  // 6371 KM è il raggio della Terra   
	   }  
	
	@Override
	protected boolean onTap(int index) {
	  
      boolean risultato = true;
	  Double dist = 0.0;
	  
	  // Preleva l'overlay item su cui c'è stato il click	
	  OverlayItem item = mOverlays.get(index);
	  // assegna il geoPoint cliccato al primo geo libero
	  // geo1 è il primo punto su cui si è fatto click
	  if (geo1 == null)
		  geo1 = item.getPoint();
	  else
		  if (geo2 == null)
		    geo2 = item.getPoint();
	  
	  if ((geo1 != null) & (geo2 != null) & (geo1 != geo2))
	  {
		dist = CalculationByDistance(geo1,geo2);
		sono_premuti_2_punti = true;
		
		// abilita il pulsante Road del chiamante
		mchiamante.bnt_road.setEnabled(true);
		
		// salva i punti del percpremuti_2_punti;orso da disegnare
		tmp_geo1 = geo1;
		tmp_geo2 = geo2;
		
		geo1 = geo2 = null;
	    try
	    {
		   AlertDialog.Builder dialog = new AlertDialog.Builder(mContext);
		  // dialog.setTitle(item.getTitle());
		     
		     if (dist >= 1)
		    	 dialog.setMessage("in linea d'aria: km " + dist.toString().substring(0, 4));
		     else // converte in metri 
		     {
		    	 dist *=  1000; // moltiplica per mille per convertire da km in m.
		    	 dialog.setMessage("in linea d'aria: metri " + dist.toString().substring(0, 4));
		     }
		     dialog.show();
	    }
	    catch (NullPointerException e)
	    {
	      risultato = false;
	    }
	    finally
	    {
	      risultato = true;
	    }
	  }  // end if  ((geo1 != null) & (geo2 != null)) 
	  if (geo1 == geo2)
		  geo1 = geo2 = null;
	return risultato;
	}
	
}
