package it.devapp.android;

/* -------------------------------------------------
 * Autore : Francesco Colucci 2012
 */
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.support.v4.content.LocalBroadcastManager;
import android.telephony.SmsManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;


public class GeoActivity extends MapActivity 
{	
	
	List<Overlay> mapOverlays;
	Drawable drawable;
	
	GeoOverlay itemizedoverlay;  
	MapView mapView;
	MapController mapController;
	LocationManager locationManager;
	Phonecalls chiamata_activity;
	
	// listener per il cambaimento della posizione
	LocationListener gpsListener=null;
	LocationListener networkListner=null;
    
	// costante per il numero massimo di punti che la mappa può visualizzare
	static final int  max_nro_punti = 10;
	
	// La posizione corrente del telefonino
	Location currentLocation = null;
	
	// numero di tel del mittente nel caso di ricezione di un SMS sulla mappa, senza ?pos o ?nam ....
	String tel_mitt = ""; 
	
	// per visualizzare un sms interno all'applic.
	AlertDialog.Builder builder;
	AlertDialog alert;
	
	boolean in_comunicazione = false;  // se false significa che non c'è ancora comunicazione tra padre e un figlio
      // se è true significa che vi è comunicazione con almeno un figlio.
	
	Cursor cur;
	
	// i filter per il broadcastReceiver
	IntentFilter intentFilter, shutdownFilter;   
	
	LocalBroadcastManager mLocalBroadcastManager;
    private BroadcastReceiver intentReceiver, ShutdownReceiver;

    Double d_lat;  // latitudine e longitudine per la geolocalizzaz del punto
    Double d_lon;
    
    boolean inRubrica = false;  // settato true se l'utente è andato nella rubrica per selezionare i nomi
	boolean is_padre = false;   // è settato true solo se seleziona la rubrica
	
	// Contatti a cui inviare la geolocalizzazione dell'applicazione corrente
	ArrayList<String> lista_nomi;  // solo per i figli, in posiz. 0 c'è il nome di papà
    ArrayList<String> lista_numeri; // solo per i figli, in posiz. 0 c'è il numero di papà
		
	// ------------------ lat[] e lon[] --------------------------------------------------------
    // contengono latitudine e longitudine delle posizioni degli utenti che non fungono da Papà
    // se la latitud. o longit. è zero significa che quell'utente ha chiuso
    // sono inizializzati con il valore -1
    
    Double lat[] = new Double[max_nro_punti]; // vettore delle latitudini associato a lista_nomi e lista_numeri attraverso l'indice
	Double lon[] = new Double[max_nro_punti]; // vettore delle longitudini associato a lista_nomi e lista_numeri attraverso l'indice
	
	// ---------------------------------------------
    // inizialmente il progr.si comporta da figlio, 
    // se si attiva la rubrica allora si comporta da papà e 
    // questo è il suo numero
    // ----------------------------------------------
	String numero_di_papa = "";   //se si comporta da figlio, questo è il numero di Papà
	String nome_di_papa = "";     //se si comporta da figlio, questo è il nome di Papà
	
	//Latitudine e longitudine di Papà (di chi inizia la procedura)
	Double latit, longitud; 
	
	// definisce i punti sulla mappa
	GeoPoint point, point1, my_home_point;
	
	OverlayItem overlayitem;
		
	Bundle extras;
	
	// Nome del proprietario ME del cellulare: preso da profile
	String myName = "";   
	
	// colonne da cui leggere il nome del proprietario del telefonino
	String[] projection = new String[] 
			{
			  ContactsContract.Profile._ID, 
              ContactsContract.Profile.DISPLAY_NAME,
              ContactsContract.Profile.HAS_PHONE_NUMBER
	        };
	
	Button bnt_sms, bnt_contatti, bnt_call, bnt_road;
    
	@Override
	protected boolean isRouteDisplayed() {
	    return false;
	}

	/** ---------------------------------------------- */
	/*                                                 */  
	/* Chiamato quando MapActivity è stata creata      */
	/*             onCreate Method                     */
	/* ----------------------------------------------- */
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
  //    	int Dialog_Conferma_Con_GPS_Off = 2;
  //    	int Dialog_Conferma_Uscita = 1;
      	
		super.onCreate(savedInstanceState);
      	
      	setContentView(R.layout.main);
        
      	
      	
      	intentFilter = new IntentFilter();
    	intentFilter.addAction("SMS_RECEIVED_ACTION");
    	
    	shutdownFilter = new IntentFilter();
        
    	//	shutdownFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
    	shutdownFilter.addAction("android.intent.action.QUICKBOOT_POWEROFF");
    	
        // URI per accedere alle informazioni dell'utente ME del telefonino
    	Uri mE = ContactsContract.Profile.CONTENT_URI;
    	
    	// la query per estrarre le informazioni dell'Utente ME
    	cur = managedQuery(mE, projection, ContactsContract.Profile.DISPLAY_NAME + " LIKE ?", new String[] {"%"} , ContactsContract.Profile.DISPLAY_NAME + " DESC");
        
        // inizializza la mappa di Google mapView
        mapView = (MapView) findViewById(R.id.mapview);
       
                
        // Crea l'oggetto builder di tipo AlertDialog.Builder
        builder = new AlertDialog.Builder(this);
        
        // abilita lo zoom control sulla mappa
        mapView.setBuiltInZoomControls(true);
        
        lista_nomi = new ArrayList<String>(max_nro_punti);
        lista_numeri = new ArrayList<String>(max_nro_punti);
        
        // inizializza a -1 (nessun riferimento geografico) i vettore lat[] e lon[]
        int valore_iniziale = -1;
        for(int k=0;k < max_nro_punti;k++)
        {
        	lat[k] = (double) valore_iniziale;
        	lon[k] = (double) valore_iniziale;
        }
        
        // rende la mappa cliccabile
        mapView.setClickable(true);
        mapController = mapView.getController();
        // imposta la mapview come mapview presa dal satellite
        mapView.setSatellite(true);
        // mostra le info del traffico sulla mappa del satellite
        mapView.setTraffic(true);
        mapView.setBuiltInZoomControls(true);
        
        mapOverlays = mapView.getOverlays();
        drawable = this.getResources().getDrawable(R.drawable.ic_launcher);
        itemizedoverlay = new GeoOverlay(drawable, this, this);
        
        // We use this to send broadcasts within our local process.
        mLocalBroadcastManager = LocalBroadcastManager.getInstance(this);
        
        // inizializza il locationManager e Acquisizione del riferimento al Location Manager di sistema
        locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
       
               
        intentReceiver = new BroadcastReceiver()
    	{
    		
    		@Override
    		public void onReceive(Context context, Intent intent)
    		{
    			String longit = "";
    	    	String latitud = "";
    	    	String intestaz = "";
    	    	String numero_figlio = "";  // num di tel del figlio che arriva con ?pos:
    	    	String mesg;   // messaggio da visualizzare nella finestra di dialogo
    	    	
    	    	int i; // posizione in cui si trova l'elemento di cui è giunta la posizione con ?pos:
    			
    	    	extras = intent.getExtras();
    			// legge l'intestazione
    			if (extras.getString("it.devapp.android.INTESTAZIONE") != null)
    			{
    	    	
    			  // legge l'intestazione
    			  intestaz = extras.getString("it.devapp.android.INTESTAZIONE");
    			  // ----------------------------------------------------------------
    	      	  // E' arrivato ?ppa:long lat .. il figlio deve ridisegnare la mappa
    			  // ----------------------------------------------------------------
    			  if ( intestaz.equals("?ppa:") == true)  
    	    	  {	
    	            longit = extras.getString("it.devapp.android.LONGITUDINE");
    	    	    latitud = extras.getString("it.devapp.android.LATITUDINE");
    	    	  
    	    	    //  controlla se effettivamente è un Resume derivante dalla chiamata 
    	    	    // del BroadcastReceiver
    	    	    {	                                           
    	    	    	   
    	            if (!(longit.equals("")) && !(latitud.equals("")) )  
    	           	// controlla se è il papà che ha smesso di funzionare ...	
    	            	if ( ( latitud.equals("0")) && (longit.equals("0")) ) 	
    	        	    {
    	        		    // Toast.makeText(getApplicationContext(), nome_di_papa + " (closed at" , Toast.LENGTH_LONG).show();	
    	               		Calendar c = Calendar.getInstance();
    	            		nome_di_papa = nome_di_papa + " (closed at: " + c.get(Calendar.HOUR_OF_DAY) + ":" +c.get(Calendar.MINUTE) +")";
    	                    lista_nomi.set(0, nome_di_papa);  // aggiunge al nome in pos. 0 (quello di papà) l'ora dello spegnimento
    	        	    }
    	        	    else
    	        	    // non è un papà che ha smesso di funzionare, quindi 
    	        	    //	mette la posizione di papà in posto 0	
    	        	    {	  
    	        	      lat[0] = (Double.valueOf(latitud.trim()) * 1E6);
    	        		  lon[0] = (Double.valueOf(longit.trim()) * 1E6);
    	        		  if ((bnt_call.isEnabled() == false) && (bnt_sms.isEnabled() == false))
    	        		  {	
    	        		    bnt_call.setEnabled(true);
    	        		    bnt_sms.setEnabled(true);
    	        		  }
    	        	    }	
    	            	ridisegna_mappa();    // ridisegna la mappa
    	        		
    	            }
    	    	  } else
    	    	  // --------------------------------------------------------------------------
    	    	  // è arrivata la posizione di un figlio, il Papà aggiorna il vettore delle lat 
    	    	  // e delle longitudini  dei figli e ridisegna la mappa
    	    	  // ---------------------------------------------------------------------------	  
    	          if  ( intestaz.equals("?pos:") == true) 
    	    	  {	
    	                 	
    	    	    longit = extras.getString("it.devapp.android.LONGITUDINE");
    	    	    latitud = extras.getString("it.devapp.android.LATITUDINE");
    	    	    numero_figlio = extras.getString("it.devapp.android.TEL");
    	    		 
    	    	    // controlla se è una richiesta valida	
    	            if (!(longit.equals("")) && !(latitud.equals("")) )  
    	           	{	                                           
    	    	      // ricerca il numero di telefono nell'Array List 
    	              i = lista_numeri.indexOf(numero_figlio);
    	              
    	              // Log.i("Disegna Punti" ,"figlio trovato in posizione: "+i+" nome: " +lista_nomi.get(i));
    	              // Toast.makeText(getApplicationContext(), "size di lista_numeri è: " + Integer.toString(lista_numeri.size()), Toast.LENGTH_SHORT).show();
    	              if (i != -1)    // ha trovato la posizione
    	              {
    	             
    	            	if ( (latitud.equals("0")) && (longit.equals("0")))  	// è un figlio che ha smesso di funzionare ...
    	      	        {
    	                  // Toast.makeText(getApplicationContext(), lista_nomi.get(i) + " ha chiuso" , Toast.LENGTH_LONG).show();
    	                  Calendar c = Calendar.getInstance();
    	            	  lista_nomi.set(i, lista_nomi.get(i) + " closed at " + c.get(Calendar.HOUR_OF_DAY) + ":" +c.get(Calendar.MINUTE));
    	                }
    	                else
    	                {	
    	                  if (in_comunicazione == false) 
    	                	  in_comunicazione = true;    // se non era in comunicazione ora si certifica che padre e figlio
    	                                                  // lo sono
    	                  // ora controlla se è il primo invio della posizione da parte del figlio
    	                  // se è così invia la posizione del padre (handshake iniziale)	
    	                  if (lat[i] == -1) 
    	                  { 	  
    	                	// ppa = posizione di papà
    	                	  sendSMS((String)lista_numeri.get(i), "?ppa:"+longitud+ " " + latit);
    	                  }	  
    	        		  lat[i] = (Double.valueOf(latitud.trim()) * 1E6);
    	        		  lon[i] = (Double.valueOf(longit.trim()) * 1E6);
    	        		  if ((bnt_call.isEnabled() == false) && (bnt_sms.isEnabled() == false))
    	        		  {	
    	        		    bnt_call.setEnabled(true);
    	        		    bnt_sms.setEnabled(true);
    	        		  
    	                  }  
    	            	
    	            	  ridisegna_mappa();               // ridisegna la mappa
    	                } 
    	        	  }
    	              // ----------------------------------------------------------
    	              // non ha trovato il numero di tel. in lista_numeri dei figli,
    	              // ciò significa che è il primo invio del figlio (handshake iniziale),
    	              // quindi invia la sua posizione al figlio
    	              // ----------------------------------------------------------
    	        	  else    
    	        	  {
    	        		  
    	        	  }
    	        		 
    	    	    }  
    	    	  }
    	          else
    	          // Ora è arrivato ?nam:Nomepapà ..........
    	          if ( intestaz.equals("?nam:") == true)
    		      {
    		        numero_di_papa = extras.getString("it.devapp.android.PAPA_NUMBER");
    		        nome_di_papa = extras.getString("it.devapp.android.PAPA_NAME");
    		        if (lista_numeri.size() > 0)     // c'è già un papà che aveva chiuso prima....
    		        {	  
    		          lista_numeri.set(0, numero_di_papa);  // aggiunge al nome in pos. 0 (quello di papà presente con spento alle...) 
    		          lista_nomi.set(0, nome_di_papa);  // aggiunge al nome in pos. 0 (quello di papà presente con spento alle...) 
    		        }
    		        else
    		        {	  
    		          // aggiunge a lista_nomi e a lista_numeri rispettivamente il nome e il numero di Papà in 1^ pos.
    		          lista_nomi.add(nome_di_papa);
    		          lista_numeri.add(numero_di_papa);
    		        }
    		        // ora il figlio restituisce al Papà attraverso un SMS quale sia la sua posizione attuale
    		        // Toast.makeText(getApplicationContext(), "E' arrivato il nome di Papà", Toast.LENGTH_SHORT).show();	
    		        sendSMS(numero_di_papa, "?pos:" + longitud + " " + latit);
    		          
    		        bnt_contatti.setEnabled(false); // disabilita l' uso della rubrica contatti, perchè è diventato figlio
    		      }
    	    	}
    	        // non è arrivato nessun ?pos o ?ppa o ?nam.... Vede se è un messaggio di papà o di qualche figlio
    		    if ( (extras != null) && ( extras.getString("it.devapp.android.MESSAGGIO") != null))  		
    		    {
    		      mesg = extras.getString("it.devapp.android.MESSAGGIO");
    		          		          		      
    		      if (extras.getString("it.devapp.android.MITTENTE") != null)
    		        tel_mitt = extras.getString("it.devapp.android.MITTENTE");
    		      else
    		    	tel_mitt = "";
    		      	  
    		      // Richiama la finestra Alert Dialog
    		      if (builder != null)
    		      {	 
    		         // Definisce l'alert dialog per visualizzare gli SMS
    		          builder.setPositiveButton("Close", new OnClickListener() 
    		          {
    		           public void onClick(DialogInterface arg0, int arg1) 
    		           {
    		              //sul click Chiudi
    		             arg0.dismiss();
    		           }
    		           });
    		        
    		          // ricerca il figlio in base al numero arrivato
    		          i = lista_numeri.indexOf(tel_mitt);
    		          if (1 != -1)  // lo ha trovato
    		          {
    		        	tel_mitt = lista_nomi.get(i);  // sostituisce al numero il nome
    		          }
    		       	  builder.setTitle( "SMS da " + tel_mitt );
    	              builder.setMessage( mesg );
    	              alert = builder.create();
    		       	  if (alert != null)
    	                 alert.show();
    		       	  else
    		       	  {	  
    		       		// Toast.makeText(getApplicationContext(), "alert è null", Toast.LENGTH_SHORT).show();
    		       	  }	  
    		      }
    		      else
    		      {
    		    	  // Toast.makeText(getApplicationContext(), "builder è null", Toast.LENGTH_SHORT).show(); 
    		      }	  
    			  
    			}	
    		        		
    		}
    	};     		
    	
        // registra il receiver
    	mLocalBroadcastManager.registerReceiver(intentReceiver,intentFilter);
    	    	
    	// -------------------------------------
    	// riceve il controllo allo shutdown
    	// -------------------------------------
    	ShutdownReceiver = new BroadcastReceiver()
    	{
            // alla ricezione dello shutdown invia pos:0 0
    	    @Override
    	    public void onReceive(Context context, Intent intent) 
    	    {
    	    	Log.i("ShutDownReceiver" ,"sono in ShutDownReceiver " );
    	    	int i;
    	      	// SE E' FIGLIO ......
    	        // comunica al papà che ha smesso, se si sta comportando da figlio
    	        if (is_padre == false)  // ... è un figlio
    	        {	   
    	     	  if (numero_di_papa.equals("") == false)
    	     		  sendSMS(numero_di_papa,"?pos:" + 0 + " " + 0);   // manda al padre ?pos: 0 0    per comunicare che ha terminato di esistere
    	        }
    	        else    // è padre ....
    	    	{
    	          i = 0;  // il primo elemento è in posizione 0
    	          while(i <= lista_numeri.size()-1)    // invia a tutti i figli ancora in vita la posizione 0 0
    	          {	
    	             if (lista_nomi.get(i).indexOf("closed") == -1)  // se non ha trovato un figlio spento.... invia il messaggio
    	             {
    	            	 sendSMS((String)lista_numeri.get(i), "?ppa:" + 0 + " " + 0);
    	             }
    	             i++;
    	          }  
    	        }    
    	    }

    	};
          	 	
    	
       // inizializzaz. pulsante chiamata telefonica
        bnt_call = (Button) findViewById(R.id.chiamata_button);
        bnt_call.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View v) 
            {
                
            	// controlla se il primon push-pin è stato premuto
            	if ( itemizedoverlay.geo1_premuto() ) 
            	{	
            	  Intent intent = new Intent(GeoActivity.this, Phonecalls.class);
            	  startActivity(intent);
            	  
            	  itemizedoverlay.geo1 = null;
            	  
            	}  
            }
        });   

        bnt_road = (Button) findViewById(R.id.percorso_button);
        bnt_road.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View v) 
            {
                if (itemizedoverlay.sono_premuti_2_punti == true)
                {
                   //Usiamo l'activity RoadWeb      
       		       Intent intent2 = new Intent(GeoActivity.this, RoadWeb.class);
       		       // gli passa la stringa dell'URL
       		       if (my_home_point == itemizedoverlay.tmp_geo1)  // fa in modo che il primo punto sia quello locale
       		       {	 
       		         intent2.putExtra("it.devapp.android.URL_PERCORSO", "http://maps.google.com/maps?f=d&hl=it&saddr="+
       		         itemizedoverlay.tmp_geo1.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo1.getLongitudeE6()/1E6+"&daddr=" + 
       		    		 itemizedoverlay.tmp_geo2.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo2.getLongitudeE6()/1E6);
       		       }
       		       else
       		       if (my_home_point == itemizedoverlay.tmp_geo2)
       		       {	 
         		       intent2.putExtra("it.devapp.android.URL_PERCORSO", "http://maps.google.com/maps?f=d&hl=it&saddr="+
         		         itemizedoverlay.tmp_geo2.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo2.getLongitudeE6()/1E6+"&daddr=" + 
         		    		 itemizedoverlay.tmp_geo1.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo1.getLongitudeE6()/1E6);
         		   }
       		       else
       		       {
       		       	intent2.putExtra("it.devapp.android.URL_PERCORSO", "http://maps.google.com/maps?f=d&hl=it&saddr="+
              		         itemizedoverlay.tmp_geo1.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo1.getLongitudeE6()/1E6+"&daddr=" + 
              		    		 itemizedoverlay.tmp_geo2.getLatitudeE6()/1E6+","+itemizedoverlay.tmp_geo2.getLongitudeE6()/1E6); 
       		       }
       		     startActivity(intent2);
       	         itemizedoverlay.sono_premuti_2_punti = false;
       	         bnt_road.setEnabled(false);
                }
            }
        });   

        // inizialmente disabilitato
        bnt_road.setEnabled(false);
        
     // inizializzaz. pulsante invio SMS
        bnt_sms = (Button) findViewById(R.id.message_button);
        bnt_sms.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View v) 
            {
            	double lat1, lon1;
            	int i;
            	boolean find;
            	Intent intent_sms;
            	
            	if ( itemizedoverlay.geo1_premuto() ) 
            	{
                  
                  // acquisisce latitudine longitudine del punto su cui si è fatto click
                  // deve ora ritrovare il numero di tel. associato a tale punto
                  lat1 = (double)(itemizedoverlay.geo1.getLatitudeE6());
                  lon1 = (double)(itemizedoverlay.geo1.getLongitudeE6());
         
                  find =false;
                  i=0;
                  while ( (i <= lista_numeri.size() - 1) &&  (!find) )
                  {
                	  // nel confronto tronca i double per evitare differenze nelle ultime cifre decimali
                	  if ((Math.round(lat1) == Math.round(lat[i]) ) && (Math.round(lon1) == Math.round(lon[i])))   
                	 {
                		 find = true;    // trovato in posizione i
                		 Toast.makeText(getApplicationContext(), "the user has been found", Toast.LENGTH_LONG).show();
                	 }
                	 i++;
                  }
                  
                  if (find)
                  {	  
                	  if (lista_nomi.get(i-1).indexOf("closed") != -1)  // si vuol mandare un SMS ad un figlio che aveva spento ....
                	  {
                		  Toast.makeText(getApplicationContext(), "Errore: "+lista_nomi.get(i-1), Toast.LENGTH_LONG).show();
                	  }
                	  else
                	  {	  
                		intent_sms = new Intent(GeoActivity.this, SmsActivity.class);
                        // passa il numero di telefono del punto trovato a SmsActivity
                	    intent_sms.putExtra("it.devapp.android.NUMERO_SMS", lista_numeri.get(i-1));
                	    startActivity(intent_sms);
                	  }
                  } 	  
                  else
                	  Toast.makeText(getApplicationContext(), "Error: the user was not found", Toast.LENGTH_LONG).show();
                                              	  
                  itemizedoverlay.geo1 = null;
            	}  
            }
        });   
        
        // inizializzaz. pulsante mostra CONTATTI
        bnt_contatti = (Button) findViewById(R.id.contatti_button);
        // gestione del click
        bnt_contatti.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View v) 
            {
            	int requestCode = 0;  // attività richiesta = 0	
            
              Intent intent = new Intent(GeoActivity.this, ListContatti.class);
           	  startActivityForResult(intent,requestCode);	
            }
        }); 
         	
        bnt_contatti.setEnabled(true);
        // disabilita i pulsanti di SMS e Chiamata finchè non è visualizzato almeno un figlio
    	bnt_call.setEnabled(false);
    	bnt_sms.setEnabled(false);        
        
        boolean error = false;
        // serve per visualizzare il primo provider della lista fornita da locatioManager
        // final TextView my_provider = (TextView) findViewById(R.id.textProvider);
        
        // Acquisizione del riferimento al Location Manager di sistema
    // era così:  locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
     
        // Ora inizia l'ascolto degli aggiornamenti della location lo fa sia con Network che con GPS
        /**********LocationListener************/
		try
		{
			networkListner = new MyLocationListener();
			// request location updates from the Network Location Provider for cell tower and Wi-Fi based location
			// accetta richiesta ogni 20000 ms. = 20 sec e solo se si è spostato più di 10 metri
			locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, 20000, 10, networkListner);
		}
		catch (Exception exc) 
		{
			Log.i("On Create","Errore nella richiesta di updates attraverso il network provider" );
		      
		}
			
		finally
		{
			
		}
        
		gpsListener = new MyLocationListener();
		// request location updates from the GPS provider
		// accetta richiesta ogni 20000 ms. = 20 sec e solo se si è spostato più di 10 metri
		locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 20000, 10, gpsListener);
		
		/**********LocationListener************/
                     
       // criteri per la scelta del provider
       Criteria crta = new Criteria();
       crta.setAccuracy(Criteria.ACCURACY_FINE);
       crta.setAltitudeRequired(false);
       crta.setBearingRequired(false);
       crta.setCostAllowed(true);
       crta.setPowerRequirement(Criteria.POWER_LOW);
             
       // ricerca il miglior provider
       String provider = locationManager.getBestProvider(crta, true); 
       Log.i("On Create" ,"best provider= "+ provider);
          
        // Ricerca il miglior provider e lo usa per leggere l'ultima location ricevuta (presente nella cache)
        Location lastKnownLocation = locationManager.getLastKnownLocation(locationManager.getBestProvider(crta, true));
        if (lastKnownLocation == null)
        {	  
         
            error = true;
            // --------------------------------------
            // Assegna delle coordinate di prova
            // --------------------------------------
            d_lon = 12.4818;  // inizializza con le coordinate di Roma
            d_lat = 41.9109;  
            
            // -------------------------------------------
            // Genera la finestra di dialogo per conferma 
            // se continuare anche senza GPS attivo
            // -------------------------------------------
      /*      
            AlertDialog.Builder builder=new AlertDialog.Builder(this);
            builder.setTitle("warning:GPS not available!");
            builder.setMessage("Do you want to continue?");
            builder.setCancelable(false);
            builder.setPositiveButton("Yes",new OnClickListener()
            {
                              
                    public void onClick(DialogInterface dialog, int id)
                    {
                       dialog.dismiss();
                       Toast.makeText(getApplicationContext(), 
                       		"GPS not available, sets Rome as default location", Toast.LENGTH_LONG).show();
                    }
            });
            builder.setNegativeButton("No, quit",new OnClickListener()
            {
            	    
            	    public void onClick(DialogInterface dialog, int id)
                    {
            	       dialog.dismiss();
                       finish();
                    }
            });
            // fa comparire la finestra, richiamando il costruttore
            
            AlertDialog alert=builder.create();  // crea la alertDialog
            alert.setIcon(R.drawable.ic_launcher);  //imposta l'icona di geosearch
            alert.show();  // mostra la finestra di alert
            
      */    
         // ---------------------- fine finestra di dialogo ---------------   
        }    
          else
          {
            //Visualizza la posizione nella cache 
            if (lastKnownLocation.getLatitude() == 0)
            {	
       	      //my_geo.setText("nessuna posizione da GPS rilevata: ");
            }  
            else
            {   
              error = false;
              d_lat = (double) lastKnownLocation.getLatitude();      
              d_lon = (double) lastKnownLocation.getLongitude();
              
            }
          }
                  
       // rappresenta il punto del cellulare sulla mappa grazie all'overlay
       GeoPoint point = new GeoPoint((int)(d_lat * 1E6), (int)(d_lon * 1E6));
       latit = d_lat;
       longitud = d_lon;
       // Toast.makeText(getApplicationContext(), "latit = " + latit + "longitud = " + longitud, Toast.LENGTH_SHORT).show();  
       OverlayItem overlayitem = new OverlayItem(point, "I'm here", "I'm here");
       //inizializza itemizedoverlay GeoOverlay 
       itemizedoverlay.addOverlay(overlayitem);
       mapOverlays.add(itemizedoverlay);
       mapController.setZoom(12);
       mapController.animateTo(point);
       
       // salva il punto in locale nel punto my_home_point
       my_home_point = point;
       
       if (cur.moveToFirst()) 
       {

           int nameColumn = cur.getColumnIndex(ContactsContract.Profile.DISPLAY_NAME); 
                           
           // Legge il nome del proprietario del cellulare
           // deve ora inviarlo agli utenti selezionati dalla ribrica 
           // che saranno in contatto con lui
           myName = cur.getString(nameColumn);
           
       }
           
    } // ---------- fine onCreate Activity ------------------------
    
	// ---------------------------------------------------------------------
	// Classe: Geoactivity
	// Metodo: ridisegna_mappa()
	// scopo: pulisce la mappa e richiama disegna_punti() per ridisegnarla
	//        richiamato quando è cambiata la posizione di un utente
	// ---------------------------------------------------------------------
	public void ridisegna_mappa()
	{
		//cancella i punti daLLA MAPPA 
	    mapView.invalidate();
	    
	    itemizedoverlay = new GeoOverlay(drawable, mapView.getContext(), GeoActivity.this);
	    mapView.getOverlays().add(itemizedoverlay);    
	    mapView.getOverlays().clear(); 
	        	                    	                
	    disegna_punti();  // disegna la nuova mappa
	}
	
	// -------------------------------------------------------------------
	// Classe: MyLocationListener 
	// scopo: usata per gestire la posizione cambiata e segnalata da 
	//        uno dei 2 provider (Network provider o GPS provider)
	// -------------------------------------------------------------------
	
	private class MyLocationListener implements LocationListener {

		public void onLocationChanged(Location newLocation) {
			Log.v("GPSTEST", "Got New Location of provider:"+newLocation.getProvider());
			if(currentLocation!=null){
				if(isBetterLocation(newLocation, currentLocation)){
					Log.v("GPSTEST", "It's a better location");
					currentLocation=newLocation;
					//showLocation(location);
					upDateGeoPoint(newLocation);
				}
				else{
					Log.v("GPSTEST", "Not very good!");
				}
			}
			else{
				Log.v("GPSTEST", "It's first location");
				currentLocation=newLocation;
				//showLocation(newLocation);
				upDateGeoPoint(newLocation);
			}

			if(LocationManager.NETWORK_PROVIDER.equals(newLocation.getProvider())){
				locationManager.removeUpdates(this);
			}
		}
		
		public void onProviderDisabled(String provider) 
		{
			Toast.makeText(getApplicationContext(), "Provider Disabled", Toast.LENGTH_SHORT).show();  
		}

		public void onProviderEnabled(String provider) 
		{

		}

		public void onStatusChanged(String provider, int status, Bundle extras) 
		{
			switch (status) {
            case LocationProvider.AVAILABLE:
            //	Toast.makeText(getApplicationContext(), "Provider available again", Toast.LENGTH_SHORT).show(); 
            	break;
            case LocationProvider.OUT_OF_SERVICE:
            	Toast.makeText(getApplicationContext(), "Provider out of service", Toast.LENGTH_SHORT).show(); 
                break;
            case LocationProvider.TEMPORARILY_UNAVAILABLE:
            	Toast.makeText(getApplicationContext(), "Provider temporarily unavailable", Toast.LENGTH_SHORT).show(); 
            	break;
            }

		}

		// aggiorna il dafarsi quando la posizione è cambiata ed è una posizione valida
		private void upDateGeoPoint(Location newLocation){
			if(newLocation == null){
				
			}else{
				// Richiamato quando la posizione è cambiata e <> da null
	        	
	            if (itemizedoverlay == null) 
	            {  // non ci sono punti
	            	 
	               itemizedoverlay = new GeoOverlay(drawable, mapView.getContext(), GeoActivity.this);
	               mapView.getOverlays().add(itemizedoverlay);
	    		   mapView.setBuiltInZoomControls(true); 
	    		  }  
	            else  // i punti ci sono già
	            {	  
	          	mapView.invalidate();
	              itemizedoverlay = new GeoOverlay(drawable, mapView.getContext(),GeoActivity.this);
	         	    mapView.getOverlays().add(itemizedoverlay);    
	     		    mapView.setBuiltInZoomControls(true); 
	     	      }   
	            if ((newLocation!=null) && (itemizedoverlay != null))
	       	  {
	       	    
	       	    // trasforma le coordinate da gradi in microgradi        	   
	      	    latit = (double)newLocation.getLatitude();
	       	    longitud = (double)newLocation.getLongitude();
	              
	       	    mapView.invalidate();
	       	    // -----------------RIDISEGNA I PUNTI SULLA MAPPA------------------   
	       	    //cancella i punti daLLA MAPPA 
	       	    mapView.getOverlays().clear(); 
	       	   
	       	    // disegna i punti sulla mappa
	       	    disegna_punti();
	       	    
	       	    // SE E' FIGLIO ......
	       	    // comunica la nuova posizione a papà, se si sta comportando da figlio
	       	   if (is_padre == false)  // ... è un figlio
	       	   {	   
	       		  if (numero_di_papa.equals("") == false)
	       			  sendSMS(numero_di_papa,"?pos:" + longitud + " " + latit);
	       	   }
	       	   else    // è padre ....
	       		   if (in_comunicazione == true)  //Invierà la sua posizione solo se è in comunicazione con qualche figlio
	     		   {
	      		  int i = 0;  // il primo elemento è in posizione 0
	                while(i <= lista_numeri.size()-1)    // invia a tutti i figli la nuova posizione
	                {	
	                  // invia gli sms a tutti i contatti selezionati per avvisarli della posizione cambiata
	                	 sendSMS((String)lista_numeri.get(i), "?ppa:" + longitud + " " + latit);
	                 	 
	                 	 i++;
	                 }  
	             }
	       	    
	         }
			}
		} 
		
		
	 };
	
	
	// --------------------------------------------
	// inflate il menu dell'activity
	// -------------------------------------------- 
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.main_menu, menu);
		return true;
	}
    // ---------------------------------------------
	// gestisce la pressione dei tasti del menu
	// ---------------------------------------------
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
		case R.id.item1:
			finish();
			return true;
			
		case R.id.item2:
			// -------------------------------------------
            // Genera la finestra di dialogo per conferma 
            // se continuare anche senza GPS attivo
            // -------------------------------------------
            
            AlertDialog.Builder builder=new AlertDialog.Builder(this);
            builder.setTitle("About");
            builder.setMessage("Geosearch is a free/open source program (GPLv3). " +
            		"Author: Francesco Colucci. " + "http://sourceforge.org/projects/geosearch");
            builder.setCancelable(true); // può chiuderla con back
            builder.setPositiveButton("Ok",new OnClickListener()
            {
                              
                    public void onClick(DialogInterface dialog, int id)
                    {
                       dialog.dismiss();
                    }
            });
            
            // fa comparire la finestra, richiamando il costruttore
            AlertDialog alert_about=builder.create();  // crea la alertDialog
            alert_about.setIcon(R.drawable.ic_icon_geosearch);  //imposta l'icona di geosearch
            alert_about.show();  // mostra la finestra di alert
          
		    return true;
	   } // fine switch
	
		return super.onOptionsItemSelected(item);
	} // fine metodo
	
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) 
    {
   
    	int i; // posizione in cui si trova l'elemento di cui è giunta la posizione con ?pos:
    	
    	super.onActivityResult(requestCode, resultCode, data);
                
        if(resultCode == RESULT_OK)
        {
           
            extras = data.getExtras();
            
            if((extras != null) && (extras.getStringArrayList("it.devapp.android.NOMI") != null) && (inRubrica == false))	  
            {
              // è tornato dalla Rubrica con successo: diventa padre
              is_padre = true;
              
              lista_nomi = extras.getStringArrayList("it.devapp.android.NOMI");
              lista_numeri = extras.getStringArrayList("it.devapp.android.NUMERI");
              //  Toast.makeText(this, "Ritorno da una rubrica, size di lista_numeri è: " + lista_numeri.size(), Toast.LENGTH_SHORT).show();
              inRubrica = true;
        
              // disabilita un nuovo uso della rubrica contatti
              bnt_contatti.setEnabled(false); 
              
              extras = null;
              
              // legge attraverso il cursore nome e numero dell'utente ME
              if (lista_numeri.isEmpty() == false)  // ci sono utenti selezionati dalla rubrica a cui comunicare questi nome, numero e pos
              {
                 i = 0;  // il primo elemento è in posizione 0
                 while(i <= lista_numeri.size()-1)
                 {	
                     //  invia gli sms a tutti i contatti selezionati per avvisarli chi è il Papà
                	 sendSMS((String)lista_numeri.get(i), "?nam:"+myName);  // nam = nome di Papà
                     // invia un altro sms per indicare la sua posizione ai figli
                	 // sendSMS((String)lista_numeri.get(i), "?ppa:"+longitud+ " " + latit);  // ppa = posizione di papà
                	 
                	 i++;
                 }   
              }    	
           }
            
        }   
        else
        {
            Toast.makeText(this, "no contact selected", Toast.LENGTH_LONG).show();
        }

      }
    // -----------------------------------
    // disegna punti. deve essere in un threat ?
    // -------------------------------------
    
    // Richiamata quando arriva un cambio di posizione degli altri cellulari
    
	public void disegna_punti()
    {
      
    	final GeoPoint[] puntiFigli = new GeoPoint[max_nro_punti]; // max 10 punti (figli) . Il primo è messo in pos. 0
    	final OverlayItem[] puntOverlay = new OverlayItem[max_nro_punti];  // overlay dei punti dei figli -max 10- .Il primo è messo in pos. 0
    	
    	int k;    		  
        
            // Disegna ora la posizione del cellulare : quello su cui gira il programma              
    	    point = new GeoPoint((int)(latit * 1E6) ,(int)(longitud * 1E6));
    	    
    	    // setta il riferimento al punto di casa per ROAD con il nuovo punto cambiato
    	    my_home_point = point;
            
    	    //   overlayitem = new OverlayItem(puntiFigli[0], "Sono qui", "Sono qui");
    	    overlayitem = new OverlayItem(point, "I'm here", "I'm here");
    	    
            if (overlayitem != null)
            {
     	      itemizedoverlay.addOverlay(overlayitem);
     	      mapOverlays.add(itemizedoverlay);
              mapController.animateTo(point);
              
            }     
    
            // Disegna gli altri punti dei figli a partire dalla pos. 1 (in 0 c'è papà)
            if (lista_numeri.size() > 0)  // se ci sono elementi
            {
              k = 0;	
        	  while(k <= (lista_numeri.size()-1))
              {
           		if ((lat[k] != null) & (lon[k] != null))
           		{	
           		//  Log.i("Disegna Punti" ,"k = "+k+ " lat[k] = "+lat[k]);
           		
        		  puntiFigli[k] = new GeoPoint(lat[k].intValue(), lon[k].intValue());
           		  puntOverlay[k] = new OverlayItem(puntiFigli[k], (String)lista_nomi.get(k), (String)lista_nomi.get(k));
                  if (puntOverlay[k] != null)
                  {  
             	    itemizedoverlay.addOverlay(puntOverlay[k]);
             	    mapOverlays.add(itemizedoverlay);
                    mapController.animateTo(puntiFigli[k]);
                    
                  }
                 //     Log.i("Disegna Punti" ,"disegnato punto "+k);
                  
                }
           		else
           		{	
           			Log.i("Disegna Punti" ,"impossible to draw the point in position: "+k);
           		}	
           		k++;
              }	
            }
            
            // zoom a 12 ------------ 
            // Se settato è difficile ridimensionare la mappa con lo zoom o con le mani
            mapController.setZoom(12);
        
            // rende la mappa zoommabile
      //      mapView.setBuiltInZoomControls(true);
        
            // rende la mappa cliccabile
            mapView.setClickable(true);
        
     } 
 
    
     @Override
     public void finish()
     {
        super.finish();
     }
    	
  	
    @Override
    protected void onPause ()
    {
       	// unregister il receiver
    	mLocalBroadcastManager.unregisterReceiver(intentReceiver);	      
       	super.onPause();
    } 
    
    @Override
    protected void onResume ()
    {
    	// registra il receiver
    	mLocalBroadcastManager.registerReceiver(intentReceiver,intentFilter);
    	// se la lista è vuota, abilita il pulsante  contatti se non è abilitato
    	if ( (lista_numeri.isEmpty()) && (bnt_contatti.isEnabled() == false))
    		bnt_contatti.setEnabled(true);
    		  
    	super.onResume();
    	
    }
    /*
    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
      // Save UI state changes to the savedInstanceState.
      // This bundle will be passed to onCreate if the process is
      // killed and restarted.
      
      savedInstanceState.putStringArrayList("numeri_list", lista_numeri);
      savedInstanceState.putStringArrayList("nomi_list", lista_nomi);
      // etc.
      super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
      super.onRestoreInstanceState(savedInstanceState);
      // Restore UI state from the savedInstanceState.
      // This bundle has also been passed to onCreate.
      lista_numeri = savedInstanceState.getStringArrayList("numeri_list");
      lista_nomi = savedInstanceState.getStringArrayList("nomi_list");
      
    }
*/
    
    @Override
    protected void onDestroy ()
    {
    	int i;
      	// SE E' FIGLIO ......
        // comunica al papà che ha smesso, se si sta comportando da figlio
        if (is_padre == false)  // ... è un figlio
        {	   
     	  if (numero_di_papa.equals("") == false)
     		  sendSMS(numero_di_papa,"?pos:" + 0 + " " + 0);   // manda al padre ?pos: 0 0    per comunicare che ha terminato di esistere
        }
        else  if (in_comunicazione)  // è padre, e se è padre in comunicazione ....
    	{
          i = 0;  // il primo elemento è in posizione 0
          while(i <= lista_numeri.size()-1)    // invia a tutti i figli ancora in vita la posizione 0 0
          {	
             if (lista_nomi.get(i).indexOf("closed") == -1)  // se non ha trovato un figlio spento.... invia il messaggio
             {
            	 sendSMS((String)lista_numeri.get(i), "?ppa:" + 0 + " " + 0);
             }
             i++;
          }  
        }
    	if (cur != null) 
    		cur.close();
    	
    	mLocalBroadcastManager.unregisterReceiver(ShutdownReceiver);
    	super.onDestroy();
    	
//    	Toast.makeText(GeoActivity.this, "sono in onDestroy()", Toast.LENGTH_LONG).show();
    }
    
   
  //  private static final int TWO_MINUTES = 1000 * 60 * 2;

    /** Determines whether one Location reading is better than the current Location fix
      * @param location  The new Location that you want to evaluate
      * @param currentBestLocation  The current Location fix, to which you want to compare the new one
      */
    protected boolean isBetterLocation(Location location,
			Location currentBestLocation) {
		if (currentBestLocation == null) {
			// A new location is always better than no location
			return true;
		}
 
		// Check whether the new location fix is newer or older
		long timeDelta = location.getTime() - currentBestLocation.getTime();
		boolean isSignificantlyNewer = timeDelta > 30000;
		boolean isSignificantlyOlder = timeDelta < -30000;
		boolean isNewer = timeDelta > 0;
 
		// If it's been more than two minutes since the current location,
		// use the new location
		// because the user has likely moved
		if (isSignificantlyNewer) {
			return true;
			// If the new location is more than two minutes older, it must
			// be worse
		} else if (isSignificantlyOlder) {
			return false;
		}
 
		// Check whether the new location fix is more or less accurate
		int accuracyDelta = (int) (location.getAccuracy() - currentBestLocation
				.getAccuracy());
		boolean isLessAccurate = accuracyDelta > 0;
		boolean isMoreAccurate = accuracyDelta < 0;
		boolean isSignificantlyLessAccurate = accuracyDelta > 200;
 
		// Check if the old and new location are from the same provider
		boolean isFromSameProvider = isSameProvider(location.getProvider(),
				currentBestLocation.getProvider());
 
		// Determine location quality using a combination of timeliness and
		// accuracy
		if (isMoreAccurate) {
			return true;
		} else if (isNewer && !isLessAccurate) {
			return true;
		} else if (isNewer && !isSignificantlyLessAccurate
				&& isFromSameProvider) {
			return true;
		}
		return false;
	}
    
    /** Checks whether two providers are the same */
	private boolean isSameProvider(String provider1, String provider2) {
		if (provider1 == null) {
			return provider2 == null;
		}
		return provider1.equals(provider2);
	}
    
    
    //---sends an SMS message to another device---
    private void sendSMS(String phoneNumber, String message)
    {        
        // cripta il messaggio
    	String crypto;
		try 
		{
	      crypto = SimpleCrypto.encrypt("xx12Tsa9", message);
		
    	
    	  PendingIntent pi = PendingIntent.getActivity(this, 0,
          new Intent(this, GeoActivity.class), 0);                
          SmsManager sms = SmsManager.getDefault();
          // sms.sendTextMessage(phoneNumber, null, message, pi, null); 
          // invia il messaggio criptato
          sms.sendTextMessage(phoneNumber, null, crypto, pi, null);
           
		} catch (Exception e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }  
    
}   // FINE CLASSE GeoActivity