/**
 * vertretungsplan.io android client
 *
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see https://www.gnu.org/licenses/.
 */
package io.vertretungsplan.client.android.ui.viewer.html

import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.webkit.WebResourceResponse
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.appcompat.app.AppCompatActivity
import io.vertretungsplan.client.android.data.CasProvider
import io.vertretungsplan.client.android.databinding.ActivityHtmlViewerBinding
import io.vertretungsplan.client.android.registry.DefaultAppRegistry
import okhttp3.MediaType.Companion.toMediaTypeOrNull

class HtmlViewerActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val binding = ActivityHtmlViewerBinding.inflate(layoutInflater)

        setContentView(binding.root)

        binding.webview.settings.apply {
            allowFileAccess = false
            allowContentAccess = true
            javaScriptEnabled = false
            builtInZoomControls = false
            setSupportZoom(false)
            blockNetworkImage = true
            blockNetworkLoads = true
        }

        binding.webview.webViewClient = object: WebViewClient() {
            override fun shouldInterceptRequest(
                view: WebView?,
                url: String?
            ): WebResourceResponse? {
                // workaround for old android versions

                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M && url != null && url.startsWith(CasProvider.BASE)) {
                    val uri = Uri.parse(url)
                    val hash = uri.getQueryParameter(CasProvider.URL_PARAM_SHA512)!!
                    val type = uri.getQueryParameter(CasProvider.URL_PARAM_MIME_TYPE)!!
                    val file = DefaultAppRegistry.with(this@HtmlViewerActivity).cas.getFileByHash(hash)

                    val mediaType = type.toMediaTypeOrNull()

                    if (mediaType != null) {
                        return WebResourceResponse("${mediaType.type}/${mediaType.subtype}", mediaType.parameter("charset"), file.inputStream())
                    }
                }

                return super.shouldInterceptRequest(view, url)
            }
        }

        binding.webview.loadUrl(intent.data!!.toString())

        binding.backButton.setOnClickListener { finish() }
    }
}
