/**
 * vertretungsplan.io android client
 *
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see https://www.gnu.org/licenses/.
 */
package io.vertretungsplan.client.android.ui.selectserver

import android.app.Activity
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import io.vertretungsplan.client.android.BuildConfig
import io.vertretungsplan.client.android.R
import io.vertretungsplan.client.android.data.dao.setValueSync
import io.vertretungsplan.client.android.data.model.config.ConfigItemKey
import io.vertretungsplan.client.android.databinding.ActivitySelectServerBinding
import io.vertretungsplan.client.android.registry.DefaultAppRegistry
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class SelectServerActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val binding = ActivitySelectServerBinding.inflate(layoutInflater)

        setContentView(binding.root)

        if (savedInstanceState == null) {
            binding.serverUrl.setText(BuildConfig.defaultServerUrl)
        }

        binding.text.text = getString(
            R.string.selectserver_text,
            BuildConfig.defaultServerPrivacyUrl
        )

        binding.btnGo.setOnClickListener {
            val database = DefaultAppRegistry.with(this).database

            GlobalScope.launch {
                withContext(Dispatchers.IO) {
                    database.config().setValueSync(ConfigItemKey.LIST_SERVER_URL, binding.serverUrl.text.toString())
                }

                withContext(Dispatchers.Main) {
                    setResult(Activity.RESULT_OK)
                    finish()
                }
            }
        }
    }
}
