/**
 * vertretungsplan.io android client
 *
 * Copyright (C) 2019 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see https://www.gnu.org/licenses/.
 */
package io.vertretungsplan.client.android.ui.selectinstitution

import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import io.vertretungsplan.client.android.data.model.Institution
import kotlin.properties.Delegates

class InstitutionAdapter: RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    var items: List<Institution> by Delegates.observable(emptyList()) { _, _, _ -> notifyDataSetChanged() }
    var listener: InstitutionListListener? = null

    init {
        setHasStableIds(true)
    }

    override fun getItemCount(): Int = items.size
    override fun getItemId(position: Int): Long = items[position].id.hashCode().toLong()

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder = object: RecyclerView.ViewHolder(
        LayoutInflater.from(parent.context).inflate(
            android.R.layout.simple_list_item_1, parent, false
        )
    ) {}

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val item = items[position]

        (holder.itemView as TextView).text = item.title

        holder.itemView.setOnClickListener { listener?.onInstitutionClicked(item) }
    }
}

interface InstitutionListListener {
    fun onInstitutionClicked(item: Institution)
}