/*
 * TimeLimit Copyright <C> 2019 - 2024 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
package io.timelimit.android.ui.diagnose.exception

import android.content.Context
import io.timelimit.android.R
import io.timelimit.android.integration.platform.android.foregroundapp.InstanceIdForegroundAppHelper.InstanceIdException
import java.io.PrintWriter
import java.io.StringWriter

object ExceptionUtil {
    fun formatInterpreted(context: Context, tr: Throwable): String {
        val explain = when (tr) {
            is InstanceIdException.EventsNotSortedByTimestamp -> context.getString(R.string.background_logic_errpr_detailed_instanceid_sorting)
            else -> null
        }

        val tr2 = formatSimple(tr)

        return if (explain != null) "$explain\n\n$tr2"
        else tr2
    }

    private fun formatSimple(tr: Throwable): String = StringWriter().let { sw ->
        PrintWriter(sw).let { pw ->
            tr.printStackTrace(pw)
            pw.flush()
        }

        sw.toString()
    }
}