use std::process::Command;

use tools::{get_translations, write_translations};

fn main() {
    let mut translations = get_translations();

    let output = Command::new("npm")
        .args(["run", "tolgee"])
        .current_dir("frontend")
        .output()
        .expect("Failed to run tolgee");

    let mut failed = false;
    for line in str::from_utf8(&output.stdout)
        .expect("Failed to decode")
        .lines()
        .filter(|line| line.contains("line") && !line.contains("Dynamic"))
    {
        let key = line
            .split_whitespace()
            .last()
            .expect("Failed to find last element");

        if !translations.contains_key(key) {
            println!("Key {key} is missing");
            translations.insert(key.to_string(), String::from("TODO"));
            failed = true;
        }
    }

    if failed {
        write_translations(&translations);
        panic!("Failed to find all the keys")
    }
}
