use rand::{Rng as _, prelude::IndexedRandom as _};
use sea_orm::Iterable as _;
use serde::Serialize;
use strum::EnumIter;
use ts_rs::TS;

#[derive(Serialize, EnumIter, Clone, TS)]
#[ts(export)]
pub enum RuinPurpose {
    Archive,
    Decorative,
    Villa,
    Fortification,
    Hall,
    Inn,
    Observatory,
    Road,
    Tomb,
    Workshop,
    Wondrous,
    DarkPurposes,
}

#[derive(Serialize, EnumIter, Clone, TS)]
#[ts(export)]
pub enum RuinAppearance {
    Crumbling,
    Fallen,
    Overgrown,
    PartlyBuried,
    PartiallyCollapsed,
    Sunken,
}

#[derive(Serialize, TS)]
#[ts(export)]
pub enum RuinUse {
    Abandoned,
    HideoutLair,
    Infested,
    Refuge,
    Haunted,
}

impl RuinUse {
    fn get(value: u32) -> Self {
        if value < 8 {
            Self::Abandoned
        } else if value == 9 {
            Self::HideoutLair
        } else if value == 10 {
            Self::Infested
        } else if value == 11 {
            Self::Refuge
        } else if value == 12 {
            Self::Haunted
        } else {
            panic!("Should not happen")
        }
    }
}

#[derive(Serialize, TS)]
#[ts(export)]
pub struct Ruin {
    purpose: RuinPurpose,
    appearance: RuinAppearance,
    present_use: RuinUse,
}

impl Ruin {
    pub fn get_ruin() -> Self {
        let mut rng = rand::rng();
        Self {
            present_use: RuinUse::get(rng.random_range(1..=12)),
            appearance: RuinAppearance::iter()
                .collect::<Vec<RuinAppearance>>()
                .choose(&mut rng)
                .expect("Failed to get an appearance")
                .clone(),
            purpose: RuinPurpose::iter()
                .collect::<Vec<RuinPurpose>>()
                .choose(&mut rng)
                .expect("Failed to get a purpose")
                .clone(),
        }
    }
}
