// Prevents additional console window on Windows in release, DO NOT REMOVE!!
#![cfg_attr(
    all(not(debug_assertions), target_os = "windows"),
    windows_subsystem = "windows"
)]

#[cfg(feature = "server")]
#[tokio::main]
#[expect(clippy::unwrap_in_result)]
async fn main() -> anyhow::Result<()> {
    use anyhow::Context as _;
    use std::{net::Ipv4Addr, path::PathBuf};
    use the_one_app_lib::{config::CONFIG, server::backend};
    use tokio::net::TcpListener;
    use tower_http::services::ServeDir;

    // Get directories
    let current_dir = PathBuf::from(".");

    let mut config = CONFIG.lock().await;
    config.configure(&current_dir);

    let ip = if config.expose_server() {
        eprintln!("Exposing rocket");
        Ipv4Addr::UNSPECIFIED
    } else {
        eprintln!("Running on localhost");
        Ipv4Addr::LOCALHOST
    };
    let port = 8000;

    let frontend_path = config.frontend_path().clone();
    drop(config);

    let server = backend::get_server()
        .await
        .context("Failed to get server")?
        .fallback_service(ServeDir::new(frontend_path));

    let listener = TcpListener::bind(format!("{ip}:{port}")).await?;
    axum::serve(listener, server).await?;

    Ok(())
}

#[cfg(feature = "tauri")]
pub fn main() {
    use the_one_app_lib::start_with_tauri;

    start_with_tauri();
}
